block('p-multiedit2').elem('outboard-popup')(

    /**
     * @param {String} id идентификатор b-outboard-controls который будет передан в js параметры
     * @param {Object} outboardAttrs атрибуты элемента b-outboard-controls
     * @param {Object} mixes миксины элемента b-outboard-controls
     * @param {String} autoclosable если 'yes' то при клике вне попапа он закроется
     * @param {BEMJSON} innerBlock содержимое попапа
     * @param {BEMJSON} buttons кнопки попапа
     * @param {String} acceptButtonText текст кнопки подтверждения
     * @param {String|Boolean} header заголовок попапа
     */
    replace()(function() {
        return {
            block: 'b-outboard-controls',
            js: {
                id: this.id
            },
            attrs: this.outboardAttrs,
            mixes: this.mixes,
            content: {
                elem: 'popup',
                autoclosable: this.autoclosable,
                header: this.header,
                innerBlock: applyCtx(this.innerBlock),
                buttons: this.buttons,
                acceptButtonText: this.acceptButtonText
            }
        };
    }),

    elemMod('type', 'pic-selector-control').def()(function() {
        var campaign = this.data.campaign;

        return applyNext({
            id: 'pic-selector-control',
            outboardAttrs: {
                id: 'pic-selector-control'
            },
            innerBlock: applyCtx({
                block: 'b-pic-selector',
                mods: {
                    location: 'outboard'
                },
                cid: campaign.cid,
                mediaType: campaign.mediaType,
                images: campaign.images,
                clientId: campaign.ClientID
            }),
            buttons: false,
            header: false
        });
    }),

    elemMod('type', 'mobile-pic-selector-control').def()(function() {
        var campaign = this.data.campaign;

        return applyNext({
            id: 'pic-selector-control',
            outboardAttrs: {
                id: 'pic-selector-control'
            },
            innerBlock: {
                block: 'b-pic-selector',
                mods: {
                    location: 'outboard',
                    type: 'mobile-content'
                },
                cid: campaign.cid,
                mediaType: campaign.mediaType,
                images: campaign.images,
                clientId: campaign.ClientID
            },
            buttons: false,
            header: false
        });
    }),

    elemMod('type', 'wordstat-control').def()(function() {
        return applyNext({
            id: 'wordstat-control',
            mixes: {
                center: {
                    block: 'b-wordstat',
                    elem: 'popup-center'
                }
            },
            innerBlock: this.ctx.innerBlock || {
                block: 'b-wordstat'
            },
            directions: [{
                to: 'right',
                axis: 'top',
                offset: {
                    top: -15
                },
                tail: {
                    offset: {
                        top: 5
                    }
                }
            }],
            autoclosable: 'yes',
            buttons: false,
            header: false
        });
    }),

    elemMod('type', 'sitelinks-selector-control').def()(function() {
        var campaign = this.data.campaign;

        return applyNext({
            id: 'sitelinks-selector-control',
            outboardAttrs: {
                id: 'sitelinks-selector-control'
            },
            innerBlock: {
                block: 'b-sitelinks-selector',
                mods: u._.extend({
                    mode: 'banner'
                }, this.ctx.innerBlockMods || {}),
                js: {
                    id: 'multiedit-sitelinks-selector'
                },
                modelId: 'banner',
                clientId: campaign.ClientID,
                fullInfo: true
            },
            buttons: applyCtx({
                block: 'b-sitelinks-selector',
                elem: 'buttons',
                mods: u._.extend({
                    mode: 'banner'
                }, this.ctx.buttonsMods || {}),
                js: {
                    id: 'multiedit-sitelinks-selector'
                },
                modelId: 'banner'
            })
        });
    })
);
