BEM.DOM.decl({ block: 'p-multiedit2', modName: 'type', modVal: 'content-promotion' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);
        }
    },

    /**
     * Инициализация необходимых моделей
     * @override
     * @private
     */
    _initModels: function() {
        this.__base.apply(this, ['m-campaign']);

        this._groupsModels = this.params.groupsIds.map(function(id) {
            return BEM.MODEL.getOrCreate({
                name: 'dm-content-promotion-group',
                id: id
            });
        });
    },

    /**
     * Находит блоки, подписывается на события
     * @private
     */
    _initEvents: function() {
        this.__base.call(this);

        this._submit.un('click');
        this._subscriptions.on(this._submit, 'click', this._onSubmit, this);
        this._subscriptions.on(BEM.blocks['b-edit-group-2'], 'ready', function(e, data) {
            (this._editBlocks || (this._editBlocks = this.findBlocksInside('b-edit-group-2')).every(function(block) {
                return block.isReady();
            })) && this._toggleButtonsPanel(false);
        }, this);
    },

    /**
     * Обработчик нажатия на кнопку назад
     * @param {Event} e - событие
     * @returns {Boolean}
     * @private
     */
    _onSubmit: function(e) {
        e.preventDefault();

        this._submitForm();
    },

    /**
     * Валидирует и отправляет форму
     * @private
     */
    _submitForm: function() {
        var _this = this;

        if (!_this._validateGroups()) {
            return;
        }

        _this._confirmDomainChange().then(function() {
            _this._toggleButtonsPanel(true)
                .setMod(_this.elem('status-message'), 'progress', 'yes');

            var groupsData = _this._getGroupsData(),
                requestData = _this._getRequestData(groupsData),
                groupData,
                groupType;

            requestData.save_draft || (requestData.save_draft = false);
            requestData.is_copy || (requestData.is_copy = false);

            if (requestData.is_new_adgroups && groupsData[0]) {
                groupData = groupsData[0];

                groupType = {};
                groupType[groupData.content_promotion_content_type] = true;

                BEM.blocks['b-metrika2'].reachGoal({
                    target: 'GROUP_WITH_BANNERS_CLICKED_SAVE',
                    id: 191494,
                    params: {
                        groupWithBanners: groupType
                    }
                });
            }

            return BEM.blocks['i-web-api-request'].adGroups
                .saveContentPromotionVideoAdGroup(requestData)
                .then(function(data) {
                    _this.delMod(_this.elem('status-message'), 'progress');

                    data.success ?
                        _this._successfulSave(data, requestData.is_new_adgroups) :
                        _this._notSuccessfulSave(data, groupsData)
                            ._toggleButtonsPanel(false);
                })
                .catch(function() {
                    _this._toggleButtonsPanel(false)
                        .delMod(_this.elem('status-message'), 'progress');

                    BEM.blocks['b-user-dialog']
                        .alert(iget2(
                            'p-multiedit2',
                            'text-adgroup-save-error',
                            'Ошибка сохранения. Попробуйте ещё раз.'
                        ));
                });
        });
    },

    /**
     * Валидирует группы, находящиеся на редактировании
     * @returns {Boolean}
     * @override
     * @private
     */
    _validateGroups: function() {
        if (u.consts('disable_client_validation')) return true;

        var errors = [];

        this._groupsModels.forEach(function(groupModel, groupIndex) {
            var groupValidate = groupModel.validate();

            if (!groupValidate.valid) {
                u._.keys(groupValidate.errorsData).forEach(function(field) {
                    var path = '[' + groupIndex + '].' + this._replaceBadField(field, groupModel);

                    groupValidate.errorsData[field].forEach(function(error) {
                        errors.push({
                            path: path,
                            description: error.text
                        });
                    });
                }, this);
            }

            groupModel.getBanners().forEach(function(bannerModel, bannerIndex) {
                var bannerValidate = bannerModel.validate();

                if (!bannerValidate.valid) {
                    u._.keys(bannerValidate.errorsData).forEach(function(field) {
                        var badField = this._replaceBadField(field, groupModel),
                            path = '[' + groupIndex + '].banners[' + bannerIndex + '].' + badField;

                        bannerValidate.errorsData[field].forEach(function(error) {
                            errors.push({
                                path: path,
                                description: error.text
                            });
                        });
                    }, this);
                }
            }, this);

        }, this);

        if (errors.length) {
            this._showJavaErrors(errors);
        }

        return !errors.length;
    },

    _replaceBadField: function(field, groupModel) {
        this._badFields || (this._badFields = {
            href_model: 'href',
            retargetingsInterests: 'targetInterests',
            general_limit_price: 'auto_price',
            phrases: 'keywords',
            new_phrases: 'new_keywords',
            new_suggestions: 'keywords_suggestions',
            outdoorPoints: 'pageBlocks'

        });

        // @skywhale Так как элемент «new-phrases» скрыт, пока пользователь не нажмет «упорядочить и уточнить».
        // Показываем ошибку у элемента «word-suggestions»
        if (field === 'new_phrases' && u._.isEmpty(groupModel.get('newPhrasesIds'))) {
            return 'keywords_suggestions';
        }

        return this._badFields[field] || field;
    },

    _getGroupData: function(groupModel) {
        var data = this.__base.apply(this, arguments);

        data.keywords = groupModel.getPhrasesData().map(function(phrase) {
            return u._.omit(phrase, ['param1', 'param2']);
        });

        // data.cid = parseInt(data.cid, 10);

        return data;
    }

});
