/**
 * Страничный блок: Мультиредактирование
 * @param {Object} this.params js-параметры блока
 * @param {String} this.params.cid Идентификатор кампании
 * @param {Array} this.params.groupsIds Идентификаторы групп в кампании
 */
BEM.DOM.decl({ block: 'p-multiedit2', modName: 'type', modVal: 'cpm-banner' }, {

    /**
     * Убираем инициацию, нет уточнений
     * @override
     * @private
     */
    _initCallouts: function() {},

    /**
     * Находит блоки, подписывается на события
     * @private
     */
    _initEvents: function() {
        this.__base.call(this);

        this._submit.un('click');
        this._subscriptions.on(this._submit, 'click', this._onSubmit, this);
        this._subscriptions.on(BEM.blocks['b-edit-group-2'], 'ready', function(e, data) {
            (this._editBlocks || (this._editBlocks = this.findBlocksInside('b-edit-group-2')).every(function(block) {
                return block.isReady();
            })) && this._toggleButtonsPanel(false);
        }, this);
    },

    /**
     * Инициирует модели, необходимые для блока
     * @private
     */
    _initModels: function() {
        this.__base.apply(this, ['dm-cpm-banner-campaign']);

        this._groupsModels = this.params.groupsIds.map(function(id) {
            return BEM.MODEL.getOrCreate({
                name: 'dm-cpm-banner-group',
                id: id
            });
        });
    },

    /**
     * Обработчик нажатия на кнопку «Сохранить»
     * @param {Event} e - событие
     * @returns {Boolean}
     * @private
     */
    _onSubmit: function(e) {
        e.preventDefault();

        this._submitForm();
    },

    /**
     * Валидирует и отправляет форму
     * @private
     */
    _submitForm: function() {
        var _this = this;

        if (!_this._validateGroups()) {
            return;
        }

        _this._confirmDomainChange().then(function() {
            _this._confirmDisplayConditions().then(function() {
                _this._toggleButtonsPanel(true)
                    .setMod(_this.elem('status-message'), 'progress', 'yes');

                var groupsData = _this._getGroupsData(),
                    requestData = _this._getRequestData(groupsData),
                    groupData,
                    groupType;

                requestData.save_draft || (requestData.save_draft = false);
                requestData.is_copy || (requestData.is_copy = false);

                if (requestData.is_new_adgroups && groupsData[0]) {
                    groupData = groupsData[0];

                    groupType = {};
                    groupType[groupData.cpm_banners_type] = true;

                    BEM.blocks['b-metrika2'].reachGoal({
                        target: 'GROUP_WITH_BANNERS_CLICKED_SAVE',
                        id: 191494,
                        params: {
                            groupWithBanners: groupType
                        }
                    });
                }

                return BEM.blocks['i-web-api-request'].adGroups
                    .saveCpmAdGroup(requestData)
                    .then(function(data) {
                        _this.delMod(_this.elem('status-message'), 'progress');

                        data.success ?
                            _this._successfulSave(data, requestData.is_new_adgroups) :
                            _this._notSuccessfulSave(data, groupsData)
                                ._toggleButtonsPanel(false);
                    })
                    .catch(function() {
                        _this._toggleButtonsPanel(false)
                            .delMod(_this.elem('status-message'), 'progress');

                        BEM.blocks['b-user-dialog']
                            .alert(iget2(
                                'p-multiedit2',
                                'text-adgroup-save-error',
                                'Ошибка сохранения. Попробуйте ещё раз.'
                            ));
                    });
            })
        });
    },

    _confirmDisplayConditions: function() {
        return new Promise(function(resolve) {
            if (!this._isEmptyRetargetingInterests()) {
                resolve();
            } else {
                BEM.blocks['b-user-dialog'].confirm({
                    message: iget2(
                        'p-multiedit2',
                        'vybrana-vsja-auditorija-soglasno-regionu',
                        'Выбрана вся аудитория, согласно региону. Продолжить?'
                    ),
                    onConfirm: function() {
                        resolve();
                    }
                });
            }
        }.bind(this));
    },

    /**
     * Проверяет группы на пустые сегменты
     * @returns {Boolean}
     * @private
     */
    _isEmptyRetargetingInterests: function() {
        return this._groupsModels.some(function(groupModel) {
            if (groupModel.get('cpmGroupType') === 'cpm_outdoor' || groupModel.get('cpmGroupType') === 'cpm_indoor') {
                return false;
            }

            return groupModel.get('displayConditions') === 'crypta' ?
                groupModel.isEmptyRetargetingInterests() :
                false;
        });
    },

    /**
     * @override {p-multiedit2}
     */
    _getGroupData: function(groupModel, groupIndex) {
        var originalData = groupModel.provideData(),
            cpmGroupType = groupModel.get('cpmGroupType'),
            data = u._.pick(originalData, [
                'adgroup_id',
                'adgroup_type',
                'tags',
                'geo',
                'group_name',
                'cpm_banners_type',
                'page_blocks'
            ]),
            isSegmentsDisabled = (data.cpm_banners_type === 'cpm_indoor') && this.params.isIndoorSegmentsDisabled,
            bannersType = data.cpm_banners_type;

        if (originalData.video_goals && !isSegmentsDisabled) {
            data.video_goals = this._getVideoGoals(data.cpm_banners_type, originalData.video_goals);
        }

        data.banners = originalData.banners.map(function(banner) {
            return u._.pick(banner, [
                'pixels',
                'ad_type',
                'bid',
                'href',
                'url_protocol',
                'creative',
                'turbolanding',
                'turbolandingIsActive',
                'turbolanding_href_params',
                'tns_id',
                'measurers'
            ]);
        });

        // TODO @skywhale cpm_outdoor заменить к открытию на всех
        if (bannersType === 'cpm_outdoor' || bannersType === 'cpm_indoor') {
            var emptyRetargeting = {
                    condition_name: iget2('b-audience-selection', 'novaya-auditoriya', 'Новая аудитория'),
                    description: '',
                    type: 'interests',
                    groups: []
                },
                doohRetargetings = this.params.doohRetargetings,
                groupRetargeting = u._.isArray(doohRetargetings) && doohRetargetings[groupIndex],
                priceContext = groupModel.getAutoPriceData(),
                retargetings = u._.isEmpty(groupRetargeting) ?
                    [emptyRetargeting] :
                    groupRetargeting.map(function(retargeting) {
                        return u._.extend({}, retargeting, emptyRetargeting);
                    }),
                multipliers = {
                    cpm_indoor: ['demography_multiplier'],
                    cpm_outdoor: ['weather_multiplier', 'expression_multipliers']
                };

            if (!priceContext.auto) {
                retargetings = retargetings.map(function(retargeting) {
                    retargeting.price_context = priceContext.single_price;

                    return retargeting;
                });
            }

            data.retargetings = retargetings;
            delete data.geo;
            data.hierarchical_multipliers = u._.pick(
                groupModel.getMultipliersData(), multipliers[bannersType]
            );

            return data;
        }

        switch (groupModel.get('displayConditions')) {
            case 'crypta':
                data.retargetings = groupModel
                    .getRetargetingsInterestsData()
                    .map(function(retargeting) {
                        var price = groupModel.getAutoPriceData();

                        // для крипты общую ставку прокидываем самостоятельно на все условия
                        if (!price.auto) {
                            retargeting.price_context = price.single_price;
                        }

                        return retargeting;
                    });

                if (cpmGroupType === 'cpm_audio') {
                    data.hierarchical_multipliers = u._.pick(groupModel.getMultipliersData(), ['weather_multiplier']);
                } else {
                    data.hierarchical_multipliers = u._.pick(
                        groupModel.getMultipliersData(),
                        []
                            .concat(
                                (cpmGroupType === 'cpm_video' ? this.params.allowCpmVideoDevicesModifiers : true) ?
                                    ['mobile_multiplier', 'desktop_multiplier'] :
                                    []
                            )
                            .concat(['weather_multiplier'])
                    );
                }

                break;
            case 'keywords':
                data.auto_price = groupModel.getAutoPriceData();
                data.minus_words = originalData.minus_words;
                data.keywords = groupModel.getPhrasesData().map(function(phrase) {
                    return u._.omit(phrase, ['param1', 'param2']);
                });

                data.hierarchical_multipliers = groupModel.getMultipliersData();
                break;
        }

        return data;
    },

    _replaceBadField: function(field, groupModel) {
        this._badFields || (this._badFields = {
            href_model: 'href',
            retargetingsInterests: 'targetInterests',
            general_limit_price: 'auto_price',
            phrases: 'keywords',
            new_phrases: 'new_keywords',
            new_suggestions: 'keywords_suggestions',
            outdoorPoints: 'pageBlocks',
            indoorPoints: 'pageBlocks'

        });

        // @skywhale Так как элемент «new-phrases» скрыт, пока пользователь не нажмет «упорядочить и уточнить».
        // Показываем ошибку у элемента «word-suggestions»
        if (field === 'new_phrases' && u._.isEmpty(groupModel.get('newPhrasesIds'))) {
            return 'keywords_suggestions';
        }

        return this._badFields[field] || field;
    },

    /**
     * Валидирует группы, находящиеся на редактировании
     * @returns {Boolean}
     * @override
     * @private
     */
    _validateGroups: function() {
        if (u.consts('disable_client_validation')) return true;

        var errors = [];

        this._groupsModels.forEach(function(groupModel, groupIndex) {
            var groupValidate = groupModel.validate();

            if (!groupValidate.valid) {
                u._.keys(groupValidate.errorsData).forEach(function(field) {
                    var path = '[' + groupIndex + '].' + this._replaceBadField(field, groupModel);

                    groupValidate.errorsData[field].forEach(function(error) {
                        errors.push({
                            path: path,
                            description: error.text
                        });
                    });
                }, this);
            }

            groupModel.getBanners().forEach(function(bannerModel, bannerIndex) {
                var bannerValidate = bannerModel.validate();

                if (!bannerValidate.valid) {
                    u._.keys(bannerValidate.errorsData).forEach(function(field) {
                        var badField = this._replaceBadField(field, groupModel),
                            path = '[' + groupIndex + '].banners[' + bannerIndex + '].' + badField;

                        bannerValidate.errorsData[field].forEach(function(error) {
                            errors.push({
                                path: path,
                                description: error.text
                            });
                        });
                    }, this);
                }
            }, this);

        }, this);

        if (errors.length) {
            this._showJavaErrors(errors);
        }

        return !errors.length;
    },

    /**
     * Достижение цели
     * @private
     */
    _metrikaReachGoal: function() {
        // создание новой кампании
        if (this._campModel.get('isCreatingNewCamp')) {
            BEM.blocks['b-metrika2'].reachGoal('CPM_CAMPAIGN_SAVED_STEP2');
        }
    },

    /**
     * Получение данных по сбору аудитории
     * @private
     */
    _getVideoGoals: function(bannerType, goals) {
        var videoGoalsTypes;

        switch (bannerType) {
            case 'cpm_outdoor':
                videoGoalsTypes = u.consts('OUTDOOR_GOALS_AUDITORY_TYPES') || [];
                break;
            case 'cpm_indoor':
                videoGoalsTypes = u.consts('INDOOR_GOALS_AUDITORY_TYPES') || [];
                break;
            case 'cpm_audio':
                videoGoalsTypes = u.consts('AUDIO_GOALS_AUDITORY_TYPES') || [];
                break;
            default:
                videoGoalsTypes = u.consts('VIDEO_GOALS_AUDITORY_TYPES') || [];
        }

        return goals.filter(function(goal) {return u._.includes(videoGoalsTypes, goal.type)});
    }

});
