/**
 * Страничный блок: Мультиредактирование
 * @param {Object} this.params js-параметры блока
 * @param {String} this.params.cid Идентификатор кампании
 * @param {Array} this.params.groupsIds Идентификаторы групп в кампании
 */
BEM.DOM.decl({ block: 'p-multiedit2', modName: 'type', modVal: 'cpm-yndx-frontpage' }, {

    onSetMod: {

        js: function() {
            this.__base.apply(this, arguments);

            BEM.blocks['cpm-yndx-frontpage-min-price'].initGroupsMinPrice(
                this._campModel.get('cid'),
                this._groupsModels.map(function(group) {
                    return {
                        geo: group.getGeoModel().get('geo'),
                        price: group.get('general_limit_price'),
                        adgroup_id: group.get('adgroup_id')
                    }
                })
            );
        }
    },

    /**
     * Убираем инициацию, нет уточнений
     * @override
     * @private
     */
    _initCallouts: function() {},

    /**
     * Находит блоки, подписывается на события
     * @private
     */
    _initEvents: function() {
        this.__base.call(this);

        this._submit.un('click');
        this._subscriptions.on(this._submit, 'click', this._onSubmit, this);
        this._subscriptions.on(BEM.blocks['b-edit-group-2'], 'ready', function(e, data) {
            (this._editBlocks || (this._editBlocks = this.findBlocksInside('b-edit-group-2')).every(function(block) {
                return block.isReady();
            })) && this._toggleButtonsPanel(false);
        }, this);
    },

    /**
     * Инициирует модели, необходимые для блока
     * @private
     */
    _initModels: function() {
        this.__base.apply(this, ['dm-cpm-yndx-frontpage-campaign']);

        this._groupsModels = this.params.groupsIds.map(function(id) {
            return BEM.MODEL.getOrCreate({
                name: 'dm-cpm-yndx-frontpage-banner-group',
                id: id
            });
        });
    },

    /**
     * Обработчик нажатия на кнопку «Сохранить»
     * @param {Event} e - событие
     * @returns {Boolean}
     * @private
     */
    _onSubmit: function(e) {
        e.preventDefault();

        this._submitForm();
    },

    /**
     * Валидирует и отправляет форму
     * @private
     */
    _submitForm: function() {
        var _this = this;

        if (!_this._validateGroups()) {
            return;
        }

        _this._confirmDomainChange().then(function() {
            _this._confirmDisplayConditions().then(function() {
                _this._toggleButtonsPanel(true)
                    .setMod(_this.elem('status-message'), 'progress', 'yes');

                var groupsData = _this._getGroupsData(),
                    requestData = _this._getRequestData(groupsData);

                requestData.save_draft || (requestData.save_draft = false);
                requestData.is_copy || (requestData.is_copy = false);

                if (requestData.is_new_adgroups) {
                    BEM.blocks['b-metrika2'].reachGoal({
                        target: 'GROUP_WITH_BANNERS_CLICKED_SAVE',
                        id: 191494,
                        params: {
                            groupWithBanners: {
                                cpm_yndx_frontpage: true
                            }
                        }
                    });
                }

                return BEM.blocks['i-web-api-request'].adGroups
                    .saveCpmAdGroup(requestData)
                    .then(function(data) {
                        _this.delMod(_this.elem('status-message'), 'progress');

                        data.success ?
                            _this._successfulSave(data, requestData.is_new_adgroups) :
                            _this._notSuccessfulSave(data, groupsData)
                                ._toggleButtonsPanel(false);
                    })
                    .catch(function() {
                        _this._toggleButtonsPanel(false)
                            .delMod(_this.elem('status-message'), 'progress');

                        BEM.blocks['b-user-dialog']
                            .alert(iget2(
                                'p-multiedit2',
                                'text-adgroup-save-error',
                                'Ошибка сохранения. Попробуйте ещё раз.'
                            ));
                    });
            })
        });
    },

    _confirmDisplayConditions: function() {
        return new Promise(function(resolve) {
            if (!this._isEmptyRetargetingInterests()) {
                resolve();
            } else {
                var cryptaEnabled = this._editBlocks.some(function(block) {
                    return !!block.elem('crypta').length;
                });

                if (cryptaEnabled) {
                    BEM.blocks['b-user-dialog'].confirm({
                        message: iget2(
                            'p-multiedit2',
                            'vybrana-vsja-auditorija-soglasno-regionu',
                            'Выбрана вся аудитория, согласно региону. Продолжить?'
                        ),
                        onConfirm: function() {
                            resolve();
                        }
                    });
                } else {
                    resolve();
                }
            }
        }.bind(this));
    },

    /**
     * Проверяет группы на пустые сегменты
     * @returns {Boolean}
     * @private
     */
    _isEmptyRetargetingInterests: function() {
        return this._groupsModels.some(function(groupModel) {
            return groupModel.get('displayConditions') === 'crypta' ?
                groupModel.isEmptyRetargetingInterests() :
                false;
        });
    },

    /**
     * @override {p-multiedit2}
     */
    _getGroupData: function(groupModel) {
        var originalData = groupModel.provideData(),
            data = u._.pick(originalData, [
                'adgroup_id',
                'adgroup_type',
                'tags',
                'geo',
                'group_name',
                'cpm_yndx_frontpages_type',
                'video_goals'
            ]);

        data.banners = originalData.banners.map(function(banner) {
            return u._.pick(banner, [
                'pixels',
                'ad_type',
                'bid',
                'href',
                'url_protocol',
                'creative',
                'turbolanding',
                'turbolandingIsActive',
                'turbolanding_href_params',
                'tns_id',
                'measurers'
            ]);
        });

        switch (groupModel.get('displayConditions')) {
            case 'crypta':
                data.retargetings = groupModel
                    .getRetargetingsInterestsData()
                    .map(function(retargeting) {
                        var price = groupModel.getAutoPriceData(),
                            badInterestType = {
                                short_term: 'short-term',
                                long_term: 'long-term'
                            };

                        // для крипты общую ставку прокидываем самостоятельно на все условия
                        if (!price.auto) {
                            retargeting.price_context = price.single_price;
                        }

                        // DIRECT-87402: Ошибка сохранения группы при выборе Долгосрочных/короткосрочных интересов
                        if (!u._.isEmpty(retargeting.groups)) {
                            retargeting.groups = retargeting.groups.map(function(group) {
                                if (typeof group.interest_type === 'string' && badInterestType[group.interest_type]) {
                                    group.interest_type = badInterestType[group.interest_type];
                                }

                                return group;
                            });
                        }

                        return retargeting;
                    });

                break;
            default:
                // По дефолту ретаргетинг должен быть с "болванкой", а не пустой совсем
                var price = groupModel.getAutoPriceData();

                data.retargetings = [{
                    condition_name: iget2('p-multiedit2', 'novaya-auditoriya', 'Новая аудитория'),
                    description: '',
                    price_context: price.single_price,
                    auto_price: price,
                    type: 'interests',
                    groups: []
                }];

                break;
        }

        return data;
    },

    _replaceBadField: function(field, groupModel) {
        this._badFields || (this._badFields = {
            href_model: 'href',
            retargetingsInterests: 'targetInterests',
            general_limit_price: 'auto_price',
            phrases: 'keywords',
            new_phrases: 'new_keywords',
            new_suggestions: 'keywords_suggestions'
        });

        // @skywhale Так как элемент «new-phrases» скрыт, пока пользователь не нажмет «упорядочить и уточнить».
        // Показываем ошибку у элемента «word-suggestions»
        if (field === 'new_phrases' && u._.isEmpty(groupModel.get('newPhrasesIds'))) {
            return 'keywords_suggestions';
        }

        return this._badFields[field] || field;
    },

    /**
     * Валидирует группы, находящиеся на редактировании
     * @returns {Boolean}
     * @override
     * @private
     */
    _validateGroups: function() {
        if (u.consts('disable_client_validation')) return true;

        var errors = [];

        this._groupsModels.forEach(function(groupModel, groupIndex) {
            var groupValidate = groupModel.validate();

            if (!groupValidate.valid) {
                u._.keys(groupValidate.errorsData).forEach(function(field) {
                    var path = '[' + groupIndex + '].' + this._replaceBadField(field, groupModel);

                    groupValidate.errorsData[field].forEach(function(error) {
                        errors.push({
                            path: path,
                            description: error.text
                        });
                    });
                }, this);
            }

            groupModel.getBanners().forEach(function(bannerModel, bannerIndex) {
                var bannerValidate = bannerModel.validate();

                if (!bannerValidate.valid) {
                    u._.keys(bannerValidate.errorsData).forEach(function(field) {
                        var badField = this._replaceBadField(field, groupModel),
                            path = '[' + groupIndex + '].banners[' + bannerIndex + '].' + badField;

                        bannerValidate.errorsData[field].forEach(function(error) {
                            errors.push({
                                path: path,
                                description: error.text
                            });
                        });
                    }, this);
                }
            }, this);

        }, this);

        if (errors.length) {
            this._showJavaErrors(errors);
        }

        return !errors.length;
    },

    /**
     * Достижение цели
     * @private
     */
    _metrikaReachGoal: function() {
        // создание новой кампании
        if (this._campModel.get('isCreatingNewCamp')) {
            BEM.blocks['b-metrika2'].reachGoal('CPM_CAMPAIGN_SAVED_STEP2');
        }
    }

});
