match(function() {
    return (/^(addAdGroupsPerformance|editAdGroupsPerformance)$/).test(this.data.cmd);
})(

    block('app-main')(

        mode('preprocess')(function() {
            var data = this.data,
                form = data.FORM,
                copyRegexp = RegExp('.*\\(' + iget2('p-multiedit2', 'kopiya', 'копия') + '\\)$', 'gi');

            data.errorPath = 'groups';

            this.isSingleGroup = !!(!data.campaign.groups || data.campaign.groups.length <= 1);
            this.isNewGroup = data.campaign.groups[0] && !data.campaign.groups[0].adgroup_id;
            this.isCopyGroup = !!data.is_groups_copy_action;
            this.isFromNewCamp = form.from_newCamp;
            this.isTwoSteps = !!(data.statusEmpty == 'Yes' || this.isFromNewCamp);

            data.campaign.common_geo_set = !!data.campaign.common_geo;
            data.campaign.ulogin = form.ulogin;
            data.campaign.metrika = {
                ecommerce: data.campaign.metrika_has_ecommerce
            };

            data.campaign.groups && data.campaign.groups.forEach(function(group, i) {
                if (group.is_group_copy_action) {
                    var groupName = group.group_name && group.group_name.toString();

                    if (!groupName.match(copyRegexp)) {
                        group.group_name = groupName + ' (' + iget2('p-multiedit2', 'kopiya', 'копия') + ')';
                    }
                }

                //DIRECT-39380
                group.withVCard = true;
                group.isEmpty = !group.isNewGroup && group.banners.length === 1 && group.banners[0].isNewBanner;

                group = u['i-banners-group-data'].patch({
                    hasPrevBanner: data.prev_banner && data.prev_banner.title,
                    prevBanner: data.prev_banner,
                    count: i,
                    bannersGroup: group,
                    isNewGroup: this.isNewGroup,
                    isCopyGroup: this.isCopyGroup,
                    isSingleGroup: this.isSingleGroup,
                    campaignTags: data.campaign.tags,
                    isDevicesEnabled: hasEnabledFeatures('cpc_device_modifiers') ||
                        u.consts('isMobileOsBidModifierEnabled'),
                    isWithoutDeviceRestrictions: hasEnabledFeatures('cpc_device_modifiers')
                }, data);
            }, this);

            return data;
        }),

        mode('page-block')({
            block: 'p-multiedit2',
            mods: {
                type: 'dynamic-media'
            }
        })
    ),

    block('b-page')(
        mode('content-only')(function() {
            return this.data.FORM.popupMode === '1';
        }),

        def().match(function() {
            return !this.pageParams;
        })(function() {
            var titleType = (this.isNewGroup || this.isCopyGroup) ? 'create' : this.data.FORM.banner_status,
                titles = {
                    wait: iget2('p-multiedit2', 'redaktirovanie-smart-bannerov-na', 'Редактирование смарт-баннеров на модерации'),
                    decline: iget2('p-multiedit2', 'redaktirovanie-otklonyonnyh-smart-bannerov', 'Редактирование отклонённых смарт-баннеров'),
                    off: iget2('p-multiedit2', 'redaktirovanie-ostanovlennyh-smart-bannerov', 'Редактирование остановленных смарт-баннеров'),
                    draft: iget2('p-multiedit2', 'redaktirovanie-chernovikov-smart-bannerov', 'Редактирование черновиков смарт-баннеров'),
                    arch: iget2('p-multiedit2', 'redaktirovanie-arhivnyh-smart-bannerov', 'Редактирование архивных смарт-баннеров'),
                    create: iget2('p-multiedit2', 'sozdanie-gruppy-smart-bannerov', 'Создание группы смарт-баннеров'),
                    all: iget2('p-multiedit2', 'redaktirovanie-gruppy-smart-bannerov', 'Редактирование группы смарт-баннеров')
                };

            return applyNext({
                pageParams: {
                    title: titles[titleType] || iget2('p-multiedit2', 'redaktirovanie-aktivnyh-smart-bannerov', 'Редактирование активных смарт-баннеров')
                }
            });
        }),

        mode('title')(function() {
            return this.pageParams.title;
        }),

        elem('foot-js').content()(function() {
            var result = applyNext(),
                langList = {
                    ru: 'ru-RU',
                    en: 'en-US',
                    tr: 'tr-TR',
                    ua: 'uk-UA'
                };

            result.push({
                elem: 'js',
                url: u.formatUrl({
                    host: '//api-maps.yandex.ru',
                    path: '2.1',
                    query: {
                        lang: langList[this.data.lang] || langList.ru,
                        coordorder: 'longlat'
                    }
                })
            });

            return result;
        })
    )

);

block('p-multiedit2').mod('type', 'dynamic-media')(

    addJs()(function() {
        return u._.extend(
            u['p-multiedit2'].getPageJsParams(u._.extend({}, this.data, {
                cmd: 'savePerformanceAdGroups'
            })),
            {
                // сейчас смарты нельзя создать первой кампанией и is_first_camp для них не может прийти
                // это задел на будущее
                isFirstCampaign: this.data.is_first_camp,
                isNewGroup: this.data.campaign.groups[0] && !this.data.campaign.groups[0].adgroup_id
            }
        );
    }),

    content()(function() {
        return [
            {
                block: 'b-retargetings-data'
            },
            {
                elem: 'models',
                content: {
                    block: 'i-model-aggregator',
                    content: [
                        {
                            block: 'i-model',
                            modelParams: {
                                name: 'dm-dynamic-media-campaign',
                                id: this.data.campaign.cid,
                                data: applyCtx({
                                    block: 'dm-dynamic-media-campaign'
                                })
                            }
                        },
                        this.data.campaign.groups.map(function(groupData) {
                            return {
                                block: 'i-model',
                                modelParams: {
                                    name: 'dm-dynamic-media-group',
                                    id: groupData.modelId,
                                    data: u['dm-dynamic-media-group'].transformData({
                                        cid: this.data.campaign.cid,
                                        group: groupData,
                                        campaignTags: this.data.campaign.tags,
                                        isCopyGroup: this.isCopyGroup
                                    })
                                }
                            };
                        }, this),
                        {
                            block: 'i-model',
                            modelParams: {
                                name: 'dm-dynamic-media-feed-list',
                                id: 'only',
                                data: {
                                    items: this.data.feeds
                                }
                            }
                        },
                        !!this.data.campaign.common_geo_set && {
                            block: 'i-model',
                            modelParams: {
                                name: 'm-geo-regions',
                                id: 'common',
                                data: {
                                    geo: this.data.campaign.geo,
                                    geo_names: this.data.campaign.geo_names
                                }
                            }
                        }
                    ]
                }
            },
            {
                block: 'l-page',
                mix: [
                    {
                        block: 'b-error-presenter'
                    },
                    {
                        block: 'p-multiedit2',
                        mods: {
                            type: 'dynamic-media'
                        },
                        elem: 'content-layout'
                    }
                ],
                mods: {
                    layout: '16-60-16'
                },
                content: [
                    {
                        elem: 'row',
                        left: true,
                        center: [
                            {
                                block: 'b-page-title',
                                mix: {
                                    block: 'p-multiedit2',
                                    mods: {
                                        type: 'dynamic-media'
                                    },
                                    elem: 'title'
                                },

                                content: this.isFromNewCamp ? [
                                    {
                                        elem: 'steps-title',
                                        content: iget2('p-multiedit2', 'shag-2-iz-2', 'Шаг 2 из 2')
                                    },
                                    {
                                        elem: 'title',
                                        content: this.pageParams.title
                                    }
                                ] : {
                                    elem: 'title',
                                    content: {
                                        block: 'p-multiedit2',
                                        elem: 'wrapped-title',
                                        content: this.pageParams.title
                                    }
                                }
                            },
                            {
                                block: 'p-multiedit2',
                                elem: 'campaign-title',
                                elemMods: {
                                    'is-new': this.isNewGroup || this.isCopyGroup ? 'yes' : 'no'
                                }
                            },
                            {
                                block: 'b-edit-groups-arch-warning'
                            },
                            {
                                block: 'b-error-groups-summary',
                                js: {
                                    path: 'errors-summary'
                                },
                                mix: {
                                    block: 'p-multiedit2',
                                    elem: 'errors-summary'
                                }
                            }
                        ],
                        rgap: true,
                        right: true
                    },
                    {
                        elem: 'row',
                        center: {
                            elem: 'separator',
                            mix: {
                                block: 'p-multiedit2',
                                mods: {
                                    type: 'dynamic-media'
                                },
                                elem: 'separator'
                            }
                        },
                        ctxCells: {
                            center: {
                                attrs: {
                                    colspan: 4
                                }
                            }
                        }
                    },
                    applyCtx({
                        block: 'p-multiedit2',
                        elem: 'mass-actions',
                        isSingleGroup: this.isSingleGroup
                    }),
                    {
                        elem: 'row',
                        center: applyCtx({
                            block: 'p-multiedit2',
                            elem: 'multiedit-container',
                            type: 'dynamic-media',
                            formData: {
                                cmd: 'savePerformanceAdGroups',
                                isLight: ''
                            },
                            editData: {
                                type: 'dynamic-media-full',
                                mods: {
                                    type: 'dynamic-media-full'
                                }
                            },
                            buttonsData: {
                                buttons: [
                                    this.data.FORM.from_newCamp && 'back',
                                    'submit',
                                    hasLoginRights('AllowImportXlsBanners', 'agency_control') && 'to-draft'
                                ],
                                isCampaignModerated: this.data.campaign.statusModerate &&
                                    this.data.campaign.statusModerate != 'New'
                            }
                        }),
                        ctxCells: {
                            center: {
                                attrs: {
                                    colspan: 4
                                }
                            }
                        }
                    }
                ]
            },
            {
                block: 'b-minus-words-control',
                elem: 'popup',
                elemMods: { type: 'dynamic-media' },
                for: 'groups'
            },
            {
                block: 'b-outboard-controls',
                js: {
                    id: 'pic-selector-control'
                },
                attrs: {
                    id: 'pic-selector-control'
                },
                content: {
                    elem: 'popup',
                    buttons: false,
                    header: false,
                    innerBlock: applyCtx({
                        block: 'b-pic-selector',
                        mods: {
                            location: 'outboard'
                        }
                    })
                }
            },
            {
                block: 'b-outboard-controls',
                js: {
                    id: 'wordstat-control'
                },
                content: {
                    elem: 'popup',
                    directions: [
                        {
                            to: 'right',
                            axis: 'top',
                            offset: {
                                top: -15
                            },
                            tail: {
                                offset: {
                                    top: 5
                                }
                            }
                        }
                    ],
                    autoclosable: 'yes',
                    buttons: false,
                    header: false,
                    mixes: {
                        center: {
                            block: 'b-wordstat',
                            elem: 'popup-center'
                        }
                    },
                    innerBlock: applyCtx({
                        block: 'b-wordstat'
                    })
                }
            },
            {
                block: 'b-outboard-controls',
                js: {
                    id: 'sitelinks-selector-control'
                },
                attrs: {
                    id: 'sitelinks-selector-control'
                },
                content: {
                    elem: 'popup',
                    innerBlock: applyCtx({
                        block: 'b-sitelinks-selector',
                        mods: {
                            mode: 'banner',
                            for: 'dynamic-banner'
                        },
                        js: {
                            id: 'multiedit-sitelinks-selector'
                        },
                        modelId: 'banner',
                        sitelinksMaxLength: this.data.CONSTS.SITELINKS_MAX_LENGTH,
                        oneSitelinkMaxLength: this.data.CONSTS.ONE_SITELINK_MAX_LENGTH,
                        fullInfo: true
                    }),
                    buttons: {
                        block: 'b-sitelinks-selector',
                        mods: {
                            mode: 'banner',
                            for: 'dynamic-banner'
                        },
                        js: {
                            id: 'multiedit-sitelinks-selector'
                        },
                        modelId: 'banner',
                        content: {
                            elem: 'buttons'
                        }
                    }
                }
            }
        ];
    })
);
