/**
 * Страница мультиредактирования групп смарт-баннеров
 *
 * @param {Object} params
 * @param {Object} params.formParams хэш с параметрами формы
 * @param {String|Number} params.cid идентификатор кампании
 * @param {String[]|Number[]} params.groupsIds идентификаторы групп
 */
BEM.DOM.decl({ block: 'p-multiedit2', modName: 'type', modVal: 'dynamic-media' }, {

    onSetMod: {
        js: function() {
            this._deletedGroupsBids = {};

            this.__base.apply(this, arguments);
        }
    },

    /**
     * У Смартов нет уточнений, убираем инициацию
     * @override
     * @private
     */
    _initCallouts: function() {},

    /**
     * Инициализация моделей кампании, фидов и групп
     * @override
     * @private
     */
    _initModels: function() {
        this.__base.apply(this, ['dm-dynamic-media-campaign']);
        /**
         * Возвращает индекс модели группы
         * @param {String} modelId
         * @returns {Number}
         */
        var getGroupModelIndex = function(modelId) {
            return this.params.groupsIds.indexOf(modelId);
        }.bind(this);

        BEM.MODEL.getOrCreate({
            name: 'dm-dynamic-media-feed-list',
            id: 'only'
        });

        this._subscriptions.wrap(BEM.MODEL)
            .on('dm-dynamic-media-group', 'change', function(e, data) {
                var model = e.target,
                    index = getGroupModelIndex(model.id);

                this._clearErrors(this._buildErrorPath(index, data.field));
            }, this)
            .on('dm-dynamic-media-group', 'error', function(e, data) {
                var model = e.target,
                    index = getGroupModelIndex(model.id);

                this._errorData = u.error.flattenClient(data.errorsData, this._buildErrorPath(index));
                this._showErrors(this._errorData);
            }, this)
            .on('dm-dynamic-media-group', 'banners', 'remove', function(e, data) {
                var bannerModel = data.model,
                    groupModelId = bannerModel.getParentModel().get('modelId');

                if (isNaN(+bannerModel.id)) return;

                if (!this._deletedGroupsBids[groupModelId]) {
                    this._deletedGroupsBids[groupModelId] = [];
                }

                this._deletedGroupsBids[groupModelId].push(bannerModel.id);
            }, this);

        this._groupsModels = this.params.groupsIds.map(function(id, index) {
            return BEM.MODEL.getOrCreate({ name: 'dm-dynamic-media-group', id: id }).fix();
        }, this);
    },

    /**
     * Подписка на события блоков
     * @override
     * @private
     */
    _initEvents: function() {
        this.__base.call(this);

        this._subscriptions.on(BEM.blocks['b-edit-group'], 'filter:edit:completed', function(e, data) {
            data.controller.save();
        }.bind(this));
    },

    /**
     * Отправляет форму (ajax) при отсутствии ошибок клиентской валидации
     * @param {Object} [additionalData] доп. данные для отправки
     * @param {Number} [additionalData.save_draft] флаг "сохранить как черновик"
     * @override
     * @private
     */
    _submitForm: function(additionalData) {
        if (this._validateGroups()) {

            if (this.params.isNewGroup) {
                BEM.blocks['b-metrika2'].reachGoal({
                    target: 'GROUP_WITH_BANNERS_CLICKED_SAVE',
                    id: 191494,
                    params: {
                        groupWithBanners: 'performance'
                    }
                });
            }

            this.__base.apply(this, [{ ajax: true, additionalData: additionalData }])
        }
    },

    /**
     * Возвращает данные групп для отправки на сервер
     * @param {BEM.MODEL} groupModel - модель группы
     * @returns {Object}
     * @override
     * @private
     */
    _getGroupData: function(groupModel) {
        return u._.extend(groupModel.provideData(), {
            deleted_bids: this._deletedGroupsBids[groupModel.id]
        });
    },

    /**
     * Валидирует группы, находящиеся на редактировании
     * @returns {Boolean}
     * @override
     * @private
     */
    _validateGroups: function() {
        var isValid = true,
            groupsErrorData;

        if (u.consts('is_beta') && u.consts('disable_client_validation')) return true;

        groupsErrorData = this._groupsModels.map(function(groupModel) {
            var result,
                isGroupInvalid = !groupModel.isValid();

            if (isGroupInvalid) {
                isValid = false;
                result = u.error.clientToUniversal(groupModel.validate());

                return result;
            } else {
                return null;
            }
        });

        if (!isValid) {
            this._showErrors(this._prepareErrorsData({
                groups: {
                    array_errors: groupsErrorData
                }
            }));
        }

        return isValid;
    },

    /**
     * Подготавливает данные об ошибках к показу в b-errors-group-summary
     * @param {Object} errorData данных об ошибках в "серверном" формате (см i-utils__error)
     * @returns {Object}
     * @override
     */
    _prepareErrorsData: function(errorData) {
        var result,
            groupData;

        if (u._.get(errorData, 'groups.array_errors')) {
            errorData.groups.array_errors.forEach(function(groupError, index) {
                var feedFieldForName = u._.get(groupError, 'object_errors.field_to_use_as_name'),
                    feedFieldForBody = u._.get(groupError, 'object_errors.field_to_use_as_body');

                if (feedFieldForName) {
                    groupError.object_errors.feedFieldForName = feedFieldForName.slice();
                    delete groupError.object_errors.field_to_use_as_name;
                }

                if (feedFieldForBody) {
                    groupError.object_errors.feedFieldForBody = feedFieldForBody.slice();
                    delete groupError.object_errors.field_to_use_as_body;
                }
            }, this);
        }

        result = u.error.flatten(errorData);

        groupData = this._groupsModels.map(function(groupModel) {
            return BEM.blocks['i-error-groups-summary'].groupToSummaryData(groupModel.toJSON());
        });

        result['errors-summary'] = BEM.blocks['i-error-groups-summary'].summarizeErrors(groupData, errorData);

        return result;
    },

    /**
     * Показывает ошибки в форме
     * @override {p-multiedit2}
     */
    _showErrors: function(errors) {
        var errorsHash = {};

        // блок с выводом общих ошибок должен быть всегда
        // поскольку в нём шапка с призывом исправить все ошибки
        errorsHash[this._buildErrorPath()] = [];

        return this.__base.call(this, u._.extend(errorsHash, errors));
    }

});
