match(function() {
    return (/^(addDynamicAdGroups|editDynamicAdGroups)$/).test(this.data.cmd);
})(

    block('app-main')(

        mode('preprocess')(function() {
            var data = this.data,
                campaignTags = data.campaign.tags || [],
                form = data.FORM,
                copyRegexp = RegExp('.*\\(' + iget2('p-multiedit2', 'kopiya', 'копия') + '\\)$', 'gi');

            data.errorPath = 'groups';

            //отключение клиентской валидации
            if (this.data.COOKIES.disable_client_validation && this.data.is_beta) {
                data.disable_client_validation = 1;
            }

            this.isSingleGroup = !!(!data.campaign.groups || data.campaign.groups.length <= 1);
            this.isNewGroup = data.campaign.groups[0] && !data.campaign.groups[0].adgroup_id;
            this.isCopyGroup = !!data.is_groups_copy_action;
            this.isMultipleSteps = !!(data.statusEmpty == 'Yes' || form.from_newCamp);

            data.loadVCardFromClient = true;

            this.data.prev_banner && this.data.prev_banner.title && (this.data.prev_banner.modelId = 'prev');

            //преобразовываем default_dynamic_conditions.by_domain из серверного формата в модельный
            data.campaign.default_dynamic_conditions.by_domain =
                (data.campaign.default_dynamic_conditions &&
                    data.campaign.default_dynamic_conditions.by_domain || [])
                        .map(function(cond, i) {
                            return u['dm-dynamic-group'].transformDynamicConditionData(cond, i);
                        });

            data.campaign.groups && data.campaign.groups.forEach(function(group, i) {
                if (group.is_group_copy_action) {
                    var groupName = group.group_name && group.group_name.toString();

                    if (!groupName.match(copyRegexp)) {
                        group.group_name = groupName + ' (' + iget2('p-multiedit2', 'kopiya', 'копия') + ')';
                    }
                }

                //DIRECT-40991: Редактирование пустых групп
                if (!group.banners.length) {
                    group.banners.push({
                        bid: 0,
                        vcard: data.prev_banner && data.prev_banner.vcard || data.campaign.vcard
                    });
                    group.banners_quantity = 1;
                }

                //DIRECT-44701: ссылка на сайт сохраняется с лишним http
                group.banners.forEach(function(banner) {
                    banner.href = banner.href ? u.stripHttp(banner.href) : '';
                });

                group = u['i-banners-group-data'].patch({
                    hasPrevBanner: data.prev_banner && data.prev_banner.title,
                    prevBanner: data.prev_banner,
                    count: i,
                    bannersGroup: group,
                    isNewGroup: this.isNewGroup,
                    isCopyGroup: this.isCopyGroup,
                    isSingleGroup: this.isSingleGroup,
                    campaignTags: campaignTags,
                    isDevicesEnabled: hasEnabledFeatures('cpc_device_modifiers') ||
                        u.consts('isMobileOsBidModifierEnabled'),
                    isWithoutDeviceRestrictions: hasEnabledFeatures('cpc_device_modifiers')
                }, data);
            }, this);

            data.campaign.common_vcard_set = !!(data.campaign.vcard && data.campaign.vcard.city);
            data.campaign.common_geo_set = !!data.campaign.common_geo;

            data.campaign.feedsModelParams = {
                name: 'dm-dynamic-media-feed-list',
                id: 'only'
            };

            data = u['i-process-campaign-data'].patch(data);

            return data;
        }),

        mode('page-block')({
            block: 'p-multiedit2',
            mods: {
                type: 'dynamic'
            }
        })
    ),

    block('b-page')(
        mode('content-only')(function() {
            return this.data.FORM.popupMode === '1';
        }),

        def().match(function() {
            return !this.pageParams;
        })(function() {
            var titleType = (this.isNewGroup || this.isCopyGroup) ? 'create' : this.data.FORM.banner_status,
                titles = {
                    wait: iget2('p-multiedit2', 'redaktirovanie-obyavleniy-na-moderacii', 'Редактирование объявлений на модерации'),
                    decline: iget2('p-multiedit2', 'redaktirovanie-otklonyonnyh-obyavleniy', 'Редактирование отклонённых объявлений'),
                    off: iget2('p-multiedit2', 'redaktirovanie-ostanovlennyh-obyavleniy', 'Редактирование остановленных объявлений'),
                    draft: iget2('p-multiedit2', 'redaktirovanie-obyavleniy-chernovikov', 'Редактирование объявлений-черновиков'),
                    arch: iget2('p-multiedit2', 'redaktirovanie-arhivnyh-obyavleniy', 'Редактирование архивных объявлений'),
                    create: iget2('p-multiedit2', 'sozdanie-gruppy-obyavleniy', 'Создание группы объявлений'),
                    all: this.data.campaign.groups && this.data.campaign.groups.length == 1 ?
                        iget2('p-multiedit2', 'redaktirovanie-gruppy-obyavleniy', 'Редактирование группы объявлений') : iget2('p-multiedit2', 'redaktirovanie-grupp-obyavleniy', 'Редактирование групп объявлений')
                };

            return applyNext({
                pageParams: {
                    title: titles[titleType] || iget2('p-multiedit2', 'redaktirovanie-aktivnyh-obyavleniy', 'Редактирование активных объявлений')
                }
            });
        }),

        mode('title')(function() {
            return this.pageParams.title;
        }),

        elem('foot-js').content()(function() {
            var result = applyNext(),
                langList = {
                    ru: 'ru-RU',
                    en: 'en-US',
                    tr: 'tr-TR',
                    ua: 'uk-UA'
                };

            result.push({
                elem: 'js',
                url: u.formatUrl({
                    host: '//api-maps.yandex.ru',
                    path: '2.1',
                    query: {
                        lang: langList[this.data.lang] || langList.ru,
                        coordorder: 'longlat'
                    }
                })
            });

            return result;
        })
    )

);

block('p-multiedit2').mod('type', 'dynamic')(

    addJs()(function() {
        return u._.extend(
            u['p-multiedit2'].getPageJsParams(u._.extend({}, this.data, {
                cmd: 'saveDynamicAdGroups'
            })),
            {
                feedsModelParams: this.data.campaign.feedsModelParams,
                isFirstCampaign: this.data.is_first_camp,
                promoCodeDomains: this.data.promocode_domains
            }
        );
    }),

    content()(function() {
        return [
            {
                block: 'b-retargetings-data'
            },
            {
                elem: 'models',
                content: {
                    block: 'i-model-aggregator',
                    content: [
                        {
                            block: 'i-model',
                            modelParams: {
                                name: 'm-campaign',
                                id: this.data.campaign.cid,
                                data: applyCtx({
                                    block: 'm-campaign'
                                })
                            }
                        },
                        {
                            block: 'i-model',
                            modelParams: u._.extend(this.data.campaign.feedsModelParams, {
                                data: {
                                    items: this.data.feeds
                                }
                            })
                        },
                        this.data.campaign.groups.map(function(groupData) {
                            return [
                                {
                                    block: 'i-model',
                                    modelParams: {
                                        name: 'dm-dynamic-group',
                                        id: groupData.modelId,
                                        data: u['dm-dynamic-group'].transformData(u._.extend(
                                            {
                                                group: groupData,
                                                campaignTags: this.data.campaign.tags || [],
                                                loadVCardFromClient: this.data.loadVCardFromClient
                                            },
                                            {
                                                cid: this.data.campaign.cid,
                                                defaultDynamicConditions:
                                                    this.data.campaign.default_dynamic_conditions
                                            })
                                        )
                                    }
                                }
                            ];
                        }, this)
                    ]
                }
            },

            !!this.data.campaign.common_vcard_set && {
                block: 'i-model',
                modelParams: {
                    name: 'm-vcard',
                    id: 'common',
                    data: this.data.campaign.vcard
                }
            },
            !!this.data.campaign.common_geo_set && {
                block: 'i-model',
                modelParams: {
                    name: 'm-geo-regions',
                    id: 'common',
                    data: {
                        geo: this.data.campaign.geo,
                        geo_names: this.data.campaign.geo_names
                    }
                }
            },
            {
                block: 'l-page',
                mix: [
                    {
                        block: 'b-error-presenter'
                    },
                    {
                        block: 'p-multiedit2',
                        mods: {
                            type: 'dynamic'
                        },
                        elem: 'content-layout'
                    }
                ],
                mods: {
                    layout: '16-60-16'
                },
                content: [
                    {
                        elem: 'row',
                        left: true,
                        center: [
                            {
                                block: 'b-page-title',
                                mix: {
                                    block: 'p-multiedit2',
                                    mods: {
                                        type: 'dynamic'
                                    },
                                    elem: 'title'
                                },
                                content: [
                                    (this.isNewGroup || this.isCopyGroup) && this.isMultipleSteps && {
                                        elem: 'steps-title',
                                        content: iget2('p-multiedit2', 'shag-2-iz-2', 'Шаг 2 из 2')
                                    },
                                    {

                                        elem: 'title',
                                        content: this.isNewGroup ?
                                            {
                                                block: 'p-multiedit2',
                                                elem: 'wrapped-title',
                                                content: this.pageParams.title
                                            } :
                                            this.pageParams.title
                                    }
                                ]
                            },
                            {
                                block: 'p-multiedit2',
                                elem: 'campaign-title',
                                elemMods: {
                                    'is-new': this.isNewGroup || this.isCopyGroup ? 'yes' : 'no'
                                }
                            },
                            {
                                block: 'b-edit-groups-arch-warning'
                            },
                            {
                                block: 'b-error-groups-summary',
                                js: {
                                    path: 'errors-summary'
                                },
                                mix: {
                                    block: 'p-multiedit2',
                                    elem: 'errors-summary'
                                }
                            }
                        ],
                        rgap: true,
                        right: true
                    },
                    {
                        elem: 'row',
                        center: {
                            elem: 'separator',
                            mix: {
                                block: 'p-multiedit2',
                                mods: {
                                    type: 'dynamic'
                                },
                                elem: 'separator'
                            }
                        },
                        ctxCells: {
                            center: {
                                attrs: {
                                    colspan: 4
                                }
                            }
                        }
                    },
                    applyCtx({
                        block: 'p-multiedit2',
                        elem: 'mass-actions',
                        isSingleGroup: this.isSingleGroup
                    }),
                    {
                        elem: 'row',
                        center: applyCtx({
                            block: 'p-multiedit2',
                            elem: 'multiedit-container',
                            type: 'dynamic',
                            formData: {
                                cmd: 'saveDynamicAdGroups'
                            },
                            editData: {
                                type: 'dynamic-full'
                            },
                            buttonsData: {
                                buttons: [
                                    this.isMultipleSteps && 'back',
                                    {
                                        name: 'submit',
                                        // DIRECT-52588 только при создании, не при копировании
                                        mix: this.isNewGroup && {
                                            block: 'b-metrika',
                                            js: {
                                                goal: 'MEDIATYPEDYNAMIC2'
                                            }
                                        }
                                    },
                                    hasLoginRights('AllowImportXlsBanners', 'agency_control') &&
                                    (this.data.campaign.statusModerate && this.data.campaign.statusModerate != 'New') &&
                                    'to-draft'
                                ],
                                isCampaignModerated: this.data.campaign.statusModerate &&
                                    this.data.campaign.statusModerate != 'New'
                            }
                        }),
                        ctxCells: {
                            center: {
                                attrs: {
                                    colspan: 4
                                }
                            }
                        }
                    }
                ]
            },
            {
                block: 'b-minus-words-control',
                elem: 'popup',
                for: 'groups'
            },
            {
                elem: 'outboard-popup',
                elemMods: {
                    type: 'pic-selector-control'
                }
            },
            {
                elem: 'outboard-popup',
                elemMods: {
                    type: 'wordstat-control'
                }
            },
            {
                elem: 'outboard-popup',
                elemMods: {
                    type: 'sitelinks-selector-control'
                },
                innerBlockMods: {
                    for: 'dynamic-banner'
                },
                buttonsMods: {
                    for: 'dynamic-banner'
                }
            }
        ];
    })
);
