/**
 * @listens b-feed-filter#filter:edit:completed
 */
BEM.DOM.decl({ block: 'p-multiedit2', modName: 'type', modVal: 'dynamic' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);
        }
    },

    /**
     * Инициализация коллаутов с правильной группой
     * @override
     * @private
     */
    _initCallouts: function() {
        this.__base.apply(this, ['dm-dynamic-group']);
    },

    /**
     * Инициирует модели, необходимые для блока
     * @override
     * @private
     */
    _initModels: function() {
        this.__base.apply(this, ['m-campaign']);
        /**
         * Возвращает индекс модели группы
         * @param {String} modelId
         * @returns {Number}
         */
        var getGroupModelIndex = function(modelId) {
            return this.params.groupsIds.indexOf(modelId);
        }.bind(this);

        BEM.MODEL.getOrCreate(this.params.feedsModelParams);

        this._subscriptions.wrap(BEM.MODEL)
            .on('dm-dynamic-group', 'change', function(e, data) {
                var model = e.target,
                    index = getGroupModelIndex(model.id),
                    field = data.field;

                if (field == 'feed_filters') { //про фильтры и про условия - один путь отображения ошибок
                    field = 'dynamic_conditions';
                }

                if (field === 'banners') { // баннеры очистят свои ошибки сами см. onBannerChange
                    return;
                } else if (field === 'data_source' || field === 'main_domain') {
                    //ошибки про источник данных - это ошибки про фид
                    ['feed_id', 'dynamic_conditions', 'main_domain'].forEach(function(field) {
                        this._clearErrors(this._buildErrorPath(index, field));
                    }, this);
                } else {
                    this._clearErrors(this._buildErrorPath(index, field));
                }
            }, this)
            .on('dm-dynamic-group', 'error', function(e, data) {
                var model = e.target,
                    index = getGroupModelIndex(model.id);

                this._showErrors(u.error.flattenClient(data.errorsData, this._buildErrorPath(index)));
            }, this)
            .on(
                { name: 'dm-dynamic-banner', parentName: 'dm-dynamic-group', parentId: '*' },
                'change',
                function(e, data) {
                    var bannerModel = e.target,
                        groupModel = bannerModel.getParentModel(),
                        groupIndex = getGroupModelIndex(groupModel.id),
                        bannerId = bannerModel.get('modelId'),
                        bannerIndex = u._.findIndex(groupModel.get('banners').map(u._.identity), function(banner) {
                            return banner.get('modelId') == bannerId;
                        });

                    this._clearErrors(this._buildErrorPath(groupIndex, 'banners', bannerIndex, data.field));

                    //DIRECT-48017: в редактировании текстов такой проверки нет
                    if (data.field == 'body') {
                        //text_lang - виртуальное поле про несоответствие языка и региона
                        this._clearErrors(this._buildErrorPath(groupIndex, 'banners', bannerIndex, 'text_lang'));
                    }
                },
                this
            );

        this._groupsModels = this.params.groupsIds.map(function(id, index) {
            return BEM.MODEL.getOrCreate({ name: 'dm-dynamic-group', id: id }).fix();
        }, this);
    },

    /**
     * Подписка на события блоков
     * @override
     * @private
     */
    _initEvents: function() {
        this.__base.call(this);

        this._subscriptions.on(BEM.blocks['b-edit-group'], 'filter:edit:completed', function(e, data) {
            var cid = this._campModel.get('cid'),
                group = this._groupsModels.filter(function(group) {
                    return group.id == data.modelData.adgroupModelId;
                }).pop(),
                filterData = BEM.blocks['i-feed-filter-validate'].modelDataToValidationData(data.modelData, group),
                validationController = data.controller;

            BEM.blocks['i-feed-filter-validate'].processValidationResult(
                BEM.blocks['i-feed-filter-validate'].validate(filterData, group, {
                    cid: cid,
                    ulogin: u.consts('ulogin')
                }),
                validationController);
        }.bind(this));
    },

    /**
     * Отправляет форму (ajax) при отсутствии ошибок клиентской валидации
     * @param {Object} [additionalData] доп. данные для отправки
     * @param {Number} [additionalData.save_draft] флаг "сохранить как черновик"
     * @override
     * @private
     */
    _submitForm: function(additionalData) {
        var groupsValidate = this._validateGroups();

        if (groupsValidate) {
            var _this = this,
                base = _this.__base;

            if (_this.params.formParams.new_group) {
                BEM.blocks['b-metrika2'].reachGoal({
                    target: 'GROUP_WITH_BANNERS_CLICKED_SAVE',
                    id: 191494,
                    params: {
                        groupWithBanners: 'dynamic'
                    }
                });
            }

            this._compareAddress()
                .then(function() {
                    if (_this.params.formParams.is_groups_copy_action || _this.params.formParams.new_group) {
                        _this._confirmDomainChange().then(function() {
                            base.apply(_this, [{ ajax: true, additionalData: additionalData }]);
                        });
                    } else {
                        base.apply(_this, [{ ajax: true, additionalData: additionalData }]);
                    }
                });
        }
    },

    /**
     * Возвращает данные группы для отправки на сервер
     * @param {BEM.MODEL} groupModel - модель группы
     * @returns {Object}
     * @override
     * @private
     */
    _getGroupData: function(groupModel) {
        return groupModel.provideData();
    },

    /**
     * Валидирует группы, находящиеся на редактировании
     * @returns {Boolean}
     * @override
     * @private
     */
    _validateGroups: function() {
        var isValid = true,
            vcards,
            groupsErrorData;

        if (u.consts('is_beta') && u.consts('disable_client_validation')) return true;

        vcards = this.findBlocksInside('b-vcard-control').reduce(function(res, vcard) {
            res[vcard.bannerModel.get('modelId')] = vcard;

            return res;
        }, {});
        groupsErrorData = this._groupsModels.map(function(groupModel) {
            var result,
                isGroupInvalid = !groupModel.isValid() || groupModel.get('banners').some(function(banner) {
                    var vcard = vcards[banner.get('modelId')];

                    return !banner.isValid() || (!banner.get('isVCardEmpty') && banner.get('has_vcard') && vcard &&
                        !vcard.validate());
                });

            if (isGroupInvalid) {
                isValid = false;
                result = u.error.clientToUniversal(groupModel.validate());

                result.object_errors.banners =
                    u.error.clientToUniversal(groupModel.get('banners').map(function(banner) {
                        var bannerValidationResult = banner.validate(),
                            vcard = vcards[banner.get('modelId')];

                        bannerValidationResult.errorFields = bannerValidationResult.errorFields || [];
                        bannerValidationResult.errors = bannerValidationResult.errors || [];

                        if (!banner.get('isVCardEmpty') && banner.get('has_vcard') && vcard && !vcard.validate()) {
                            bannerValidationResult.errorFields.push('vcard');
                            bannerValidationResult.errors.push({ text: iget2('p-multiedit2', 'oshibki-v-pole-adres', 'Ошибки в поле "Адрес и телефон"') });
                        }

                        return bannerValidationResult;
                    }));

                // отправляются и получаются данные всегда в dynamic_conditions, но для группы с фидом фильтры хранятся в feed_filters
                if (!('dynamic_conditions' in result.object_errors) && 'feed_filters' in result.object_errors) {
                    result.object_errors.dynamic_conditions = result.object_errors.feed_filters;
                }

                return result;
            } else {
                return null;
            }
        });

        if (!isValid) {
            this._showErrors(this._prepareErrorsData({
                groups: {
                    array_errors: groupsErrorData
                }
            }));
        }

        return isValid;
    }
});
