match(function() {
    return (/^(addMediaAdGroups|saveMediaAdGroups|editMediaAdGroups|copyMediaAdGroups)$/)
        .test(this.data.cmd);
})(

    block('app-main')(

        mode('preprocess')(function() {
            var data = this.data,
                campaignTags = data.campaign.tags || [],
                form = data.FORM,
                copyRegexp = RegExp('.*\\(' + iget2('p-multiedit2', 'kopiya', 'копия') + '\\)$', 'gi');

            data.errorPath = 'groups';

            this.isSingleGroup = !!(!data.campaign.groups || data.campaign.groups.length <= 1);
            this.isNewGroup = data.campaign.groups[0] && !data.campaign.groups[0].adgroup_id;
            this.isCopyGroup = !!data.is_groups_copy_action;
            this.isCreatingNewCamp = !!(data.statusEmpty == 'Yes' || form.from_newCamp);

            // alkaline@todo возможно уберем
            this.data.prev_banner && this.data.prev_banner.title && (this.data.prev_banner.modelId = 'prev');

            data.campaign.groups && data.campaign.groups.forEach(function(group, i) {
                var phrasesFiltered = [],
                    newPhrases = [],
                    groupName;

                //DIRECT-44701: ссылка на сайт сохраняется с лишним http
                group.banners.forEach(function(banner) {
                    banner.href = banner.href ? u.stripHttp(banner.href) : '';
                });

                //DIRECT-40991: Редактирование пустых групп
                if (!group.banners.length) {
                    group.banners.push({
                        bid: 0
                    });

                    group.banners_quantity = 1;
                }

                //DIRECT-39380
                group.phrases = group.phrases || [];
                group.new_phrases = [];
                group.isEmpty = !group.isNewGroup && group.banners.length === 1 && group.banners[0].isNewBanner;
                group.phrases && group.phrases.forEach(function(phrase) {
                    if (phrase.id) {
                        phrasesFiltered.push(phrase);
                    } else {
                        newPhrases.push(phrase.phrase);
                    }
                });

                group.phrases = phrasesFiltered;
                group.new_phrases = newPhrases;

                // Для получения модели кампании из модели группы, например, при создании новой группы
                group.cid = group.cid || data.campaign.cid;

                if (group.is_group_copy_action) {
                    groupName = group.group_name || '';

                    if (!groupName || !groupName.match(copyRegexp)) {
                        group.group_name = groupName + ' (' + iget2('p-multiedit2', 'kopiya', 'копия') + ')';
                    }
                }

                group = u['i-banners-group-data'].patch({
                    hasPrevBanner: data.prev_banner && data.prev_banner.title,
                    prevBanner: data.prev_banner,
                    count: i,
                    bannersGroup: group,
                    isNewGroup: this.isNewGroup,
                    isCopyGroup: this.isCopyGroup,
                    isSingleGroup: this.isSingleGroup,
                    campaignTags: campaignTags
                }, data);
            }, this);

            data.campaign.common_geo_set = !!data.campaign.common_geo;

            data = u['i-phrases-separate-into-groups'].patch(data, {
                hasSuspended: true,
                isNotBiddable: true
            });
            data = u['i-process-campaign-data'].patch(data);

            return data;
        }),

        mode('page-block')({
            block: 'p-multiedit2',
            mods: { type: 'mcbanner' }
        })
    ),

    block('b-page')(
        mode('content-only')(function() {
            return this.data.FORM.popupMode === '1';
        }),

        def().match(function() {
            return !this.pageParams;
        })(function() {
            var bannerStatus = this.data.FORM.banner_status,
                title;

            if (this.isNewGroup || this.isCopyGroup) {
                title = iget2('p-multiedit2', 'sozdanie-gruppy-bannerov', 'Создание группы баннеров');
            } else {
                switch (bannerStatus) {
                    case 'all':
                        title = this.data.campaign.groups && this.data.campaign.groups.length == 1 ?
                            iget2('p-multiedit2', 'redaktirovanie-gruppy-bannerov', 'Редактирование группы баннеров') :
                            iget2('p-multiedit2', 'redaktirovanie-grupp-bannerov', 'Редактирование групп баннеров');
                        break;
                    case 'wait':
                        title = iget2('p-multiedit2', 'redaktirovanie-bannerov-na-moderacii', 'Редактирование баннеров на модерации');
                        break;
                    case 'decline':
                        title = iget2('p-multiedit2', 'redaktirovanie-otklonyonnyh-bannerov', 'Редактирование отклонённых баннеров');
                        break;
                    case 'off':
                        title = iget2('p-multiedit2', 'redaktirovanie-ostanovlennyh-bannerov', 'Редактирование остановленных баннеров');
                        break;
                    case 'draft':
                        title = iget2('p-multiedit2', 'redaktirovanie-bannerov-chernovikov', 'Редактирование баннеров-черновиков');
                        break;
                    case 'arch':
                        title = iget2('p-multiedit2', 'redaktirovanie-arhivnyh-bannerov', 'Редактирование архивных баннеров');
                        break;
                    default:
                        title = iget2('p-multiedit2', 'redaktirovanie-aktivnyh-bannerov', 'Редактирование активных баннеров');
                }
            }

            return applyNext({
                pageParams: {
                    title: title
                }
            });
        }),

        mode('title')(function() {
            return this.pageParams.title;
        })
    )
);

block('p-multiedit2').mod('type', 'mcbanner')(

    addJs()(function() {
        return u._.extend(
            u['p-multiedit2'].getPageJsParams(u._.extend({}, this.data, {
                cmd: 'saveMediaAdGroups',
                autoPrice: 1
            })),
            {
                isFirstCampaign: this.data.is_first_camp,
                isNewGroup: this.data.campaign.groups[0] && !this.data.campaign.groups[0].adgroup_id
            }
        );
    }),

    content()(function() {

        var campaign = this.data.campaign,
            isCampaignModerated = campaign.statusModerate && campaign.statusModerate != 'New';

        return [
            {
                elem: 'models-data'
            },
            {
                block: 'b-retargetings-data'
            },
            {
                block: 'l-page',
                mix: [
                    {
                        block: 'b-error-presenter'
                    },
                    {
                        block: 'p-multiedit2',
                        elem: 'content-layout'
                    }
                ],
                mods: {
                    layout: '16-60-16'
                },
                content: [
                    {
                        elem: 'row',
                        left: true,
                        center: [
                            {
                                block: 'b-page-title',
                                mix: [{
                                    block: 'p-multiedit2',
                                    elem: 'title'
                                }],
                                content: (function() {
                                    var title = {
                                        elem: 'title',
                                        content: this.pageParams.title
                                    };

                                    return [
                                        this.isCreatingNewCamp && {
                                            elem: 'steps-title',
                                            content: iget2('p-multiedit2', 'shag-2-iz-2', 'Шаг 2 из 2')
                                        },
                                        title
                                    ];
                                }.call(this))
                            },
                            {
                                block: 'p-multiedit2',
                                elem: 'campaign-title',
                                elemMods: {
                                    'is-new': this.isNewGroup || this.isCopyGroup ? 'yes' : 'no'
                                }
                            },
                            {
                                block: 'b-edit-groups-arch-warning'
                            },
                            {
                                block: 'b-error-groups-summary',
                                js: {
                                    path: 'errors-summary'
                                },
                                mods: {
                                    'use-banner': 'yes'
                                },
                                mix: {
                                    block: 'p-multiedit2',
                                    elem: 'errors-summary'
                                }
                            }
                        ],
                        rgap: true,
                        right: true
                    },
                    {
                        elem: 'row',
                        center: {
                            elem: 'separator',
                            mix: [{
                                block: 'p-multiedit2',
                                elem: 'separator'
                            }]
                        },
                        ctxCells: {
                            center: {
                                attrs: {
                                    colspan: 4
                                }
                            }
                        }
                    },
                    applyCtx({
                        block: 'p-multiedit2',
                        elem: 'mass-actions',
                        isSingleGroup: this.isSingleGroup
                    }),
                    {
                        elem: 'row',
                        mix: [{
                            block: 'p-multiedit2',
                            elem: 'form-container'
                        }],
                        center: applyCtx({
                            block: 'p-multiedit2',
                            elem: 'multiedit-container',
                            type: 'mcbanner',
                            hasMediaResources: true,
                            formData: {
                                cmd: 'saveMediaAdGroups'
                            },
                            editData: {
                                type: 'mcbanner'
                            },
                            buttonsData: {
                                isCampaignModerated: isCampaignModerated,
                                buttons: [
                                    this.isCreatingNewCamp && 'back',
                                    'next'
                                ]
                            },
                            hintData: {
                                hint: {
                                    block: 'p-multiedit2',
                                    elem: 'loading',
                                    elemMods: { hidden: 'yes' },
                                    content: [
                                        {
                                            block: 'spin2',
                                            mods: { size: 'xxs', progress: 'yes' },
                                            mix: {
                                                block: 'p-multiedit2',
                                                elem: 'loading-spin'
                                            }
                                        },
                                        iget2('p-multiedit2', 'idyot-proverka-ssylki', 'Идёт проверка ссылки')
                                    ]
                                }
                            }
                        }),
                        ctxCells: {
                            center: {
                                attrs: {
                                    colspan: 4
                                }
                            }
                        }
                    }
                ]
            },
            {
                block: 'b-minus-words-control',
                elem: 'popup',
                for: 'groups'
            },
            {
                elem: 'outboard-popup',
                elemMods: {
                    type: 'wordstat-control'
                },
                innerBlock: {
                    block: 'b-wordstat',
                    js: {
                        modelName: 'dm-mcbanner-group',
                        isMobile: false
                    }
                }
            },
            {
                block: 'b-group-retargeting',
                elem: 'popup'
            }
        ];
    }),

    elem('models-data').content()(function() {
        var campaign = this.data.campaign;

        return [
            {
                block: 'i-model-aggregator',
                content: {
                    block: 'i-model',
                    modelParams: {
                        name: 'm-campaign',
                        id: campaign.cid,
                        data: applyCtx({
                            block: 'm-campaign'
                        })
                    }
                }
            },
            campaign.groups.map(function(group) {
                return {
                    block: 'i-model',
                    modelParams: {
                        name: 'dm-mcbanner-group',
                        id: group.modelId,
                        data: u['dm-mcbanner-group'].transformData({
                            group: group,
                            campaignTags: campaign.tags,
                            currency: campaign.currency
                        })
                    }
                };
            }, this),
            !!campaign.common_geo_set && {
                block: 'i-model',
                modelParams: {
                    name: 'm-geo-regions',
                    id: 'common',
                    data: {
                        geo: campaign.geo,
                        geo_names: campaign.geo_names
                    }
                }
            }
        ];
    })
);
