BEM.DOM.decl({ block: 'p-multiedit2', modName: 'type', modVal: 'mcbanner' }, {

    onSetMod: {

        js: function() {
            this.__base.apply(this, arguments);
        }
    },

    /**
     * У ГО на поиске нет уточнений, убираем инициацию
     * @override
     * @private
     */
    _initCallouts: function() {},

    /**
     * Инициализация необходимых моделей
     * @override
     * @private
     */
    _initModels: function() {
        this.__base.apply(this, ['m-campaign']);

        /**
         * Возвращает индекс модели группы
         * @param {String} modelId
         * @returns {Number}
         */
        var getGroupModelIndex = function(modelId) {
            return this.params.groupsIds.indexOf(modelId);
        }.bind(this);

        this._subscriptions.wrap(BEM.MODEL)
            .on('dm-mcbanner-group', 'change', function(e, data) {
                var model = e.target,
                    index = getGroupModelIndex(model.id),
                    field = {
                        new_phrases: 'keywords'
                    }[data.field] || data.field;

                if (field === 'banners') { // баннеры очистят свои ошибки сами
                    return;
                } else {
                    this._clearErrors(this._buildErrorPath(index, field));
                }
            }, this)
            .on(
                { name: 'm-banner', parentName: 'dm-mcbanner-group', parentId: '*' },
                'change',
                function(e, data) {
                    var bannerModel = e.target,
                        groupModel = bannerModel.getParentModel(),
                        groupIndex = getGroupModelIndex(groupModel.id),
                        bannerId = bannerModel.get('modelId'),
                        bannerIndex = u._.findIndex(groupModel.get('banners').map(u._.identity), function(banner) {
                            return banner.get('modelId') == bannerId;
                        }),
                        field = {
                            href_model: 'href'
                        }[data.field] || data.field;

                    this._clearErrors(this._buildErrorPath(groupIndex, 'banners', bannerIndex, field));
                },
                this
            );

        this._groupsModels = this.params.groupsIds.map(function(id) {
            return BEM.MODEL.getOrCreate({
                name: 'dm-mcbanner-group',
                id: id
            });
        });
    },

    /**
     * Подписка на события блоков
     * @override
     * @private
     */
    _initEvents: function() {
        this.__base.call(this);
        this._checkingHrefs = {};

        this._next && this._subscriptions.on(this._next, 'click', this._onSubmit, this);

        BEM.channel('banners-hrefs').on('state', function(e, data) {
            var isHrefsLoaded;

            if (data.state == 'loaded') {
                delete this._checkingHrefs[data.id];
            } else {
                this._checkingHrefs[data.id] = data.state;
            }

            isHrefsLoaded = Object.keys(this._checkingHrefs).length == 0;

            this._next && this._next.setMod('disabled', isHrefsLoaded ? '' : 'yes');
            this.setMod(this.elem('loading'), 'hidden', isHrefsLoaded ? 'yes' : '');
        }, this);
    },

    /**
     * Обработчик нажатия на кнопку назад
     * @param {Event} e - событие
     * @returns {Boolean}
     * @private
     */
    _onSubmit: function(e) {
        e.preventDefault();

        // Проверяем пересечение минус слов с ключевыми фразами
        BEM.blocks['b-minus-words-control']
            .checkBanners(this._groupsModels, this._campModel, this._submitForm, this);
    },

    /**
     * Валидирует группы, находящиеся на редактировании
     * @returns {Boolean}
     * @override
     * @private
     */
    _validateGroups: function() {
        var isValid = true,
            groupsErrorData = this._groupsModels.map(function(groupModel) {
                var result,
                    isGroupInvalid = !groupModel.isValid() || groupModel.get('banners').some(function(banner) {
                        return !banner.isValid();
                    });

                if (isGroupInvalid) {
                    isValid = false;
                    result = u.error.clientToUniversal(groupModel.validate());

                    result.object_errors.keywords = result.object_errors.new_phrases;

                    result.object_errors.banners =
                        u.error.clientToUniversal(groupModel.get('banners').map(function(banner) {
                            var bannerValidationResult = banner.validate();

                            if (!bannerValidationResult.valid) {
                                // в ручку отправляем/получаем href
                                bannerValidationResult.errorFields = (bannerValidationResult.errorFields || [])
                                    .map(
                                        function(field) {
                                            return field == 'href_model' ? 'href' : field;
                                        });

                                bannerValidationResult.errors = bannerValidationResult.errors || [];

                                if (bannerValidationResult.errorsData.href_model) {
                                    bannerValidationResult.errorsData.href =
                                        bannerValidationResult.errorsData.href_model;
                                    delete bannerValidationResult.errorsData.href_model;
                                }
                            }

                            return bannerValidationResult;
                        }));

                    return result;
                } else {
                    return null;
                }
            });

        if (!isValid) {
            this._showErrors(this._prepareErrorsData({
                groups: {
                    array_errors: groupsErrorData
                }
            }));
        }

        return isValid;
    },

    /**
     * @override {p-multiedit2}
     */
    _getGroupData: function(groupModel) {
        var originalData = groupModel.provideData(),
            data = u._.pick(originalData, [
                'adgroup_id',
                'tags',
                'geo',
                'minus_words',
                'group_name'
            ]);

        data.auto_price = groupModel.getAutoPriceData();

        data.banners = originalData.banners.map(function(banner) {
            return u._.pick(banner, [
                'ad_type',
                'bid',
                'href',
                'url_protocol',
                'image_ad'
            ]);
        });
        data.keywords = groupModel.getPhrasesData().map(function(phrase) {
            return u._.omit(phrase, ['param1', 'param2']);
        });
        data.hierarchical_multipliers = groupModel.getMultipliersData();

        return data;
    },

    /**
     * Отправляет форму (ajax) при отсутствии ошибок клиентской валидации
     * @param {Object} [additionalData] доп. данные для отправки
     * @param {Number} [additionalData.save_draft] флаг "сохранить как черновик"
     * @override
     * @private
     */
    _submitForm: function(additionalData) {
        var isGroupsValid = this._validateGroups();

        if (isGroupsValid) {
            if (this.params.isNewGroup) {
                BEM.blocks['b-metrika2'].reachGoal({
                    target: 'GROUP_WITH_BANNERS_CLICKED_SAVE',
                    id: 191494,
                    params: {
                        groupWithBanners: 'mcbanner'
                    }
                });
            }

            this.__base({ ajax: true, additionalData: additionalData });
        }
    }
});
