match(function() {
    return /^(addAdGroupsMobileContent|editAdGroupsMobileContent)$/
        .test(this.data.cmd);
})(

    block('app-main')(

        mode('preprocess')(function() {
            var data = this.data,
                campaignTags = data.campaign.tags || [],
                form = data.FORM,
                copyRegexp = RegExp('.*\\(' + iget2('p-multiedit2', 'kopiya', 'копия') + '\\)$', 'gi');

            //отключение клиентской валидации
            if (this.data.COOKIES.disable_client_validation && this.data.is_beta) {
                data.disable_client_validation = 1;
            }

            this.isSingleGroup = !!(!data.campaign.groups || data.campaign.groups.length <= 1);
            this.isNewGroup = data.campaign.groups[0] && !data.campaign.groups[0].adgroup_id;
            this.isCopyGroup = !!data.is_groups_copy_action;
            this.isTwoSteps = !!(data.statusEmpty == 'Yes' || form.from_newCamp);

            data.loadVCardFromClient = true;

            this.data.prev_banner && this.data.prev_banner.title && (this.data.prev_banner.modelId = 'prev');
            data = u['i-process-campaign-data'].patch(data);

            data.campaign.groups && data.campaign.groups.forEach(function(group, i) {
                var phrasesFiltered = [],
                    newPhrases = [];

                if (group.is_group_copy_action) {
                    var groupName = group.group_name && group.group_name.toString();

                    if (!groupName.match(copyRegexp)) {
                        group.group_name = groupName + ' (' + iget2('p-multiedit2', 'kopiya', 'копия') + ')';
                    }
                }

                //DIRECT-39380
                group.phrases = group.phrases || [];
                group.new_phrases = [];
                group.withVCard = true;
                group.isEmpty = !group.isNewGroup && group.banners.length === 1 && group.banners[0].isNewBanner;
                group.phrases && group.phrases.forEach(function(phrase) {
                    if (phrase.id) {
                        phrasesFiltered.push(phrase);
                    } else {
                        newPhrases.push(phrase.phrase);
                    }
                });

                //DIRECT-48200 @heliarian на странице создания группы adgroup_type не приходит с сервера
                group.adgroup_type = 'mobile_content';

                group.phrases = phrasesFiltered;
                group.new_phrases = newPhrases;

                if (!group.banners.length) {
                    group.banners.push({
                        bid: 0
                    });
                    group.banners_quantity = 1;
                }

                group = u['i-banners-group-data'].patch({
                    hasPrevBanner: data.prev_banner && data.prev_banner.title,
                    prevBanner: data.prev_banner,
                    count: i,
                    bannersGroup: group,
                    isNewGroup: this.isNewGroup,
                    isCopyGroup: this.isCopyGroup,
                    isSingleGroup: this.isSingleGroup,
                    campaignTags: campaignTags,
                    isDevicesEnabled: hasEnabledFeatures('cpc_device_modifiers')
                }, data);

                var dmData = u['dm-mobile-content-group'].transformData({
                    group: group,
                    campaign: data.campaign,
                    campaignTags: this.data.campaign.tags
                });

                // синхронизация данных группы с дата-моделью
                u._.extend(group, dmData);
            }, this);

            data.campaign.common_vcard_set = false;
            data.campaign.common_geo_set = !!data.campaign.common_geo;

            data = u['i-phrases-separate-into-groups'].patch(data, {
                hasSuspended: true,
                isNotBiddable: true
            });

            return data;
        }),

        mode('page-block')({
            block: 'p-multiedit2',
            mods: {
                type: 'mobile-content'
            }
        })
    ),

    block('b-page')(
        mode('content-only')(function() {
            return this.data.FORM.popupMode === '1';
        }),

        def().match(function() {
            return !this.pageParams;
        })(function() {
            var titleType = (this.isNewGroup || this.isCopyGroup) ? 'create' : this.data.FORM.banner_status,
                titles = {
                    wait: iget2('p-multiedit2', 'redaktirovanie-gruppy-reklamy-mobilnyh', 'Редактирование группы рекламы мобильных приложений'),
                    decline: iget2(
                        'p-multiedit2',
                        'redaktirovanie-otklonyonnyh-obyavleniy-reklamy',
                        'Редактирование отклонённых объявлений рекламы мобильных приложений'
                    ),
                    off: iget2(
                        'p-multiedit2',
                        'redaktirovanie-ostanovlennyh-obyavleniy-reklamy',
                        'Редактирование остановленных объявлений рекламы мобильных приложений'
                    ),
                    draft: iget2(
                        'p-multiedit2',
                        'redaktirovanie-obyavleniy-chernovikov-reklamy',
                        'Редактирование объявлений-черновиков рекламы мобильных приложений'
                    ),
                    arch: iget2(
                        'p-multiedit2',
                        'redaktirovanie-arhivnyh-obyavleniy-reklamy',
                        'Редактирование архивных объявлений рекламы мобильных приложений'
                    ),
                    create: iget2('p-multiedit2', 'sozdanie-gruppy-reklamy-mobilnyh', 'Создание группы рекламы мобильных приложений'),
                    all: this.data.campaign.groups && this.data.campaign.groups.length == 1 ?
                        iget2('p-multiedit2', 'redaktirovanie-gruppy-reklamy-mobilnyh', 'Редактирование группы рекламы мобильных приложений') : iget2('p-multiedit2', 'redaktirovanie-grupp-reklamy-mobilnyh', 'Редактирование групп рекламы мобильных приложений')
                };

            return applyNext({
                pageParams: {
                    title: titles[titleType] || iget2(
                        'p-multiedit2',
                        'redaktirovanie-aktivnyh-obyavleniy-reklamy',
                        'Редактирование активных объявлений рекламы мобильных приложений'
                    )
                }
            });
        }),

        mode('title')(function() {
            return this.pageParams.title;
        })
    )

);

block('p-multiedit2').mod('type', 'mobile-content')(

    addJs()(function() {
        return {
            cid: this.data.campaign.cid,
            groupsIds: this.data.campaign.groups.map(function(groupData) {
                return groupData.modelId;
            }),
            isFirstCampaign: this.data.is_first_camp,
            isNewGroup: this.isNewGroup
        };
    }),

    content()(function() {
        var campaign = this.data.campaign,
            isCampaignModerated = campaign.statusModerate && campaign.statusModerate !== 'New';

        return [
            {
                elem: 'models',
                content: {
                    block: 'i-model-aggregator',
                    content: [
                        {
                            block: 'i-model',
                            modelParams: {
                                name: 'dm-mobile-content-campaign',
                                id: this.data.campaign.cid,
                                data: applyCtx({
                                    block: 'dm-mobile-content-campaign'
                                })
                            }
                        },
                        this.data.campaign.groups.map(function(groupData) {
                            return {
                                block: 'i-model',
                                modelParams: {
                                    name: 'dm-mobile-content-group',
                                    id: groupData.modelId,
                                    data: u['dm-mobile-content-group'].transformData({
                                        group: groupData,
                                        currency: campaign.currency,
                                        campaign: this.data.campaign,
                                        campaignTags: this.data.campaign.tags
                                    })
                                }
                            };
                        }, this)
                    ]
                }
            },
            !!this.data.campaign.common_geo_set && {
                block: 'i-model',
                modelParams: {
                    name: 'm-geo-regions',
                    id: 'common',
                    data: {
                        geo: this.data.campaign.geo,
                        geo_names: this.data.campaign.geo_names
                    }
                }
            },
            {
                block: 'b-retargetings-data'
            },
            {
                block: 'l-page',
                mix: {
                    block: 'p-multiedit2',
                    mods: {
                        type: 'mobile-content'
                    },
                    elem: 'content-layout'
                },
                mods: {
                    layout: '16-60-16'
                },
                content: [
                    {
                        elem: 'row',
                        left: true,
                        center: [
                            {
                                block: 'b-page-title',
                                mix: {
                                    block: 'p-multiedit2',
                                    mods: {
                                        type: 'mobile-content'
                                    },
                                    elem: 'title'
                                },
                                content: [
                                    (this.isNewGroup || this.isCopyGroup) && this.isTwoSteps && {
                                        elem: 'steps-title',
                                        content: iget2('p-multiedit2', 'shag-2-iz-2', 'Шаг 2 из 2')
                                    },
                                    {
                                        elem: 'title',
                                        content: this.pageParams.title
                                    }
                                ]
                            },
                            {
                                block: 'p-multiedit2',
                                elem: 'campaign-title',
                                elemMods: {
                                    'is-new': this.isNewGroup || this.isCopyGroup ? 'yes' : 'no'
                                }
                            },
                            {
                                block: 'b-edit-groups-arch-warning'
                            },
                            {
                                block: 'b-edit-groups-error-header',
                                mods: {
                                    visible: this.data.has_errors ? 'yes' : '',
                                    'group-type': 'mobile-content'
                                },
                                groups: this.data.campaign.groups.filter(function(group) {
                                    return group && group.errors && !u._.isEmpty(group.errors);
                                }),
                                modelName: 'b-edit-group_type_mobile-content',
                                isSingleGroup: this.isSingleGroup,
                                isNewGroup: this.isNewGroup,
                                isCopyGroup: this.isCopyGroup
                            }
                        ],
                        rgap: true,
                        right: true
                    },
                    {
                        elem: 'row',
                        center: {
                            elem: 'separator',
                            mix: {
                                block: 'p-multiedit2',
                                mods: {
                                    type: 'mobile-content'
                                },
                                elem: 'separator'
                            }
                        },
                        ctxCells: {
                            center: {
                                attrs: {
                                    colspan: 4
                                }
                            }
                        }
                    },
                    applyCtx({
                        block: 'p-multiedit2',
                        elem: 'mass-actions',
                        isSingleGroup: this.isSingleGroup
                    }),
                    {
                        elem: 'row',
                        center: applyCtx({
                            block: 'p-multiedit2',
                            elem: 'multiedit-container',
                            type: 'mobile-content',
                            formData: {
                                cmd: 'saveMobileAdGroups',
                                autoPrice: 1
                            },
                            editData: {
                                type: 'mobile-content',
                                headerType: 'mobile-content'
                            },
                            buttonsData: {
                                isCampaignModerated: false,
                                buttons: function() {
                                    return [
                                        this.isTwoSteps && 'back',
                                        {
                                            name: 'submit',
                                            // DIRECT-52588 только при создании, не при копировании
                                            mix: this.isNewGroup && {
                                                block: 'b-metrika',
                                                js: { goal: 'MEDIATYPETEXT2' }
                                            }
                                        },
                                        hasLoginRights('AllowImportXlsBanners', 'agency_control') &&
                                            isCampaignModerated && 'to-draft'
                                    ];
                                }.call(this)
                            }
                        }),
                        ctxCells: {
                            center: {
                                attrs: {
                                    colspan: 4
                                }
                            }
                        }
                    }
                ]
            },
            {
                block: 'p-multiedit2',
                mods: {
                    type: 'mobile-content'
                },
                elem: 'popups'
            }
        ];
    }),

    elem('popups').replace()(function() {
        return [
            {
                block: 'b-minus-words-control',
                elem: 'popup',
                elemMods: { type: 'mobile-content' },
                for: 'groups'
            },
            {
                elem: 'outboard-popup',
                elemMods: {
                    type: 'mobile-pic-selector-control'
                }
            },
            {
                elem: 'outboard-popup',
                elemMods: {
                    type: 'wordstat-control'
                },
                innerBlock: {
                    block: 'b-wordstat',
                    js: {
                        modelName: 'dm-mobile-content-group',
                        isMobile: true
                    }
                }
            }
        ];
    })
);
