/**
 * Страничный блок: Мультиредактирование
 * @param {Object} this.params js-параметры блока
 * @param {String} this.params.cid Идентификатор кампании
 * @param {Array} this.params.groupsIds Идентификаторы групп в кампании
 */
BEM.DOM.decl({ block: 'p-multiedit2', modName: 'type', modVal: 'mobile-content' }, {

    /**
     * У РМП нет уточнений, убираем инициацию
     * @override
     * @private
     */
    _initCallouts: function() {},

    /**
     * Инициализирует дата-модели на странице, подписывается на события
     * @override
     * @private
     */
    _initModels: function() {
        this.__base.apply(this, ['dm-mobile-content-campaign']);

        this._groupsModels = this.params.groupsIds.map(function(id) {
            var model = BEM.MODEL.getOrCreate({
                name: 'dm-mobile-content-group',
                id: id
            });

            model.init();
            model.fix();

            return model;
        });
    },

    /**
     * Подписывается на события внутренних блоков
     * @override
     * @private
     */
    _initEvents: function() {
        var _this = this;

        this.__base.call(this);

        if (this._next) {
            this._subscriptions.on(this._next, 'click', function(e) {
                e.preventDefault();

                this._submitForm();
            }, this);
        }

        if (this._draft) {
            this._draft.un('click');
            this._subscriptions.on(this._draft, 'click', function(e) {
                e.preventDefault();

                this.findBlockOn('save-draft', 'b-hidden').val(1);
                this._submitForm();
            }, this);
        }

        //DIRECT-46164: Не загружаются данные по МП при клике на кнопку Далее сразу после ввода ссылки
        this.findBlocksInside('b-edit-group-mobile-content-href').forEach(function(block) {
            _this._subscriptions.wrap(block)
                .on('start-editing end-editing', function(e) {
                    var button = _this._next || _this._submit;

                    button.setMod('disabled', e.type === 'start-editing' ? 'yes' : '');
                });
        });
    },

    /**
     * Отправляет форму, валидирует данные перед отправкой
     * @override
     * @private
     */
    _submitForm: function() {
        var base = this.__base;
        // Проверяем пересечение минус слов с ключевыми фразами
        BEM.blocks['b-minus-words-control'].checkBanners(
            this._groupsModels,
            this._campModel,
            function() {
                var isGroupsValid = this._validateGroups();

                if (isGroupsValid) {
                    this.findBlockOn('json-groups', 'b-hidden').val(JSON.stringify(this._getGroupsData()));
                    if (this.params.isNewGroup) {
                        BEM.blocks['b-metrika2'].reachGoal('RMP_F3_ADGROUP_CREATED');

                        BEM.blocks['b-metrika2'].reachGoal({
                            target: 'GROUP_WITH_BANNERS_CLICKED_SAVE',
                            id: 191494,
                            params: {
                                groupWithBanners: 'mobile_content'
                            }
                        });
                    }
                    base.call(this);
                }
            }, this);
    },

    /**
     * Валидирует группы, находящиеся на редактировании
     * @returns {boolean}
     * @override
     * @private
     */
    _validateGroups: function() {
        if (u.consts('disable_client_validation')) return true;

        var titleErrors = [],
            bannersErrors = [],
            groupsErrors = [],
            hasErrors;

        this._groupsModels.forEach(function(model) {
            var result = model.validate();

            if (!result.valid) {
                var size = u._.size(result.errorsData);

                // если есть ошибки, кроме group_name
                if (size > 1 || !(size === 1 && result.errorsData.group_name)) {
                    groupsErrors.push(model.toJSONForErrors());
                }

                if (result.errorsData.group_name)
                    titleErrors.push(model.toJSONForErrors());
            }

            model.get('banners').forEach(function(bannerModel) {
                var isValid = bannerModel.isValid();

                if (!isValid) {
                    bannersErrors.push({
                        banner: this._getBannerErrorData(bannerModel),
                        group: this._getGroupErrorData(model)
                    });
                }
            }, this);
        }, this);

        hasErrors = titleErrors.length || bannersErrors.length || groupsErrors.length;

        if (hasErrors) {
            this.channel('multiedit-errors').trigger('invalid', {
                titleErrors: titleErrors,
                bannersErrors: bannersErrors,
                groupsErrors: groupsErrors
            });
        }

        return !hasErrors;
    },

    /**
     * Возвращает данные группы, существенные для ошибок
     * @param {dm-mobile-content-group} groupModel
     * @returns {Object}
     */
    _getGroupErrorData: function(groupModel) {
        return u._.pick(
            groupModel.toJSON(),
            ['isCopyGroup', 'newGroupIndex', 'isNewGroup', 'isSingleGroup', 'adgroup_id', 'modelId']
        );
    },

    /**
     * Возвращает данные группы, существенные для ошибок
     * @param {dm-mobile-content-banner} bannerModel
     * @returns {Object}
     */
    _getBannerErrorData: function(bannerModel) {
        return u._.pick(bannerModel.toJSON(), ['isNewBanner', 'newBannerIndex', 'bid', 'modelId']);
    }
});
