BEM.DOM.decl({ block: 'p-multiedit2', modName: 'type', modVal: 'text' }, {

    onSetMod: {

        js: function() {
            this.__base.apply(this, arguments);

            this._setBannerMediaResources();
        }
    },

    /**
     * Инициализация коллаутов с правильной группой
     * @override
     * @private
     */
    _initCallouts: function() {
        this.__base.apply(this, ['m-group']);
    },

    /**
     * Инициализация необходимых моделей
     * @override
     * @private
     */
    _initModels: function() {
        this.__base.apply(this, ['m-campaign']);

        this._groupsModels = this.params.groupsIds.map(function(id) {
            return BEM.MODEL.getOrCreate({
                name: 'm-group',
                id: id
            });
        });
    },

    /**
     * Подписка на события блоков
     * @override
     * @private
     */
    _initEvents: function() {
        this.__base.call(this);
        this._checkingHrefs = {};

        if (this._submit) {
            this._submit.un('click');
            this._subscriptions.on(this._submit, 'click', this._onSubmit, this);
        }

        if (this._draft) {
            this._draft.un('click');
            this._subscriptions.on(this._draft, 'click', function(e) {
                this.elem('save-draft').val(1);
                this._onSubmit(e);
            }, this);
        }

        BEM.channel('banners-hrefs').on('state', function(e, data) {
            var isHrefsLoaded;

            if (data.state == 'loaded') {
                delete this._checkingHrefs[data.id];
            } else {
                this._checkingHrefs[data.id] = data.state;
            }

            isHrefsLoaded = Object.keys(this._checkingHrefs).length == 0;

            this._submit && this._submit.setMod('disabled', isHrefsLoaded ? '' : 'yes');
            this._next && this._next.setMod('disabled', isHrefsLoaded ? '' : 'yes');
            this.setMod(this.elem('loading'), 'hidden', isHrefsLoaded ? 'yes' : '');
        }, this);
    },

    /**
     * Обработчик нажатия на кнопку назад
     * @param {Event} e - событие
     * @returns {Boolean}
     * @private
     */
    _onSubmit: function(e) {
        e.preventDefault();

        // Проверяем пересечение минус слов с ключевыми фразами
        BEM.blocks['b-minus-words-control']
            .checkBanners(this._groupsModels, this._campModel, this._submitForm, this);
    },

    /**
     * Валидирует группы, находящиеся на редактировании
     * @returns {Boolean}
     * @override
     * @private
     */
    _validateGroups: function() {
        if (u.consts('disable_client_validation')) return true;

        var titleErrors = [],
            bannersErrors = [],
            groupsErrors = [],
            hasErrors,
            result;

        this._groupsModels.forEach(function(model) {

            result = model.validate();

            if (!result.valid) {
                if (result.errorsData.group_name) titleErrors.push(model.toJSONForErrors());

                var size = u._.size(result.errorsData);

                result.errorsData.group_name && (size = size - 1);
                if (size > 0) groupsErrors.push(model.toJSONForErrors());
            }
        });

        //проверяем все визитки и если хотя бы одна не валидная - меняем флаг на false
        //проверка ВСЕХ визиток нужна для того, чтобы пользователь увидел все ошибки
        //а не только те, что есть у первой невалидной.
        this.findBlocksInside('b-vcard-control').forEach(function(vcard) {
            var bannerModel = vcard.bannerModel,
                isBannerValid = bannerModel.isValid();

            if (!bannerModel.get('isVCardEmpty') && (bannerModel.get('ad_type') === 'text') &&
                bannerModel.get('has_vcard') && !vcard.validate() || !isBannerValid) {

                bannersErrors.push({
                    banner: bannerModel.toJSONForErrors(),
                    group: vcard.groupModel.toJSONForErrors()
                });
            }
        });

        hasErrors = titleErrors.length || bannersErrors.length || groupsErrors.length;

        if (hasErrors) {
            this.channel('multiedit-errors').trigger('invalid', {
                titleErrors: titleErrors,
                bannersErrors: bannersErrors,
                groupsErrors: groupsErrors
            });
        }

        return !hasErrors;
    },

    /**
     * Вызывает валидацию групп, вызывает проверку изменения визитной карточки и региона,
     * в случае успешных результатов проверок отправляет форму (в базовой реализации)
     * @override
     * @private
     */
    _submitForm: function() {
        var groupsValidate = this._validateGroups();

        if (groupsValidate) {
            var _this = this,
                base = this.__base;

            this._compareAddress()
                .then(function() {
                    _this._confirmDomainChange().then(function() {
                        _this.findBlockOn('json-groups', 'b-hidden').val(JSON.stringify(_this._getGroupsData()));
                        base.call(_this);
                    });
                });
        }
    },

    /**
     * Инициализация медиа ресурсов баннеров всех групп
     * @private
     */
    _setBannerMediaResources: function() {
        this.findBlocksInside('b-edit-group').forEach(function(group) {
            group.setBannerMediaResources(this.params.bannerMediaResources);
        }, this);
    }
});
