match(function() {
    return (/^(showCampMultiEdit|addBannerMultiEdit|gobackMultiEdit|bannersMultiSave)$/)
        .test(this.data.cmd) && this.data.java_backend;
})(

    block('app-main')(

        mode('preprocess')(function() {
            var data = this.data,
                campaignTags = data.campaign.tags || [],
                form = data.FORM,
                copyRegexp = RegExp('.*\\(' + iget2('p-multiedit2', 'kopiya', 'копия') + '\\)$', 'gi');

            //отключение клиентской валидации
            if (this.data.COOKIES.disable_client_validation && this.data.is_beta) {
                data.disable_client_validation = 1;
            }

            this.isSingleGroup = !!(!data.campaign.groups || data.campaign.groups.length <= 1);
            this.isNewGroup = data.campaign.groups[0] && !data.campaign.groups[0].adgroup_id;
            this.isCopyGroup = !!data.is_groups_copy_action;
            this.isTwoSteps = !!(data.statusEmpty == 'Yes' || form.from_newCamp);

            data.loadVCardFromClient = true;

            this.data.prev_banner && this.data.prev_banner.title && (this.data.prev_banner.modelId = 'prev');

            data.campaign.groups && data.campaign.groups.forEach(function(group, i) {
                var phrasesFiltered = [],
                    newPhrases = [],
                    groupName;

                //DIRECT-44701: ссылка на сайт сохраняется с лишним http
                group.banners.forEach(function(banner) {
                    banner.href = banner.href ? u.stripHttp(banner.href) : '';
                    banner.has_site_enum = 'yes';
                    if (!banner.href && banner.turbolanding) {
                        banner.has_site_enum = 'no';
                    }
                });

                //DIRECT-40991: Редактирование пустых групп
                if (!group.banners.length) {
                    group.banners.push({
                        bid: 0,
                        vcard: data.prev_banner && data.prev_banner.vcard || data.campaign.vcard,
                        video_resources: data.auto_video ?
                            u._.sample(data.generated_video_creatives) || {} :
                            {}
                    });

                    group.banners_quantity = 1;
                }

                //DIRECT-39380
                group.phrases = group.phrases || [];
                group.new_phrases = [];
                group.withVCard = true;
                group.isEmpty = !group.isNewGroup && group.banners.length === 1 && group.banners[0].isNewBanner;
                group.phrases && group.phrases.forEach(function(phrase) {
                    if (phrase.id) {
                        phrasesFiltered.push(phrase);
                    } else {
                        newPhrases.push(phrase.phrase);
                    }
                });

                group.phrases = phrasesFiltered;
                group.new_phrases = newPhrases;

                // Для получения модели кампании из модели группы, например, при создании новой группы
                group.cid = group.cid || data.campaign.cid;

                if (group.is_group_copy_action) {
                    groupName = group.group_name || '';

                    if (!groupName || !groupName.match(copyRegexp)) {
                        group.group_name = groupName + ' (' + iget2('p-multiedit2', 'kopiya', 'копия') + ')';
                    }
                }

                group = u['i-banners-group-data'].patch({
                    hasPrevBanner: data.prev_banner && data.prev_banner.title,
                    prevBanner: data.prev_banner,
                    count: i,
                    bannersGroup: group,
                    isNewGroup: this.isNewGroup,
                    isCopyGroup: this.isCopyGroup,
                    isSingleGroup: this.isSingleGroup,
                    campaignTags: campaignTags,
                    isDevicesEnabled: hasEnabledFeatures('cpc_device_modifiers') ||
                        u.consts('isMobileOsBidModifierEnabled'),
                    isWithoutDeviceRestrictions: hasEnabledFeatures('cpc_device_modifiers')
                }, data);
            }, this);

            data.campaign.common_vcard_set = !!(data.campaign.vcard && data.campaign.vcard.city);
            data.campaign.common_geo_set = !!data.campaign.common_geo;

            data = u['i-phrases-separate-into-groups'].patch(data, {
                hasSuspended: true,
                isNotBiddable: true
            });
            data = u['i-process-campaign-data'].patch(data);

            return data;
        }),

        mode('page-block')({
            block: 'p-multiedit2',
            mods: {
                type: 'text2'
            }
        })
    ),

    block('b-page')(
        mode('content-only')(function() {
            return this.data.FORM.popupMode === '1';
        }),

        def().match(function() {
            return !this.pageParams;
        })(function() {
            var bannerStatus = this.data.FORM.banner_status,
                title;

            if (this.isNewGroup || this.isCopyGroup) {
                title = iget2('p-multiedit2', 'sozdanie-gruppy-obyavleniy', 'Создание группы объявлений');
            } else {
                switch (bannerStatus) {
                    case 'all':
                        title = this.data.campaign.groups && this.data.campaign.groups.length == 1 ?
                            iget2('p-multiedit2', 'redaktirovanie-gruppy-obyavleniy', 'Редактирование группы объявлений') :
                            iget2('p-multiedit2', 'redaktirovanie-grupp-obyavleniy', 'Редактирование групп объявлений');
                        break;
                    case 'wait':
                        title = iget2('p-multiedit2', 'redaktirovanie-obyavleniy-na-moderacii', 'Редактирование объявлений на модерации');
                        break;
                    case 'decline':
                        title = iget2('p-multiedit2', 'redaktirovanie-otklonyonnyh-obyavleniy', 'Редактирование отклонённых объявлений');
                        break;
                    case 'off':
                        title = iget2('p-multiedit2', 'redaktirovanie-ostanovlennyh-obyavleniy', 'Редактирование остановленных объявлений');
                        break;
                    case 'draft':
                        title = iget2('p-multiedit2', 'redaktirovanie-obyavleniy-chernovikov', 'Редактирование объявлений-черновиков');
                        break;
                    case 'arch':
                        title = iget2('p-multiedit2', 'redaktirovanie-arhivnyh-obyavleniy', 'Редактирование архивных объявлений');
                        break;
                    default:
                        title = iget2('p-multiedit2', 'redaktirovanie-aktivnyh-obyavleniy', 'Редактирование активных объявлений');
                }
            }

            return applyNext({
                pageParams: {
                    title: title
                }
            });
        }),

        mode('title')(function() {
            return this.pageParams.title;
        }),

        elem('foot-js').content()(function() {
            var result = applyNext(),
                langList = {
                    ru: 'ru-RU',
                    en: 'en-US',
                    tr: 'tr-TR',
                    ua: 'uk-UA'
                };

            result.push({
                elem: 'js',
                url: u.formatUrl({
                    host: '//api-maps.yandex.ru',
                    path: '2.1',
                    query: {
                        lang: langList[this.data.lang] || langList.ru,
                        coordorder: 'longlat'
                    }
                })
            });

            return result;
        })
    )

);

block('p-multiedit2').mod('type', 'text2')(

    addJs()(function() {
        return {
            popupMode: this.data.FORM.popupMode === '1',
            cid: this.data.campaign.cid,
            groupsIds: this.data.campaign.groups.map(function(groupData) {
                return groupData.modelId;
            }),
            urlParams: u._.omit(u.getUrlParams(), [
                'json_groups'
            ]),
            isFirstCampaign: this.data.is_first_camp,
            bannerMediaResources: {
                video: this.data.generated_video_creatives
            },
            promoCodeDomains: this.data.promocode_domains
        };
    }),

    content()(function() {

        var data = this.data,
            campaign = data.campaign,
            isCampaignModerated = campaign.statusModerate && campaign.statusModerate !== 'New';

        return [
            {
                elem: 'models-data'
            },
            {
                block: 'b-retargetings-data'
            },
            {
                block: 'l-page',
                mix: [{
                    block: 'p-multiedit2',
                    elem: 'content-layout'
                }],
                mods: {
                    layout: '16-60-16'
                },
                content: [
                    {
                        elem: 'tbody',
                        mix: [
                            { block: 'b-errors-presenter2' },
                            {
                                block: 'p-multiedit2',
                                elem: 'errors-presenter',
                                elemMods: { position: 'navigation' }
                            }
                        ],
                        tag: 'tbody',
                        content: [
                            {
                                elem: 'row',
                                left: true,
                                center: [
                                    {
                                        block: 'b-page-title',
                                        mix: [
                                            {
                                                block: 'p-multiedit2',
                                                elem: 'title'
                                            }
                                        ],
                                        content: (function() {
                                            var title = {
                                                elem: 'title',
                                                content: this.pageParams.title
                                            };

                                            return [
                                                (this.isNewGroup || this.isCopyGroup) && this.isTwoSteps && {
                                                    elem: 'steps-title',
                                                    content: iget2('p-multiedit2', 'shag-2-iz-2', 'Шаг 2 из 2')
                                                },
                                                title
                                            ];
                                        }.call(this))
                                    },
                                    {
                                        block: 'p-multiedit2',
                                        elem: 'campaign-title',
                                        elemMods: {
                                            'is-new': this.isNewGroup || this.isCopyGroup ? 'yes' : 'no'
                                        }
                                    },
                                    {
                                        block: 'b-edit-groups-arch-warning'
                                    },
                                    {
                                        block: 'b-error-pretty-message',
                                        mods: { theme: 'classic' },
                                        mix: {
                                            block: 'p-multiedit2',
                                            elem: 'pretty-message',
                                            elemMods: { position: 'main-errors-title' }
                                        },
                                        attrs: { 'data-err-path': 'mainErrorsTitle' }
                                    },
                                    {
                                        block: 'b-error-pretty-message',
                                        mods: { theme: 'classic' },
                                        mix: { block: 'p-multiedit2', elem: 'pretty-message' },
                                        attrs: { 'data-err-path': 'groupsErrorsNavigation' }
                                    },
                                    {
                                        block: 'b-error-pretty-message',
                                        mods: { theme: 'classic' },
                                        mix: { block: 'p-multiedit2', elem: 'pretty-message' },
                                        attrs: { 'data-err-path': 'groupNameErrors' }
                                    },
                                    {
                                        block: 'b-error-pretty-message',
                                        mods: { theme: 'classic' },
                                        mix: { block: 'p-multiedit2', elem: 'pretty-message' },
                                        attrs: { 'data-err-path': 'bannersErrorsNavigation' }
                                    }
                                ],
                                rgap: true,
                                right: true
                            }
                        ]
                    },
                    {
                        elem: 'tbody',
                        mix: [
                            { block: 'b-errors-presenter2' },
                            {
                                block: 'p-multiedit2',
                                elem: 'errors-presenter',
                                elemMods: { position: 'groups' }
                            }
                        ],
                        tag: 'tbody',
                        content: [
                            {
                                elem: 'row',
                                left: true,
                                center: {
                                    block: 'b-error-pretty-message',
                                    mods: { theme: 'classic' },
                                    mix: { block: 'p-multiedit2', elem: 'pretty-message' },
                                    attrs: { 'data-err-path': '' }
                                },
                                ctxCells: {
                                    center: {
                                        attrs: {
                                            colspan: 4
                                        }
                                    }
                                },
                                rgap: true,
                                right: true
                            },
                            {
                                elem: 'row',
                                center: {
                                    elem: 'separator',
                                    mix: [
                                        {
                                            block: 'p-multiedit2',
                                            elem: 'separator'
                                        }
                                    ]
                                },
                                ctxCells: {
                                    center: {
                                        attrs: {
                                            colspan: 4
                                        }
                                    }
                                }
                            },
                            applyCtx({
                                block: 'p-multiedit2',
                                elem: 'mass-actions',
                                isSingleGroup: this.isSingleGroup
                            }),
                            {
                                elem: 'row',
                                mix: [
                                    {
                                        block: 'p-multiedit2',
                                        elem: 'form-container'
                                    }
                                ],
                                center: applyCtx({
                                    block: 'p-multiedit2',
                                    elem: 'multiedit-container',
                                    type: 'text',
                                    hasMediaResources: true,
                                    formData: {
                                        cmd: 'bannersMultiSave',
                                        autoPrice: 1,
                                        bids: '' // TODO isLight
                                    },
                                    editData: {
                                        type: 'text-full'
                                    },
                                    buttonsData: {
                                        isCampaignModerated: false,
                                        buttons: function() {
                                            return [
                                                this.isTwoSteps && 'back',
                                                {
                                                    name: 'submit',
                                                    // DIRECT-52588 только при создании, не при копировании
                                                    mix: this.isNewGroup && {
                                                        block: 'b-metrika',
                                                        js: { goal: 'MEDIATYPETEXT2' }
                                                    }
                                                },
                                                hasLoginRights('AllowImportXlsBanners', 'agency_control') &&
                                                isCampaignModerated && 'to-draft'
                                            ];
                                        }.call(this)
                                    },
                                    hintData: {
                                        hint: {
                                            block: 'p-multiedit2',
                                            elem: 'loading',
                                            elemMods: { hidden: 'yes' },
                                            content: [
                                                {
                                                    block: 'spin2',
                                                    mods: { size: 'xxs', progress: 'yes' },
                                                    mix: {
                                                        block: 'p-multiedit2',
                                                        elem: 'loading-spin'
                                                    }
                                                },
                                                iget2('p-multiedit2', 'idyot-proverka-ssylki', 'Идёт проверка ссылки')
                                            ]
                                        }
                                    }
                                }),
                                ctxCells: {
                                    center: {
                                        attrs: {
                                            colspan: 4
                                        }
                                    }
                                }
                            }
                        ]
                    }
                ]
            },
            {
                block: 'b-minus-words-control',
                elem: 'popup',
                for: 'groups'
            },
            {
                elem: 'outboard-popup',
                elemMods: {
                    type: 'pic-selector-control'
                }
            },
            {
                elem: 'outboard-popup',
                elemMods: {
                    type: 'wordstat-control'
                }
            },
            {
                elem: 'outboard-popup',
                elemMods: {
                    type: 'sitelinks-selector-control'
                },
                innerBlockMods: {
                    turbolandings: data.is_featureTurboLandingEnabled ? 'yes' : ''
                }
            },
            {
                block: 'b-group-retargeting',
                elem: 'popup'
            }
        ];
    }),

    elem('models-data').content()(function() {
        var data = this.data,
            campaign = data.campaign;

        return [
            {
                block: 'i-model-aggregator',
                content: {
                    block: 'i-model',
                    modelParams: {
                        name: 'm-campaign',
                        id: campaign.cid,
                        data: applyCtx({
                            block: 'm-campaign'
                        })
                    }
                }
            },
            campaign.groups.map(function(group) {
                return {
                    block: 'i-model',
                    modelParams: {
                        name: 'm-group',
                        id: group.modelId,
                        data: u['m-group'].transformData({
                            group: group,
                            currency: campaign.currency,
                            campaignTags: campaign.tags,
                            loadVCardFromClient: data.loadVCardFromClient
                        })
                    }
                };
            }, this),
            !!campaign.common_vcard_set && {
                block: 'i-model',
                modelParams: {
                    name: 'm-vcard',
                    id: 'common',
                    data: campaign.vcard
                }
            },
            !!campaign.common_geo_set && {
                block: 'i-model',
                modelParams: {
                    name: 'm-geo-regions',
                    id: 'common',
                    data: {
                        geo: campaign.geo,
                        geo_names: campaign.geo_names
                    }
                }
            },
            !!data.organizations && Object.keys(data.organizations).reduce(function(result, permalink) {
                var organizationData = data.organizations[permalink];

                return result.concat([

                    {
                        block: 'i-model',
                        modelParams: {
                            name: 'm-organization',
                            id: permalink,
                            data: u['m-organization'].transformData({
                                organization: organizationData
                            })
                        }
                    }
                ]);
            }.bind(this), [])
        ];
    })
);
