BEM.DOM.decl({ block: 'p-multiedit2', modName: 'type', modVal: 'text2' }, {

    onSetMod: {

        js: function() {
            this.__base.apply(this, arguments);

            this._setBannerMediaResources();
        }
    },

    /**
     * Инициализация коллаутов с правильной группой
     * @override
     * @private
     */
    _initCallouts: function() {
        this.__base.apply(this, ['m-group']);
    },

    /**
     * Инициализация необходимых моделей
     * @override
     * @private
     */
    _initModels: function() {
        this.__base.apply(this, ['m-campaign']);

        this._groupsModels = this.params.groupsIds.map(function(id) {
            return BEM.MODEL.getOrCreate({
                name: 'm-group',
                id: id
            });
        });
    },

    /**
     * Подписка на события блоков
     * @override
     * @private
     */
    _initEvents: function() {
        this.__base.call(this);
        this._checkingHrefs = {};

        if (this._submit) {
            this._submit.un('click');
            this._subscriptions.on(this._submit, 'click', this._onSubmit, this);
        }

        if (this._draft) {
            this._draft.un('click');
            this._subscriptions.on(this._draft, 'click', function(e) {
                this._onSubmit(e, { saveDraft: true });
            }, this);
        }

        BEM.channel('banners-hrefs').on('state', function(e, data) {
            var isHrefsLoaded;

            if (data.state == 'loaded') {
                delete this._checkingHrefs[data.id];
            } else {
                this._checkingHrefs[data.id] = data.state;
            }

            isHrefsLoaded = Object.keys(this._checkingHrefs).length == 0;

            this._submit && this._submit.setMod('disabled', isHrefsLoaded ? '' : 'yes');
            this._next && this._next.setMod('disabled', isHrefsLoaded ? '' : 'yes');
            this.setMod(this.elem('loading'), 'hidden', isHrefsLoaded ? 'yes' : '');
        }, this);
    },

    /**
     * Обработчик нажатия на кнопку назад
     * @param {Event} e - событие
     * @param {Object} buttonData
     * @returns {Boolean}
     * @private
     */
    _onSubmit: function(e, buttonData) {
        e.preventDefault();

        // Проверяем пересечение минус слов с ключевыми фразами
        BEM.blocks['b-minus-words-control']
            .checkBanners(this._groupsModels, this._campModel, function() {
                this._submitForm(buttonData);
            }, this);
    },

    /**
     * Валидирует группы, находящиеся на редактировании
     * @returns {Boolean}
     * @override
     * @private
     */
    _validateGroups: function() {
        if (u.consts('disable_client_validation')) return true;

        var errors = [],
            badFields = {
                href_model: 'href',
                phrases: 'keywords',
                new_phrases: 'new_keywords',
                new_suggestions: 'keywords_suggestions'
            };

        this._groupsModels.forEach(function(groupModel, groupIndex) {
            var groupValidate = groupModel.validate();

            if (!groupValidate.valid) {
                u._.keys(groupValidate.errorsData).forEach(function(field) {
                    var path = '[' + groupIndex + '].' + (badFields[field] || field);

                    groupValidate.errorsData[field].forEach(function(error) {
                        errors.push({
                            path: path,
                            description: error.text
                        });
                    });
                });
            }

            groupModel.getBanners().forEach(function(bannerModel, bannerIndex) {
                var bannerValidate = bannerModel.validate();

                if (!bannerValidate.valid) {
                    u._.keys(bannerValidate.errorsData).forEach(function(field) {
                        var path = '[' + groupIndex + '].banners[' + bannerIndex + '].' + (badFields[field] || field);

                        bannerValidate.errorsData[field].forEach(function(error) {
                            errors.push({
                                path: path,
                                description: error.text
                            });
                        });
                    });
                }
            });

        });

        // валидация визитки происходит не в модели =(
        // TODO кажется, можно выпилить, т.к. сохранение теперь через ajax
        // TODO но только после того, как ко всем полям визитки будут добавлены блоки с выводом ошибок
        this.findBlocksInside('b-edit-group-2').forEach(function(group, groupIndex) {
            this.findBlocksInside(group.deomElem, 'b-vcard-control').forEach(function(vcard, bannerIndex) {
                var bannerModel = vcard.bannerModel;

                if (!bannerModel.get('isVCardEmpty') && (bannerModel.get('ad_type') === 'text') &&
                    bannerModel.get('has_vcard') && !vcard.validate()) {

                    errors.push({
                        path: '[' + groupIndex + '].banners[' + bannerIndex + '].vcard',
                        description: iget2(
                            'p-multiedit2',
                            'vcard-oshibki-v-polyah-formy',
                            'Ошибки в полях формы &laquo;Адрес и телефон&raquo;'
                        )
                    });
                }
            });
        }, this);

        if (errors.length) {
            this._showJavaErrors(errors);
        }

        return !errors.length;
    },

    /**
     * Вызывает валидацию групп, вызывает проверку изменения визитной карточки и региона,
     * в случае успешных результатов проверок отправляет форму (в базовой реализации)
     * @param {Object} [buttonData] - информация о кнопке которая инициировала сохранение
     * @override
     * @private
     */
    _submitForm: function(buttonData) {
        var groupsValidate = this._validateGroups(),
            _this = this;

        if (groupsValidate) {
            this._compareAddress()
                .then(function() {
                    _this._confirmDomainChange().then(function() {
                        _this._toggleButtonsPanel(true)
                            .setMod(_this.elem('status-message'), 'progress', 'yes');

                        var groupsData = _this._getGroupsData(),
                            requestData = _this._getRequestData(groupsData),
                            groupData;

                        requestData.save_draft = !!(buttonData || {}).saveDraft;

                        if (requestData.is_new_adgroups && groupsData[0]) {
                            groupData = groupsData[0];

                            BEM.blocks['b-metrika2'].reachGoal({
                                target: 'GROUP_WITH_BANNERS_CLICKED_SAVE',
                                id: 191494,
                                params: {
                                    groupWithBanners: u._.keys(u._.groupBy(groupData.banners, 'ad_type')).reduce(function(acc, adType) {
                                        acc[adType] = true;

                                        return acc;
                                    }, {})
                                }
                            });
                        }

                        return BEM.blocks['i-web-api-request'].adGroups
                            .save(requestData)
                            .then(function(data) {
                                _this.delMod(_this.elem('status-message'), 'progress');

                                data.success ?
                                    _this._successfulSave(data, requestData.is_new_adgroups) :
                                    _this._notSuccessfulSave(data, groupsData)
                                        ._toggleButtonsPanel(false);
                            })
                            .catch(function() {
                                _this._toggleButtonsPanel(false)
                                    .delMod(_this.elem('status-message'), 'progress');

                                BEM.blocks['b-user-dialog']
                                    .alert(iget2(
                                        'p-multiedit2',
                                        'text-adgroup-save-error',
                                        'Ошибка сохранения. Попробуйте ещё раз.'
                                    ));
                            });
                    });
                });
        }
    },

    /**
     * Формирует данные группы
     * @param {BEM.MODEL} groupModel - модель группы
     * @returns {Object}
     * @private
     */
    _getGroupData: function(groupModel) {
        var data = groupModel.provideData();

        data.auto_price = groupModel.getAutoPriceData();
        data.retargetings = groupModel.getRetargetingsData();
        data.keywords = groupModel.getPhrasesData();
        data.hierarchical_multipliers = groupModel.getMultipliersData();
        data.relevance_match = groupModel.get('has_relevance_match') ? groupModel.getRelevanceMatchData() : [];
        data.errors = undefined;

        return data;
    }

}, {});
