block('i-utils').match(function() {
    return this.utilsElem;
}).def()(function() {
    u.register({
        'p-multiedit2': {
            /**
             * Возвращает js параметры страницы
             * @param {Object} data данные страницы
             * @returns {Object}
             */
            getPageJsParams: function(data) {
                var form = data.FORM,
                    params = {
                        cmd: data.cmd,
                        cid: data.campaign.cid,
                        is_groups_copy_action: data.is_groups_copy_action ? 1 : 0,
                        retpath: form && form.retpath || '',
                        bids: form.bids || '',
                        new_group: data.new_group,
                        ulogin: data.user_login,
                        btn_back: '',
                        save_draft: 0,
                        popupMode: form.popupMode
                    };

                data.from_import_xls && (params.from_import_xls = data.from_import_xls);
                data.autoPrice && (params.auto_price = 1);

                form.from_newCamp && (params.from_newCamp = form.from_newCamp);
                form.servicing_request && (params.servicing_request = form.servicing_request);
                form.banner_status && (params.banner_status = form.banner_status);

                hasLoginRights('super_control',
                    'placer_control',
                    'manager_control',
                    'is_teamleader',
                    'support_control',
                    'media_control') && (data.camp_banners_domain = '');

                return {
                    cid: data.campaign.cid,
                    errorPath: data.errorPath,
                    groupsIds: data.campaign.groups.map(function(groupData) {
                        return groupData.modelId;
                    }),
                    formParams: params,
                    popupMode: form.popupMode === '1'
                };
            }
        }
    });

    return applyNext({
        utilsElem: true
    });
});
