BEM.DOM.decl('p-multiedit2-java-ajax', {

    _getRequestData: function(groupsData) {
        var campModel = this._campModel,
            groupsModels = this._groupsModels,
            hasNewGroups = groupsModels.some(function(group) { return group.get('isNewGroup'); }),
            hasCopyGroups = groupsModels.some(function(group) { return group.get('isCopyGroup'); });

        groupsModels && groupsModels.forEach(function(groupModel) {
            var bannerModels = groupModel.get('banners');
            bannerModels && bannerModels.forEach(function(bannerModel) {
                // если в модели нет поля has_site, то логика про "есть сайт/хочу-турбостраницу" не применима
                if (bannerModel.hasField('has_site') && !bannerModel.get('has_site') && bannerModel.hasField('href_model')) {
                    bannerModel.get('href_model').clear('href');
                }
            });
        });

        var requestData = {
            adGroups: JSON.stringify(groupsData),
            campaign_id: this.params.cid,
            is_new_adgroups: hasNewGroups
        };

        if (u.consts('ulogin')) {
            requestData.ulogin = u.consts('ulogin');
        }

        if (campModel.get('camp_banners_domain')) {
            requestData.camp_banners_domain = campModel.get('camp_banners_domain');
        }

        if (hasCopyGroups) {
            requestData.is_copy = true;
            requestData.is_new_adgroups = true;
        }

        return requestData;
    },

    /**
     * Производит редирект после успешного сохранения
     * @param {Object} data
     * @param {Array} data.result - массив id успешно сохранившихся групп
     * @param {Boolean} data.success
     * @param {Boolean} hasNewGroups - флаг, создание новой группы
     * @private
     */
    _successfulSave: function(data, hasNewGroups) {
        if (this.params.popupMode) {
            window.location.href = u.getUrl(
                'dnaSaveSuccess',
                hasNewGroups ? { adgroupId: data.result[0] } : {}
            );
        } else {
            window.location.href = u.getUrl(
                'showCamp',
                u.consts('ulogin') ?
                    { cid: this.params.cid, ulogin: u.consts('ulogin') } :
                    { cid: this.params.cid }
            );
        }
    },

    /**
     * Обрабатывает ошибки серверной валидации
     * @param {Object} data
     * @param {Object} data.validation_result
     * @param {Array} data.validation_result.errors
     * @param {Boolean} data.success
     * @param {Array} groupsData
     * @returns {BEM}
     * @private
     */
    _notSuccessfulSave: function(data, groupsData) {
        var noNameErrors = [],
            vcardTitlesPath = [],
            serverErrors;

        // преобразуем ошибки в формат для b-errors-presenter2
        serverErrors = data.validation_result.errors.map(function(error) {
            var path = error.path,
                storePath = ('p-multiedit2.groups' + path).replace(/\[\d+]/g, '').split('.'),
                storeArg = [
                    {
                        value: u._.get(groupsData, path),
                        backendParams: error.params || {}
                    }
                ].concat(storePath, error.code),
                description = u['text-store'].get.apply(u['text-store'], storeArg);

            if (description === error.code) {
                description = iget2('p-multiedit2', 'default-error-text', 'Ошибка сохранения');
                noNameErrors.push({
                    code: error.code,
                    path: storePath.join('.')
                });
            }

            return {
                path: this._replaceServerErrorPath(error.path, groupsData),
                description: description
            };
        }, this);

        // ищем ошибки визитки и строим для них заголовок
        serverErrors.forEach(function(error) {
            if (this._errorPathTest('vcard', error.path)) {
                vcardTitlesPath.push(error.path.match(this._getPathRegExps('vcard'))[0]);
            }
        }, this);

        serverErrors = u._.uniq(vcardTitlesPath)
            .map(function(path) {
                return {
                    path: path,
                    description: iget2(
                        'p-multiedit2',
                        'vcard-oshibki-v-polyah-formy',
                        'Ошибки в полях формы &laquo;Адрес и телефон&raquo;'
                    )
                };
            })
            .concat(serverErrors);

        this._showJavaErrors(serverErrors, { from: 'server' });

        noNameErrors.length && this._sendNoNameToMetric(noNameErrors);

        return this;
    },

    /**
     * Логирование ошибок из JAVA
     * @param {Array} data
     * @param {String} data.code
     * @param {String} data.path
     * @private
     */
    _sendNoNameToMetric: function(data) {
        var errors = data.reduce(function(res, err) {
            res[err.code] || (res[err.code] = {});

            res[err.code][err.path] = true;

            return res;
        }, {});

        if (u.consts('is_beta')) {
            errors = { BETA: errors };
        } else {
            errors = { PROD: errors };
        }

        BEM.blocks['b-metrika2']
            .getCounter()
            .done(function(counter) {
                counter.reachGoal('JAVA_ERROR_NO_NAME', {
                    JAVA_ERROR_NO_NAME: errors
                })
            });
    },

    /**
     * Меняет путь серверной ошибки
     * @param {string} path
     * @param {Array} groupsData
     * @returns {string}
     * @private
     */
    _replaceServerErrorPath: function(path, groupsData) {
        var phrase,
            arrayPath,
            pixel;

        // распределяем ошибки фраз между фнтовыми блоками phrases, new_phrases, word-suggestions
        if (this._errorPathTest('keywords', path)) {
            arrayPath = u['b-errors-presenter2'].toPath(path);
            phrase = u._.get(
                groupsData,
                u['b-errors-presenter2'].joinPath(arrayPath.slice(0, 4))
            );

            switch (phrase.state) {
                case 'active':
                    return path;
                case 'new':
                    return path.replace(this._getPathRegExps('keywords'), function(match) {
                        return match.replace('keywords', 'new_keywords');
                    });
                default:
                    return path.replace(this._getPathRegExps('keywords'), function(match) {
                        return match.replace('keywords', 'keywords_suggestions');
                    });
            }
        }

        // раставляем порядок пикселей т.к. на бекенд отправляется массив
        // а на фронте pixels представляет собой два опциональных инпута audience и audit
        if (this._errorPathTest('pixels', path)) {
            pixel = u._.get(groupsData, path) || {};

            if (!pixel.kind) {
                return path.replace('pixels', 'pixels[1].audits');
            }

            switch (pixel.kind) {
                case 'audience':
                    return path.replace(/pixels\[\d+]/, 'pixels[0]');
                case 'audit':
                    return path.replace('pixels', 'pixels[1].audits');
            }
        }

        // Для cpm_yndx_frontpage кампаний меняем путь ошибок для цен
        if (this._errorPathTest('price_context', path) && this._campModel.get('mediaType') === 'cpm_yndx_frontpage') {
            return path.replace(/^\[\d+]\.retargetings/, '');
        }

        if (this._errorPathTest('turbolanding', path)) {
            var groupIndex = this._getGroupIndexByPath(path),
                groupData = groupsData[groupIndex];

            if (groupData.cpm_banners_type === 'cpm_geoproduct') {
                return path.replace('turbolanding', 'turbolandingGeoproduct');
            }
        }

        return path;
    },

    /**
     * Показывает ошибки валидации
     * @param {Array<Object>} errors
     * @param {string} errors.path - путь ошибки
     * @param {string} errors.description - понятный для пользователя текст ошибки
     * @returns {BEM}
     * @private
     */
    _showJavaErrors: function(errors) {
        this._getErrorsPresenter('groups')
            .showErrors(errors);

        BEM.DOM.win.scrollTop(this.elem('pretty-message', 'position', 'main-errors-title').offset().top);

        return this;
    },

    /**
     * Обработчик очистики и обновления списка ошибок в errors-presenter'е групп
     * @param {jQuery.Event} e
     * @param {Object} data
     * @param {{ path: String, description: String }[]} data.used отображаемые ошибки
     * @private
     */
    _onErrorsUpdate: function(e, data) {
        this._updateErrorsNavigation(u._.map(data.used, 'path'));
    },

    /**
     * На основе отображаемых ошибок формирует навигацию
     * @param {string[]} pathes
     * @private
     */
    _updateErrorsNavigation: function(pathes) {
        var navigation = [],
            groupsPathes = [],
            bannersPathes = [],
            groupNamePathes = [];

        pathes.forEach(function(path) {
            if (this._errorPathTest('group_name', path)) {
                // ищем ошибки относящиеся к названию группы
                groupNamePathes.push(path);

            } else if (this._errorPathTest('groups', path)) {
                // ищем ошибки относящиеся к группе
                groupsPathes.push(path);

            } else if (this._errorPathTest('banners', path)) {
                // ищем ошибки относящиеся к баннеру
                bannersPathes.push(path);
            }
        }, this);

        if (pathes.length) {
            navigation.push({
                path: 'mainErrorsTitle',
                description: iget2(
                    'p-multiedit2',
                    'pozhaluysta-zapolnite-pravilno-neobhodimye',
                    'Пожалуйста, заполните правильно необходимые поля'
                )
            });
        }

        if (groupsPathes.length) {
            navigation.push({
                path: 'groupsErrorsNavigation',
                description: this._getGroupsErrorsNavigation(groupsPathes)
            });
        }

        if (groupNamePathes.length) {
            navigation.push({
                path: 'groupNameErrors',
                description: this._getGroupNameErrors(groupNamePathes)
            });
        }

        if (bannersPathes.length) {
            navigation.push({
                path: 'bannersErrorsNavigation',
                description: this._getBannersErrorsNavigation(bannersPathes)
            });
        }

        this._getErrorsPresenter('navigation').showErrors(navigation);
    },

    /**
     * Возвращает инстанс блока `b-errors-presenter2` по миксу элемента с модификатором
     * @param {string} position
     * @return {BEM.DOM}
     * @private
     */
    _getErrorsPresenter: function(position) {
        if (!this._errorsPresenter) this._errorsPresenter = {};

        return this._errorsPresenter[position] ||
            (this._errorsPresenter[position] =
                this.findBlockInside(this.findElem('errors-presenter', 'position', position), 'b-errors-presenter2'));
    },

    /**
     * Возвращает RegExp для парсинга путей ошибок
     * @param {string} type
     * @return {RegExp}
     * @private
     */
    _getPathRegExps: function(type) {
        if (!this._pathRegExps) {
            this._pathRegExps = {
                groups: /^\[\d+]/,
                vcard: /^\[\d+]\.banners\[\d+]\.vcard/,
                turbolanding: /^\[\d+]\.banners\[\d+]\.turbolanding/,
                pixels: /^\[\d+]\.banners\[\d+]\.pixels/,
                banners: /^\[\d+]\.banners\[\d+]/,
                phrases: /^\[\d+]\.phrases\[\d+]/,
                keywords: /^\[\d+]\.keywords\[\d+]/,
                group_name: /^\[\d+]\.group_name/,
                price_context: /^\[\d+]\.retargetings\[\d+]\.price_context/
            }
        }

        return this._pathRegExps[type];
    },

    /**
     * Возвращает индекс группы по пути ошибки
     * @param {string} path
     * @return {string}
     * @private
     */
    _getGroupIndexByPath: function(path) {
        return path.match(/^\[(\d+)].*/)[1]
    },

    /**
     * Сообщает о принадлежности пути ошибки к переданному типу ошибки
     * @param {string} type
     * @param {string} path
     * @return {Boolean}
     * @private
     */
    _errorPathTest: function(type, path) {
        switch (type) {
            case 'group_name':
            case 'banners':
            case 'vcard':
            case 'pixels':
            case 'phrases':
            case 'keywords':
                return this._getPathRegExps(type).test(path);

            case 'groups':
                return !this._getPathRegExps('banners').test(path) && this._getPathRegExps(type).test(path);

            case 'price_context':
                return this._getPathRegExps(type).test(path);

            case 'turbolanding':
                return this._getPathRegExps(type).test(path);

            default:
                return false;
        }
    },

    /**
     * Строит навигацию по ошибкам в баннерах
     * @param {string[]} pates - ошибки в баннерах
     * @returns {string}
     * @private
     */
    _getBannersErrorsNavigation: function(pates) {
        var uniqModels = u._.uniq(
            u._.compact(
                pates.map(function(path) {
                    var indexes = this._getIndexesByPath(path);

                    return this._getBannerModelByIndex(indexes[0], indexes[1]);
                }, this)
            ),
            function(model) {
                return model.get('modelId');
            }
        );

        return iget2(
            'p-multiedit2',
            'error-navigation-oshibki-v-obyavleniyah',
            'Ошибки в объявлениях: {links}',
            {
                links: u.spacer2(uniqModels.map(function(bannerModel) {
                    var groupModel = bannerModel.getParentModel();

                    return {
                        block: 'link',
                        url: '#Banner-' + groupModel.get('modelId') + '-' + bannerModel.get('modelId'),
                        content: u.spacer2([
                            bannerModel.get('isNewBanner') ?
                                iget2(
                                    'p-multiedit2',
                                    'error-navigation-novoe-obyavlenie',
                                    'Новое объявление {index}',
                                    { index: bannerModel.get('newBannerIndex') }
                                ) :
                                '№ M-' + bannerModel.get('modelId'),
                            !groupModel.get('isSingleGroup') && iget2(
                                'p-multiedit2',
                                'error-navigation-gruppa',
                                '(группа&nbsp;{link})',
                                { link: this._buildGroupAnchor({ model: groupModel, onlyContent: true }) }
                            )
                        ])
                    };
                }, this), ', ')
            }
        );
    },

    /**
     * Формирует текст ошибки в названии групп
     * @param {string[]} pathes
     * @return {bemjson}
     * @private
     */
    _getGroupNameErrors: function(pathes) {
        var uniqModels = u._.uniq(
            u._.compact(pathes.map(this._getGroupModelByPath, this)),
            function(model) {
                return model.get('modelId');
            }
        );

        return iget2(
            'p-multiedit2',
            'error-navigation-oshibki-v-nastroykah-grup-name',
            '{error} в названии {group}: {groupLinks}',
            {
                error: u.pluralizeWord(
                    [
                        iget2('p-multiedit2', 'group-name-error-1', 'Ошибка'),
                        iget2('p-multiedit2', 'group-name-error-2', 'Ошибки'),
                        iget2('p-multiedit2', 'group-name-error-2', 'Ошибки')
                    ],
                    pathes.length
                ),
                group: u.pluralizeWord(
                    [
                        iget2('p-multiedit2', 'group-name-error-10', 'группы'),
                        iget2('p-multiedit2', 'group-name-error-11', 'групп'),
                        iget2('p-multiedit2', 'group-name-error-11', 'групп')
                    ],
                    pathes.length
                ),
                groupLinks: u.spacer2(
                    uniqModels.map(function(model) {
                        return this._buildGroupAnchor({
                            model: model,
                            url: '#Group-' + model.get('modelId')
                        });
                    }, this),
                    ', '
                )
            }
        );
    },

    /**
     * Строит навигацию по ошибкам в группах
     * @param {string[]} pathes - ошибки в группах
     * @returns {string}
     * @private
     */
    _getGroupsErrorsNavigation: function(pathes) {
        var uniqModels = u._.uniq(
            u._.compact(pathes.map(this._getGroupModelByPath, this)),
            function(model) {
                return model.get('modelId');
            }
        );

        return iget2(
            'p-multiedit2',
            'error-navigation-oshibki-v-nastroykah-grupp',
            'Ошибки в настройках групп: {groupLinks}',
            {
                groupLinks: u.spacer2(
                    uniqModels.map(function(model) {
                        return this._buildGroupAnchor({ model: model })
                    }, this),
                    ', '
                )
            }
        );
    },

    /**
     * Возвращает индексы и пути ошибки
     * @param {string} path
     * @return {number[]}
     * @private
     */
    _getIndexesByPath: function(path) {
        return (path.match(/(\d+)/g) || []).map(Number);
    },

    /**
     * Возвращает модель группы по индексу
     * @param {number} index
     * @return {BEM.MODEL}
     * @private
     */
    _getGroupModelByIndex: function(index) {
        return this._groupsModels[index];
    },

    /**
     * Возвращает модель группы по пути ошибки
     * @param {string} path
     * @return {BEM.MODEL}
     * @private
     */
    _getGroupModelByPath: function(path) {
        var indexes = this._getIndexesByPath(path);

        return this._getGroupModelByIndex(indexes[0]);
    },

    /**
     * Возвращает модель баннера по индексам группы и баннера
     * @param {number} groupIndex
     * @param {number} bannerIndex
     * @return {BEM.MODEL}
     * @private
     */
    _getBannerModelByIndex: function(groupIndex, bannerIndex) {
        var groupModel = this._getGroupModelByIndex(groupIndex);

        return groupModel ?
            groupModel.get('banners').getByIndex(bannerIndex) :
            undefined;
    },

    /**
     * Возвращает ссылку с якорем на группу или номер группы
     * @param {Object} data
     * @param {BEM.MODEL} data.model — модель группы
     * @param {String} [data.url]
     * @param {Boolean} [data.onlyContent]
     * @returns {Object|String}
     * @private
     */
    _buildGroupAnchor: function(data) {
        var model = data.model,
            res = model.get('isNewGroup') || model.get('isCopyGroup') ?
                iget2('p-multiedit2', 'error-navigation-novaya-gruppa', 'Новая группа {groupLink}',
                    {
                        groupLink: model.get('newGroupIndex')
                    }
                ) :
                '№ ' + model.get('modelId');

        return data.onlyContent ?
            res :
            {
                block: 'link',
                url: data.url || ('#Group-properties-' + model.get('modelId')),
                content: res
            };
    },

    /**
     * Инициализация медиа ресурсов баннеров всех групп
     * @private
     */
    _setBannerMediaResources: function() {
        this.findBlocksInside('b-edit-group-2').forEach(function(group) {
            group.setBannerMediaResources(this.params.bannerMediaResources);
        }, this);
    }

}, {

    live: function() {

        this
            .liveInitOnBlockInsideEvent('show', 'b-errors-presenter2', function(e, data) {
                if (e.block.domElem.is(this._getErrorsPresenter('groups').domElem)) {
                    this._onErrorsUpdate(e, data);
                }
            })
            .liveInitOnBlockInsideEvent('clear', 'b-errors-presenter2', function(e, data) {
                if (e.block.domElem.is(this._getErrorsPresenter('groups').domElem)) {
                    this._onErrorsUpdate(e, data);
                }
            });

        return false;
    }

});

/**
 * Страница мультиредактирования
 *
 * @param {Object} params
 * @param {String} [params.errorPath] префикс пути дерева ошибок
 */
BEM.DOM.decl({ block: 'p-multiedit2', baseBlock: 'p-multiedit2-java-ajax' }, {

    onSetMod: {
        js: function() {
            this._subscriptions = BEM.create('i-subscription-manager');
            this._initModels();
            this._initCallouts();
            this._initEvents();

            this._sendMetrikaEvents();

            this.findBlocksInside('i-glue');//todo вынести создание моделей из i-glue
        }
    },

    onElemSetMod: {
        'status-message': {
            progress: function(elem, modName, modVal) {
                this.findBlockInside(elem, 'spin').setMod(modName, modVal);
            }
        },
        'control-button': {
            disabled: function(elem, modName, modVal) {
                this.findBlockOn(elem, 'button').setMod(modName, modVal);
            }
        }
    },

    /**
     * Уничтожает блок
     * @fires destruct событие перед уничтожением
     * @override
     */
    destruct: function() {
        this._subscriptions.dispose();

        this.trigger('destruct');

        this.__base.apply(this, arguments);
    },

    /**
     * инициирует блок уточнений
     * @param {String} groupModelType - тип модели группы
     * @private
     */
    _initCallouts: function(groupModelType) {
        BEM.create('b-callouts-manager', {
            groupModelName: groupModelType,
            groupsIds: this.params.groupsIds
        });
    },

    /**
     * Инициирует модели, необходимые для блока
     * Переопределяется для каждого типа
     * @param {String} campModelType - тип модели кампании
     * @private
     */
    _initModels: function(campModelType) {
        this._campModel = BEM.MODEL.getOrCreate({
            name: campModelType,
            id: this.params.cid
        });
    },

    /**
     * Инициирует события блока
     * Переопределяется для каждого типа
     * @private
     */
    _initEvents: function() {
        u.graspSelf.call(this, {
            _back: '? button on back-button',
            _next: '? button on next-button',
            _submit: '? button on submit-button',
            _draft: '? button on to-draft'
        });

        this._back && this._subscriptions.on(this._back, 'click', this._onBackClick, this);

        this._submit && this._subscriptions.on(this._submit, 'click', function(e) {
            e.preventDefault();
            this._submitForm();
        }, this);

        this._draft && this._subscriptions.on(this._draft, 'click', function(e) {
            e.preventDefault();
            this._submitForm({ save_draft: 1 });
        }, this);

        this._subscriptions.wrap(this._campModel)
            .on('camp_banners_domain', 'change', function() {
                this.elem('camp-banners-domain').val(this._campModel.get('camp_banners_domain'));
            }, this);
    },

    /**
     * Строит по полученному списку аргументов путь ошибки
     * @param {String} [key...]
     * @returns {String}
     * @protected
     */
    _buildErrorPath: function(key) {
        var builder = this._errorPathBuilder ||
            (this._errorPathBuilder = u.error.createPathBuilder(this.params.errorPath));

        return builder.apply(null, arguments);
    },

    /**
     * Возвращает блок распределения ошибок
     * @returns {BEM.DOM}
     * @protected
     */
    _getErrorPresenter: function() {
        return this._errorPresenter || (this._errorPresenter = this.findBlockInside('b-error-presenter'));
    },

    /**
     * Выполняет ajax сохранение данных
     * @param {Object} groupData массив данных групп
     * @param {Object} [additionalData] доп. данные для отправки
     * @param {Number} [additionalData.save_draft] флаг "сохранить как черновик"
     * @private
     */
    _saveWithAjax: function(groupData, additionalData) {
        var params = u._.extend(
                this.params.formParams,
                { json_groups: JSON.stringify(groupData) },
                additionalData || {}
            ),
            request = BEM.create('i-request_type_ajax', {
                url: '/registered/main.pl',
                type: 'POST',
                cache: false,
                dataType: 'json'
            });

        this
            ._toggleButtonsPanel(true)
            .setMod(this.elem('status-message'), 'progress', 'yes');

        request.get(params, function(data) {
            this.delMod(this.elem('status-message'), 'progress');

            if (data.result && data.result.location) {
                this._metrikaReachGoal();
                window.location.href = data.result.location;

                return;
            }

            this._toggleButtonsPanel(false);

            this._showErrors(this._prepareErrorsData(data.errors));
        }.bind(this), function() {
            // Если сервер ответил ошибкой - раздизейбливаем кнопки
            this._toggleButtonsPanel(false);
        }.bind(this));
    },

    /**
     * Достижение цели
     * @private
     */
    _metrikaReachGoal: function() {},

    /**
     * Подготавливает данные об ошибках к показу в b-errors-group-summary
     * @param {Object} errorData данных об ошибках в "серверном" формате (см i-utils__error)
     * @returns {Object}
     */
    _prepareErrorsData: function(errorData) {
        var result = u.error.flatten(errorData),
            groupData = this._groupsModels.map(function(groupModel) {
                return BEM.blocks['i-error-groups-summary'].groupToSummaryData(groupModel.toJSON());
            });

        result['errors-summary'] = BEM.blocks['i-error-groups-summary'].summarizeErrors(groupData, errorData);

        return result;
    },

    /**
     * Показывает ошибки в форме
     * @param {FlatErrorsHash} errors
     * @protected
     */
    _showErrors: function(errors) {
        this._getErrorPresenter().showErrors(errors);
        BEM.DOM.win.scrollTop(this.elem('errors-summary').offset().top);
    },

    /**
     * Сбрасывает ошибки формы по указанному пути
     * Если остаются ошибки только для пути groups, то сбрасываются все ошибки
     * @param {String} [path]
     * @protected
     */
    _clearErrors: function(path) {
        var presenter = this._getErrorPresenter(),
            restErrorsPaths = presenter.clearErrors(path);

        // остались только общие ошибки на группу - очищаем всё
        u._.isEqual(restErrorsPaths, [this._buildErrorPath()]) && presenter.clearErrors();
    },

    /**
     * Формирует данные групп для отправки на сервер
     * @returns {Array}
     * @private
     */
    _getGroupsData: function() {
        return this._groupsModels.map(function(groupModel, index) {
            return this._getGroupData(groupModel, index);
        }, this);
    },

    /**
     * Формирует данные группы
     * @param {BEM.MODEL} groupModel - модель группы
     * @returns {Object}
     * @private
     */
    _getGroupData: function(groupModel) {
        var data = groupModel.provideData();

        data.auto_price = groupModel.getAutoPriceData();
        data.retargetings = groupModel.getRetargetingsData();
        data.phrases = groupModel.getPhrasesData();
        data.hierarchical_multipliers = groupModel.getMultipliersData();
        data.relevance_match = groupModel.get('has_relevance_match') ? groupModel.getRelevanceMatchData() : [];
        data.errors = undefined;

        return data;
    },

    /**
     * Отправляет форму
     * @private
     */
    _submitForm: function(options) {
        if (options && options.ajax) {
            this._saveWithAjax(this._getGroupsData(), options.additionalData);
        } else {
            this._toggleButtonsPanel(true);
            this.elem('form').submit();
        }
    },

    /**
     * Выставляет модификатор disabled кнопкам «Сохранить», «Дальше»...
     * @param {Boolean} disabled
     * @private
     */
    _toggleButtonsPanel: function(disabled) {
        // DIRECT-70220: 11964: Отсутствует блокировка кнопки сохранить группу после отправки запроса.
        ['_back', '_next', '_submit', '_draft'].forEach(function(button) {
            this[button] && this[button].toggleMod('disabled', 'yes', disabled);
        }, this);

        return this;
    },

    /**
     * Валидация модели группы
     * Переопределяется для каждого типа
     * @private
     */
    _validateGroups: function() {},

    /**
     * Проверяет, что баннер - не первый в группе
     * @returns {Boolean}
     * @private
     */
    _inNotFirstBanner: function() {
        var bannersCount = this._campModel.get('banners_count');
        //в группе уже больше одного баннера
        return (bannersCount > 1 ||
            //или в группе один баннер и идет создание следующего
            bannersCount == 1 && this._groupsModels[0].get('isNewGroup'));
    },

    /**
     * DIRECT-30856 костыль для проверки ЕКИ, как только vcard будет отдельной моделью — выпилить
     * используется в type_dynamic и type_text
     * Проверяет, изменилась ли визитка относительно установленной на кампанию региона
     * @returns {jQuery.Promise}
     */
    _compareAddress: function() {
        var deferred = $.Deferred();

        if (this._campModel.get('common_vcard_set') && this._inNotFirstBanner()) {
            var changed = this._isVCardChanged();

            changed ?
                this._showConfirm({
                    confirmMessage: [
                        iget2('p-multiedit2', 'vy-izmenili-kontaktnuyu-informaciyu', 'Вы изменили контактную информацию!'),
                        '<br/>',
                        '<br/>',
                        iget2(
                            'p-multiedit2',
                            'pri-sohranenii-ustanovlennaya-edinaya',
                            'При сохранении установленная ЕДИНАЯ контактная информация будет ОТМЕНЕНА!'
                        ),
                        '<br/>',
                        '<br/>',
                        iget2('p-multiedit2', 'prodolzhit', 'Продолжить?')
                    ],
                    onYes: deferred.resolve,
                    onNo: deferred.reject
                }) :
                deferred.resolve();
        } else {
            deferred.resolve();
        }

        return deferred.promise();
    },

    /**
     * Проверяет, изменилась ли визитка
     * @returns {boolean}
     * @override
     * @private
     */
    _isVCardChanged: function() {
        var commonVCard = this._campModel.get('vcard'),
            changed = false;

        this._groupsModels
            .reduce(function(acc, group) {
                return acc.concat(group.getBanners());
            }, [])
            .forEach(function(bannerModel) {
                // для графических баннеров и cpc_video визитки нет
                if (this._campModel.get('mediaType') == 'text' &&
                    u._.includes(['image_ad', 'cpc_video'], bannerModel.get('ad_type'))) {

                    return;
                }

                if (!bannerModel.get('has_vcard')) {
                    changed = true;
                } else {
                    var bannerVCard = bannerModel.get('vcard');

                    bannerVCard.name == 'dm-vcard' && (bannerVCard = bannerVCard.toJSON());

                    if (!this._areVCardsEqual(commonVCard, bannerVCard)) {
                        changed = true;
                    }
                }
            }, this);

        return changed;
    },

    /**
     * Проверяет совпадения двух визиток
     * @param {Object} a  - визитка 1
     * @param {Object} b - визитка 2
     * @returns {Boolean}
     * @private
     */
    _areVCardsEqual: function(a, b) {
        var result = true,
            fields = [
                'country', 'city', 'country_code', 'city_code', 'phone', 'ext', 'name', 'im_login', 'contact_email',
                'extra_message', 'house', 'street', 'build', 'apart', 'im_client',
                'contactperson', 'org_details_id'
            ];

        fields.forEach(function(name) {
            var aValue = a[name] || '',
                bValue = b[name] || '';

            if (aValue != bValue) {
                result = false;
            }
        });

        if (!(BEM.blocks['b-form-worktime'].compareWorktime(a.worktime, b.worktime))) {
            result = false;
        }

        // поля ogrn, metro и manual_point проверяем отдельно
        if ((a.org_details && a.org_details.ogrn && a.org_details.ogrn != b.ogrn) ||
            (b.manual_point && b.manual_point != a.manual_point) ||
            (+(a.metro || 0) != +(b.metro || 0))) {

            result = false;
        }

        return result;
    },

    /**
     * Клик по кнопке "назад"
     * @private
     */
    _onBackClick: function() {
        this.findBlockOn('btn-back', 'b-hidden').val(1);
        this.findBlockOn('json-groups', 'b-hidden').val(JSON.stringify(this._getGroupsData()));
        this.elem('form').submit();
    },

    /**
     * Показывает окно подтверждения действия (confirm)
     *
     * @param {Object} options
     * @param {String|Array} options.confirmMessage текст сообщения
     * @param {Function} options.onYes callback продолжения действия
     * @param {Function} [options.onNo] callback отказа от действия
     * @private
     */
    _showConfirm: function(options) {
        BEM.blocks['b-confirm'].open({
            message: {
                block: 'p-multiedit2',
                elem: 'alert-message',
                content: options.confirmMessage
            },
            onYes: options.onYes,
            onNo: options.onNo
        },
        options);
    },

    /**
     * Вызвать события метрики после создания первой кампании
     * @private
     */
    _sendMetrikaEvents: function() {
        if (this.params.isFirstCampaign) {
            BEM.blocks['b-metrika2']
                .setUserID({
                    userID: this._campModel.get('ClientID'),
                    id: 191494
                })
                .params({
                    params: {
                        'new-client': {
                            login: u.consts('ulogin') || u.consts('raw_login')
                        }
                    },
                    id: 191494
                });
        }
    },

    /**
     * Показывает предупреждение в случае наличия ссылок с доменами, не совпадающими с доменами действующих промокодов
     * @returns {Promise}
     */
    _confirmDomainChange: function() {
        return new Promise(function(resolve) {
            if (!this._campaignHasBannersWithNonPromoCodeDomains()) {
                resolve();
            } else {
                BEM.blocks['b-user-dialog'].confirm({
                    message: iget2('p-multiedit2', 'confirm-domain-change', 'Домен одного из объявлений отличается от домена, на который активирован промокод. При смене или добавлении домена промокод будет аннулирован. Вы уверены, что хотите рекламировать другой домен?'),
                    onConfirm: function() {
                        resolve();
                    }
                });
            }
        }.bind(this));
    },

    /**
     * Определяет наличие ссылок с доменами, не совпадающими с доменами действующих промокодов
     * @returns {Promise}
     */
    _campaignHasBannersWithNonPromoCodeDomains: function() {
        var promoCodeDomains = this.params.promoCodeDomains, groupsWithNonPromoCodeDomains;

        if (promoCodeDomains === undefined || promoCodeDomains.length === 0) {
            return false;
        }

        promoCodeDomains = promoCodeDomains.map(function(domain) {
            return domain.toLowerCase();
        });

        groupsWithNonPromoCodeDomains = this._groupsModels.find(function(groupModel) {
            if (groupModel.get('data_source') === 'feed' && groupModel.get('adgroup_type') === 'dynamic') {
                return;
            }

            return groupModel.getBanners().find(function(banner) {
                var domain = u.extractDomain(banner.get('href_model').get('href').toLowerCase());

                return !u._.includes(promoCodeDomains, domain);
            });
        }, this);

        return groupsWithNonPromoCodeDomains !== undefined;
    }
});
