match(function() {
    return this.data.cmd === 'showRegisterLoginPage';
})(

    block('app-main').mode('page-block')('p-new-agency-client'),

    block('b-page')(
        mode('title')(function() {
            return iget2('p-new-agency-client', 'yandeks-direkt-registraciya-novogo', 'Яндекс.Директ – регистрация нового клиента');
        }),

        elem('foot-js').content()(function() {
            var result = applyNext(),
                langList = {
                    ru: 'ru-RU',
                    en: 'en-US',
                    tr: 'tr-TR',
                    ua: 'uk-UA'
                };

            result.push({
                elem: 'js',
                url: u.formatUrl({
                    host: '//api-maps.yandex.ru',
                    path: '2.1',
                    query: {
                        lang: langList[this.data.lang] || langList.ru,
                        coordorder: 'longlat'
                    }
                })
            });

            return result;
        })
    )
);

block('p-new-agency-client').content()(function() {
    return {
        block: 'l-page',
        mods: {
            layout: '12-60-16'
        },
        content: {
            block: 'l-page',
            elem: 'row',
            left: true,
            right: true,
            lgap: true,
            rgap: true,
            center: [
                {
                    block: 'b-page-title',
                    content: {
                        elem: 'title',
                        content: iget2('p-new-agency-client', 'registraciya', 'Регистрация')
                    }
                },
                {
                    block: 'b-new-agency-client',
                    js: {
                        modelName: 'm-agency-client-form',
                        modelData: {
                            trackId: this.data.track_id,
                            login: this.data.FORM.login
                        }
                    }
                }
            ]
        }
    };
});
