match(function() {
    return this.data.cmd === 'addAgRep';
})(

    block('app-main').mode('page-block')('p-new-agency-representative'),

    block('b-page').mode('title')(function() {
        return iget2('p-new-agency-representative', 'naznachenie-predstaviteley-agentstva', 'Назначение представителей агентства');
    })
);

block('p-new-agency-representative')(

    addJs()(function() {
        return {
            newLimRepSchema: this.data.features_enabled_for_client.new_lim_rep_schema == 1
        };
    }),

    content()(function() {
        var data = this.data,
            form = data.FORM,
            newLimRepSchema = data.features_enabled_for_client.new_lim_rep_schema == 1;

        return {
            elem: 'form',
            action: data.SCRIPT,
            content: [
                {
                    elem: 'hidden',
                    name: 'cmd',
                    value: 'addAgRep'
                },
                {
                    elem: 'hidden',
                    name: 'ulogin',
                    value: data.user_login
                },
                {
                    elem: 'hidden',
                    name: 'save',
                    value: 'save'
                },
                {
                    block: 'l-page',
                    mods: {
                        layout: '16-60-16'
                    },
                    content: [
                        {
                            elem: 'row',
                            left: true,
                            center: {
                                block: 'b-page-title',
                                mix: [{
                                    block: 'p-new-agency-representative',
                                    elem: 'title'
                                }],
                                title: iget2('p-new-agency-representative', 'naznachenie-predstaviteley-agentstva', 'Назначение представителей агентства')
                            },
                            right: true,
                            rgap: true
                        },
                        {
                            elem: 'row',
                            left: {
                                block: 'p-new-agency-representative',
                                elem: 'section-num',
                                content: '1.&nbsp'
                            },
                            center: {
                                block: 'p-new-agency-representative',
                                elem: 'section',
                                content: [
                                    {
                                        elem: 'section-head',
                                        content: iget2('p-new-agency-representative', 'login-predstavitelya', 'Логин представителя')
                                    },
                                    {
                                        block: 'input',
                                        mix: [
                                            {
                                                block: 'p-new-agency-representative',
                                                elem: 'input'
                                            },
                                            {
                                                block: 'p-new-agency-representative',
                                                elem: 'login'
                                            }
                                        ],
                                        name: 'ag_login',
                                        value: form.login || form.ag_login,
                                        content: {
                                            elem: 'control'
                                        }
                                    },
                                    {
                                        block: 'p-new-agency-representative',
                                        elem: 'new-login',
                                        content: {
                                            block: 'link',
                                            mods: {
                                                pseudo: 'yes'
                                            },
                                            mix: [{
                                                block: 'p-new-agency-representative',
                                                elem: 'passport-link'
                                            }],
                                            content: iget2('p-new-agency-representative', 'zaregistrirovat-login-dlya-novogo', 'зарегистрировать логин для нового представителя')
                                        }
                                    },
                                    {
                                        elem: 'description',
                                        content: iget2(
                                            'p-new-agency-representative',
                                            'ukazhite-login-zaregistrirovannyy-na',
                                            'Укажите логин, зарегистрированный на Яндексе, но никогда не использовавшийся в Яндекс.Директе. Пользователь, вошедший под этим логином, будет иметь полномочия представителя.'
                                        )
                                    },
                                    {
                                        elem: 'description',
                                        content: iget2(
                                            'p-new-agency-representative',
                                            'dobavlyaya-predstavitelya-vy-razreshaete',
                                            'Добавляя представителя, вы разрешаете этому пользователю управлять всеми рекламными кампаниями, которые размещаются во всех коммерческих сервисах Яндекса под вашим логином.'
                                        )
                                    },
                                    [iget2(
                                        'p-new-agency-representative',
                                        'vnimanie-v-celyah-bezopasnosti',
                                        'Внимание! В целях безопасности используйте для назначения представителей только логины, зарегистрированные вами лично.'
                                    )]
                                        .concat(data.error && data.error.split('\n'))
                                        .map(function(msg) {
                                            return msg && {
                                                elem: 'warning',
                                                content: msg
                                            };
                                        })
                                ]
                            },
                            right: true,
                            rgap: true
                        },
                        {
                            elem: 'row',
                            left: {
                                block: 'p-new-agency-representative',
                                elem: 'section-num',
                                content: '2.&nbsp'
                            },
                            center: {
                                block: 'p-new-agency-representative',
                                elem: 'section',
                                content: [
                                    {
                                        elem: 'section-head',
                                        content: iget2('p-new-agency-representative', 'personalnye-dannye', 'Персональные данные')
                                    },
                                    {
                                        block: 'b-layout-table',
                                        content: [
                                            {
                                                name: 'name',
                                                title: iget2('p-new-agency-representative', 'imya', 'Имя')
                                            },
                                            {
                                                name: 'email',
                                                title: iget2('p-new-agency-representative', 'e-mail', 'E-mail')
                                            },
                                            {
                                                name: 'phone',
                                                title: iget2('p-new-agency-representative', 'telefon', 'Телефон')
                                            }
                                        ].map(function(field) {
                                            var name = 'ag_' + field.name;

                                            return {
                                                elem: 'row',
                                                content: [
                                                    {
                                                        elem: 'cell',
                                                        mix: [{
                                                            block: 'p-new-agency-representative',
                                                            elem: 'label'
                                                        }],
                                                        content: field.title + ':'
                                                    },
                                                    {
                                                        elem: 'cell',
                                                        mix: [{
                                                            block: 'p-new-agency-representative',
                                                            elem: 'control'
                                                        }],
                                                        content: {
                                                            block: 'input',
                                                            mix: [
                                                                {
                                                                    block: 'p-new-agency-representative',
                                                                    elem: 'input'
                                                                },
                                                                {
                                                                    block: 'p-new-agency-representative',
                                                                    elem: field.name
                                                                }
                                                            ],
                                                            name: name,
                                                            value: form[name],
                                                            content: {
                                                                elem: 'control'
                                                            }
                                                        }
                                                    }
                                                ]
                                            };
                                        })
                                    },
                                    {
                                        elem: 'control',
                                        content: {
                                            block: 'checkbox',
                                            mods: {
                                                checked: form.show_agency_contacts ? 'yes' : ''
                                            },
                                            checkboxAttrs: {
                                                name: 'show_agency_contacts',
                                                value: '1'
                                            },
                                            text: iget2('p-new-agency-representative', 'otobrazhat-kontakty-v-klientskom', 'Отображать контакты в клиентском интерфейсе')
                                        }
                                    }
                                ]
                            },
                            right: true,
                            rgap: true
                        },
                        {
                            elem: 'row',
                            left: {
                                block: 'p-new-agency-representative',
                                elem: 'section-num',
                                content: '3.&nbsp'
                            },
                            center: {
                                block: 'p-new-agency-representative',
                                elem: 'section',
                                content: [
                                    {
                                        elem: 'section-head',
                                        content: iget2('p-new-agency-representative', 'prava-dostupa', 'Права доступа')
                                    },
                                    {
                                        block: 'b-layout-table',
                                        content: {
                                            elem: 'row',
                                            content: [
                                                {
                                                    elem: 'cell',
                                                    mix: [{
                                                        block: 'p-new-agency-representative',
                                                        elem: 'radiobox-label'
                                                    }],
                                                    content: iget2('p-new-agency-representative', 'rol', 'Роль') + ':'
                                                },
                                                {
                                                    elem: 'cell',
                                                    mix: [{
                                                        block: 'p-new-agency-representative',
                                                        elem: 'control'
                                                    }],
                                                    content: [
                                                        !newLimRepSchema && {
                                                            block: 'radiobox',
                                                            mix: [{
                                                                block: 'p-new-agency-representative',
                                                                elem: 'role-radiobox'
                                                            }],
                                                            name: 'ag_role',
                                                            value: form.ag_role || 'limited',
                                                            content: [
                                                                {
                                                                    elem: 'radio',
                                                                    mix: [{
                                                                        block: 'p-new-agency-representative',
                                                                        elem: 'radio'
                                                                    }],
                                                                    controlAttrs: {
                                                                        value: 'limited'
                                                                    },
                                                                    content: iget2('p-new-agency-representative', 'predstavitel-po-rabote-s', 'Представитель по работе с клиентами')
                                                                },
                                                                {
                                                                    elem: 'radio',
                                                                    mix: [{
                                                                        block: 'p-new-agency-representative',
                                                                        elem: 'radio'
                                                                    }],
                                                                    controlAttrs: {
                                                                        value: 'main'
                                                                    },
                                                                    content: iget2('p-new-agency-representative', 'predstavitel-administrator', 'Представитель (администратор)')
                                                                }
                                                            ]
                                                        },
                                                        newLimRepSchema && [
                                                            {
                                                                block: 'radiobox',
                                                                mix: [{
                                                                    block: 'p-new-agency-representative',
                                                                    elem: 'role-radiobox'
                                                                }],
                                                                name: 'ag_role',
                                                                value: form.ag_role || 'limited_main',
                                                                content: [
                                                                    {
                                                                        elem: 'radio',
                                                                        mix: [{
                                                                            block: 'p-new-agency-representative',
                                                                            elem: 'radio'
                                                                        }],
                                                                        controlAttrs: {
                                                                            value: 'limited_main'
                                                                        },
                                                                        content: [
                                                                            iget2('p-new-agency-representative', 'predstavitel-po-rabote-s-manager', 'Представитель по работе с клиентами (менеджер)')
                                                                        ]
                                                                    },
                                                                    {
                                                                        elem: 'radio',
                                                                        mix: [{
                                                                            block: 'p-new-agency-representative',
                                                                            elem: 'radio'
                                                                        }],
                                                                        controlAttrs: {
                                                                            value: 'limited_chief'
                                                                        },
                                                                        content: iget2('p-new-agency-representative', 'predstavitel-po-rabote-s-teamlead', 'Представитель по работе с клиентами (тимлид)')
                                                                    },
                                                                    {
                                                                        elem: 'radio',
                                                                        mix: [{
                                                                            block: 'p-new-agency-representative',
                                                                            elem: 'radio'
                                                                        }],
                                                                        controlAttrs: {
                                                                            value: 'main'
                                                                        },
                                                                        content: iget2('p-new-agency-representative', 'predstavitel-administrator', 'Представитель (администратор)')
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    ]
                                                },
                                                newLimRepSchema && {
                                                    elem: 'cell',
                                                    content: {
                                                        block: 'select',
                                                        mods: {
                                                            size: 's',
                                                            theme: 'normal'
                                                        },
                                                        mix: [{ block: 'p-new-agency-representative', elem: 'manager-select' }],
                                                        name: 'chief_lim_rep_uid',
                                                        content: [
                                                            {
                                                                block: 'button',
                                                                mix: {
                                                                    block: 'select',
                                                                    elem: 'button'
                                                                },
                                                                content: (data.lim_rep_chiefs[0] || {}).login
                                                            },
                                                            {
                                                                elem: 'control',
                                                                content: data.lim_rep_chiefs.map(function(item, idx) {
                                                                    var result = {
                                                                        elem: 'option',
                                                                        attrs: {
                                                                            value: item.uid
                                                                        },
                                                                        content: item.login
                                                                    };

                                                                    if (idx === 0) {
                                                                        result.attrs.selected = 'yes';
                                                                    }

                                                                    return result;
                                                                }, this)
                                                            }
                                                        ]
                                                    }
                                                },
                                            ]
                                        }
                                    },
                                    hasLoginRights('super_control', 'is_developer', 'manager_control',
                                        'is_agency_chief', 'limited_support_control') && {
                                            elem: 'advanced-controls',
                                            content: [
                                                {
                                                    elem: 'control',
                                                    content: {
                                                        block: 'checkbox',
                                                        mix: [{
                                                            block: 'p-new-agency-representative',
                                                            elem: 'permission'
                                                        }],
                                                        mods: {
                                                            checked: form.ag_role === 'main' || data.ag_allow_pay ||
                                                                form.ag_allow_pay ?
                                                                    'yes' :
                                                                    '',
                                                            disabled: form.ag_role === 'main' ? 'yes' : ''
                                                        },
                                                        checkboxAttrs: {
                                                            name: 'ag_allow_pay',
                                                            value: '1'
                                                        },
                                                        text: iget2('p-new-agency-representative', 'razreshit-vystavlenie-schetov', 'Разрешить выставление счетов')
                                                    }
                                                },
                                                {
                                                    elem: 'control',
                                                    content: {
                                                        block: 'checkbox',
                                                        mix: [{
                                                            block: 'p-new-agency-representative',
                                                            elem: 'permission'
                                                        }],
                                                        mods: {
                                                            checked: form.ag_role === 'main' ||
                                                                data.ag_allow_money_transfer ||
                                                                    form.ag_allow_money_transfer ?
                                                                        'yes' :
                                                                        '',
                                                            disabled: form.ag_role === 'main' ? 'yes' : ''
                                                        },
                                                        checkboxAttrs: {
                                                            name: 'ag_allow_money_transfer',
                                                            value: '1'
                                                        },
                                                        text: iget2('p-new-agency-representative', 'razreshit-perenos-sredstv', 'Разрешить перенос средств')
                                                    }
                                                }
                                            ]
                                        }
                                ]
                            },
                            right: true,
                            rgap: true
                        },
                        {
                            elem: 'row',
                            left: true,
                            center: {
                                block: 'p-new-agency-representative',
                                elem: 'submit-panel',
                                content: {
                                    block: 'button',
                                    type: 'submit',
                                    mix: [{
                                        block: 'p-new-agency-representative',
                                        elem: 'submit'
                                    }],
                                    content: iget2('p-new-agency-representative', 'zaregistrirovat', 'Зарегистрировать')
                                }
                            },
                            right: true,
                            rgap: true
                        }
                    ]
                }
            ]
        };
    })
);
