BEM.DOM.decl('p-new-agency-representative', {

    onSetMod: {

        js: function() {
            BEM.blocks['i-utils'].graspSelf.call(this, {
                login: 'input on login',
                name: 'input on name',
                email: 'input on email',
                phone: 'input on phone',
                role: 'radiobox on role-radiobox'
            });

            var permissionCheckboxes = this.findBlocksInside('advanced-controls', 'checkbox'),
                newLimRepSchema = this.params.newLimRepSchema;

            this.bindTo(this.elem('form'), 'submit', function(e) { this.validate() || e.preventDefault(); });

            (this.passportLink = this.findBlockOn('passport-link', 'link')) &&
                this.passportLink.on('click', function() {
                    this.__self.doc.get(0).location = u.getUrl('showRegisterLoginPage', {
                        login: this.login.val(),
                        retpath: u.getCurrentUrl()
                    });
                }, this);

            permissionCheckboxes.length && this.role.on('change', function() {
                permissionCheckboxes.map(function(checkbox) {
                    var val = this.val(),
                        needDisable = newLimRepSchema ? val === 'limited_main' || val === 'limited_chief' : val === 'limited';

                    if (needDisable) {
                        checkbox.delMod('disabled');
                    } else {
                        checkbox
                            .setMod('checked', 'yes')
                            .setMod('disabled', 'yes');
                    }
                }, this);
            });
        }
    },

    /**
     * Валидация формы
     * @returns {boolean}
     */
    validate: function() {
        var hasEmptyField = ![
                { name: 'login', error: iget2('p-new-agency-representative', 'vvedite-login', 'Введите логин') },
                { name: 'name', error: iget2('p-new-agency-representative', 'vvedite-imya-predstavitelya', 'Введите имя представителя') },
                { name: 'phone', error: iget2('p-new-agency-representative', 'vvedite-telefon', 'Введите телефон') }
            ].every(function(field) {
                var isEmpty = !this[field.name].val();

                isEmpty && this.showError(field.error);

                return !isEmpty;
            }, this),
            emailValid = u.emailRegExp().test(this.email.val());

        !hasEmptyField && !emailValid && this.showError(iget2('p-new-agency-representative', 'vvedite-korrektnyy-e-mail', 'Введите корректный e-mail'));

        return !hasEmptyField && emailValid;
    },

    /**
     * Отображает ошибку валидации формы
     * @param {String} error
     */
    showError: function(error) {
        BEM.blocks['b-confirm'].alert(error);
    }

});
