block('p-new-banner-step-zero').elem('form')(

    def()(function() {
        return applyNext({
            agencyClient: this.elemMods['agency-client'] === 'yes'
        });
    }),

    js()(function() {
        return {
            mediaType: this.ctx.mediaType
        };
    }),

    content()(function() {
        var steps = [iget2('p-new-banner-step-zero', 'vybor-klientov', 'Выбор клиентов'), iget2('p-new-banner-step-zero', 'sozdanie-kampanii', 'Создание кампании')],
            hiddenInputs = [{
                name: 'cmd',
                value: 'stepZeroProcess'
            }];

        this.ctx.isDynamic ?
            steps.push(iget2('p-new-banner-step-zero', 'sozdanie-gruppy-obyavleniy', 'Создание группы объявлений')) :
            steps.push(
                iget2('p-new-banner-step-zero', 'sozdanie-gruppy-obyavleniy', 'Создание группы объявлений'),
                iget2('p-new-banner-step-zero', 'vybor-ceny-za-klik', 'Выбор цены за клик')
            );

        (this.agencyClient || this.ctx.forAgency) ?
            hiddenInputs.push({
                name: 'type',
                value: 'subclient'
            }) :
            hiddenInputs.push({
                name: 'type',
                value: 'client'
            });

        !this.agencyClient && this.ctx.forAgency &&
            hiddenInputs.push({
                name: 'for_agency',
                value: this.ctx.forAgency
            });

        this.ctx.mediaType && hiddenInputs.push({
            name: 'mediaType',
            value: this.ctx.mediaType
        });

        return {
            block: 'b-layout-form',

            mixes: {
                label: [
                    // для случая, когда только 1 label с логином центруем label, так как пусто между ним и инпутом
                    this.ctx.clients ?
                        {
                            block: 'p-new-banner-step-zero',
                            elem: 'form-label'
                        } :
                        {
                            block: 'p-new-banner-step-zero',
                            elem: 'form-label-center'
                        }
                ],
                row: [{
                    block: 'p-new-banner-step-zero',
                    elem: 'form-row'
                }],
                submit: [{
                    block: 'p-new-banner-step-zero',
                    elem: 'form-submit'
                }]
            },

            method: 'GET',

            submit: [
                {
                    elem: 'cell',
                    elemMods: {
                        type: 'label'
                    },
                    mix: [{
                        block: 'p-new-banner-step-zero',
                        elem: 'form-label'
                    }]
                },
                {
                    elem: 'cell',
                    elemMods: {
                        type: 'control'
                    },
                    mix: [{
                        block: 'p-new-banner-step-zero',
                        elem: 'form-control'
                    }],
                    content: {
                        block: 'button',
                        type: 'submit',
                        content: iget2('p-new-banner-step-zero', 'dalshe', 'Дальше')
                    }
                }
            ],

            action: this.ctx.action,

            hiddenInputs: hiddenInputs,

            rows: [
                {
                    label: {
                        elem: 'label',
                        content: iget2('p-new-banner-step-zero', 'login', 'Логин'),
                        controlId: 'newlogin'
                    },
                    control: [
                        {
                            block: 'input',
                            mix: [{
                                block: 'p-new-banner-step-zero',
                                elem: 'login-input'
                            }],
                            id: 'newlogin',
                            name: 'newlogin',
                            value: this.ctx.login,
                            content: {
                                elem: 'control'
                            }
                        },
                        {
                            block: 'p-new-banner-step-zero',
                            elem: 'client-action',
                            content: [
                                this.agencyClient ?
                                    iget2('p-new-banner-step-zero', 'klient-agentstva', 'клиент агентства') :
                                    this.ctx.forAgency ?
                                        iget2('p-new-banner-step-zero', 'subklient', 'субклиент') :
                                        iget2('p-new-banner-step-zero', 'pryamoy-klient', 'прямой клиент'),
                                ',',
                                this.agencyClient ?
                                    {
                                        block: 'link',
                                        mix: [{
                                            block: 'p-new-banner-step-zero',
                                            elem: 'passport-link'
                                        }],
                                        url: u.getUrl('showRegisterLoginPage', {
                                            mediaType: this.ctx.mediaType || 'text'
                                        }),
                                        content: iget2('p-new-banner-step-zero', 'zaregistrirovat-login-dlya-novogo-110', 'зарегистрировать логин для нового клиента')
                                    } :
                                    {
                                        block: 'b-modal-popup-opener',
                                        mix: [{
                                            block: 'p-new-banner-step-zero',
                                            elem: 'create-login'
                                        }],
                                        url: u.getUrl('createLogin', {
                                            from: 'p-new-banner-step-zero'
                                        }),
                                        width: 650,
                                        height: 500,
                                        useNativeWindow: this.ctx.isMobile,
                                        text: this.ctx.forAgency ?
                                            iget2('p-new-banner-step-zero', 'zaregistrirovat-login-dlya-novogo-111', 'зарегистрировать логин для нового субклиента') :
                                            iget2('p-new-banner-step-zero', 'zaregistrirovat-login-dlya-novogo-110', 'зарегистрировать логин для нового клиента')
                                    }
                            ]
                        }
                    ]
                },
                this.ctx.clients && {
                    label: iget2('p-new-banner-step-zero', 'vybrat-klienta', 'Выбрать клиента'),
                    control: {
                        block: 'select',
                        mods: {
                            'cut-button': 40
                        },
                        mix: [{
                            block: 'p-new-banner-step-zero',
                            elem: 'login-select'
                        }],
                        name: 'login',
                        content: [
                            {
                                block: 'button'
                            },
                            {
                                elem: 'control',
                                content: [
                                    {
                                        elem: 'option',
                                        attrs: {
                                            value: '',
                                            selected: 'selected'
                                        },
                                        content: iget2('p-new-banner-step-zero', 'ne-vybran', 'Не выбран')
                                    }
                                ].concat(this.ctx.clients
                                    .sort(function(client1, client2) {
                                        return (client1.login || '').toLowerCase()
                                            .localeCompare((client2.login || '').toLowerCase());
                                    })
                                    .map(function(client) {
                                        return {
                                            elem: 'option',
                                            attrs: {
                                                value: client.login
                                            },
                                            content: [
                                                client.login,
                                                u.hellipCut(u.escapeHTML(client.FIO), 50)
                                            ].join(' &ndash; ')
                                        };
                                    }))
                            }
                        ]
                    }
                }
            ]
        };
    })
);
