BEM.DOM.decl({ block: 'p-new-banner-step-zero', elem: 'form' }, {

    onSetMod: {
        js: function() {
            if (this.hasMod('agency-client', 'yes')) {
                u.graspSelf.call(this, {
                    link: '? link on passport-link',
                    input: 'input on login-input'
                });

                // при изменении логина обновлять ссылку на регистрацию

                this.input.on('change', this._updateLink, this);

                this._updateLink();
            }

            if (this.hasMod('select-client', 'yes')) {
                u.graspSelf.call(this, {
                    select: 'select on login-select',
                    input: 'input on login-input'
                });

                this.input.on('change', function(e) { this._updateValues(e.block.val()) }, this);
                this.select.on('change', function(e) { this._updateValues(e.block.val()) }, this);

                this._updateValues(this.input.val());
            }
        }
    },

    /**
     * Обновляет ссылку, добавляя значение введенного логина
     * @private
     */
    _updateLink: function() {
        var login = this.input.val(),
            params = {};

        this.params.mediaType && (params.mediaType = this.params.mediaType);
        login && (params.login = login);

        this.link.setUrl(u.getUrl('showRegisterLoginPage', params));
    },

    /**
     * Обновляет значения поля ввода и селектора
     * @param {String} login
     * @private
     */
    _updateValues: function(login) {
        if (this._login === login) return;

        this._login = login;

        this.select.val(login);

        // если введенного логина нет в предлагаемом для выбора списке клиентов,
        // то необходимо сбросить селект, чтобы не путать пользователя
        login !== this.select.val() &&
            this.select.val('');

        this.input.val(login);
    }

}, {

    live: function() {
        this
            .liveInitOnBlockInsideEvent('init', 'input')
            .liveInitOnBlockInsideEvent('init', 'select');
    }

});
