match(function() {
    return this.data.cmd === 'stepZero';
})(

    block('app-main').mode('page-block')('p-new-banner-step-zero'),

    block('b-page').mode('title')(function() {
        return iget2('p-new-banner-step-zero', 'sozdanie-gruppy-obyavleniy-vybor', 'Создание группы объявлений: выбор клиентов');
    })
);

block('p-new-banner-step-zero')(

    content()(function() {
        var data = this.data,
            form = data.FORM,
            isDynamic = form.mediaType === 'dynamic',
            error = data.error,
            errorCode = form.error_code,
            clients,
            agencyClient,
            hasClientsList;

        !hasLoginRights('manager_control', 'super_control') &&
            (agencyClient = true);

        // что есть клиенты, даже если есть права, поэтому...
        hasLoginRights('manager_control', 'agency_control') && data.clients && data.clients.length &&
            (hasClientsList = true);

        // ... извлекаем список при полной уверенности, что список есть и есть права
        hasClientsList && (clients = data.clients);

        return {
            block: 'l-page',
            mods: {
                layout: '60'
            },
            content: [
                {
                    elem: 'row',
                    center: [
                        {
                            block: 'b-page-title',
                            mix: [{
                                block: 'p-new-banner-step-zero',
                                elem: 'page-title'
                            }],
                            content: [
                                iget2('p-new-banner-step-zero', 'shag-0-iz', 'Шаг 0 из') + ' ' + 2,
                                {
                                    elem: 'title',
                                    mix: [{
                                        block: 'p-new-banner-step-zero',
                                        elem: 'title'
                                    }],
                                    content: iget2('p-new-banner-step-zero', 'sozdanie-gruppy-obyavleniy', 'Создание группы объявлений')
                                },
                                (error || errorCode) && {
                                    block: 'p-new-banner-step-zero',
                                    elem: 'errors',
                                    error: error,
                                    errorCode: errorCode
                                }
                            ]
                        }
                    ]
                },
                {
                    elem: 'row',
                    center: {
                        block: 'p-new-banner-step-zero',
                        elem: 'form',
                        elemMods: {
                            'agency-client': agencyClient && 'yes',
                            'select-client': hasClientsList && 'yes'
                        },
                        login: form.for_client || form.login || form.newlogin || '',
                        action: data.script,
                        mediaType: form.mediaType,
                        host: data.server_name,
                        isDynamic: isDynamic,
                        forAgency: form.for_agency || data.for_agency,
                        passportHost: data.passport_domain,
                        isMobile: data.uatraits.isMobile,
                        clients: clients
                    }
                }
            ]
        };
    }),

    elem('errors').content()(function() {
        var contents = [],
            errorMessages = {
                0: iget2('p-new-banner-step-zero', 'neizvestnaya-oshibka', 'Неизвестная ошибка'),
                1: iget2('p-new-banner-step-zero', 'etot-login-zanyat-drugim', 'Этот логин занят другим агентством'),
                2: iget2('p-new-banner-step-zero', 'dlya-etogo-logina-nelzya', 'Для этого логина нельзя создавать объявления - это не клиент'),
                3: iget2('p-new-banner-step-zero', 'klient-ne-nayden', 'Клиент не найден'),
                4: iget2('p-new-banner-step-zero', 'eto-ne-vashe-agentstvo', 'Это не ваше агентство'),
                5: iget2('p-new-banner-step-zero', 'klient-yavlyaetsya-pryamym', 'Клиент является прямым'),
                6: iget2('p-new-banner-step-zero', 'layt-loginy-ne-dopustimy', 'Лайт-логины не допустимы'),
                7: iget2('p-new-banner-step-zero', 'strana-ukazana-neverno', 'Страна указана неверно'),
                8: iget2('p-new-banner-step-zero', 'valyuta-ukazana-neverno', 'Валюта указана неверно'),
                9: iget2(
                    'p-new-banner-step-zero',
                    'strana-klienta-ne-sootvetstvuet',
                    'Страна клиента не соответствует доступным валютам оплаты агентства'
                ),
                10: iget2(
                    'p-new-banner-step-zero',
                    'valyuta-klienta-ne-sootvetstvuet',
                    'Валюта клиента не соответствует доступным валютам агентства'
                ),
                11: iget2('p-new-banner-step-zero', 'ozhidaem-podtverzhdeniya-ot-klienta', 'Ожидаем подтверждения от клиента'),
                12: iget2('p-new-banner-step-zero', 'trebuetsya-podtverzhdenie-ot-klienta', 'Требуется подтверждение от клиента')
            };

        this.ctx.error &&
            (contents = contents.concat(u.escapeHTML(this.ctx.error).split('\n')));

        this.ctx.errorCode &&
            contents.push(errorMessages[this.ctx.errorCode] || errorMessages[0]);

        return contents.length && [
            {
                block: 'icon',
                mods: {
                    'size-13': 'alert'
                },
                mix: [{
                    block: 'p-new-banner-step-zero',
                    elem: 'notice'
                }]
            },
            {
                elem: 'error-messages',
                content: contents.join('<br />')
            }
        ];
    })
);
