BEM.DOM.decl('p-new-banner-step-zero', {

    onSetMod: {
        js: function() {
            var popupOpener = this.findBlockOn('create-login', 'b-modal-popup-opener');

            // DIRECT-49209
            if (popupOpener) {
                popupOpener
                    .getEventBus()
                    // Событие триггерится в data/t/create_login.html
                    .on('create-login', this._onCreateLogin, this);
            }
        }
    },

    /**
     * {BEM}
     * @private
     */
    _loginInput: null,

    /**
     * Возвращает и кэширует элемент login-input
     * @returns {BEM}
     * @private
     */
    _getLoginInput: function() {
        return this._loginInput || (this._loginInput = this.findBlockOn('login-input', 'input'));
    },

    /**
     * Обработчик события create-login
     * @param {Event} e
     * @param {Object} data
     * @param {String} data.login
     * @private
     */
    _onCreateLogin: function(e, data) {
        data && data.login && this._getLoginInput().val(data.login);
    }

});
