match(function() {
    return this.data.cmd === 'addClientToMCC';
})(

    block('app-main').mode('page-block')('p-new-mcc'),

    block('b-page').mode('title')(function() {
        return iget2('p-new-mcc', 'title', 'Добавить клиентского менеджера');
    })
);

block('p-new-mcc')(

    addJs()(true),

    content()(function() {
        var data = this.data,
            form = data.FORM;

        return {
            elem: 'form',
            action: data.SCRIPT,
            content: [
                {
                    elem: 'hidden',
                    name: 'cmd',
                    value: 'addClientToMCC'
                },
                {
                    elem: 'hidden',
                    name: 'ulogin',
                    value: data.user_login
                },
                {
                    elem: 'hidden',
                    name: 'save',
                    value: 'save'
                },
                {
                    block: 'l-page',
                    mods: {
                        layout: '16-60-16'
                    },
                    content: [
                        {
                            elem: 'row',
                            left: true,
                            center: {
                                block: 'b-page-title',
                                mix: [{
                                    block: 'p-new-mcc',
                                    elem: 'title'
                                }],
                                title: iget2('p-new-mcc', 'title', 'Добавить клиентского менеджера')
                            },
                            right: true,
                            rgap: true
                        },
                        {
                            elem: 'row',
                            left: true,
                            center: {
                                block: 'p-new-mcc',
                                elem: 'section',
                                content: [
                                    {
                                        elem: 'section-head',
                                        content: iget2('p-new-mcc', 'login-field', 'Логин менеджера на Яндексе')
                                    },
                                    {
                                        block: 'input',
                                        mix: [
                                            {
                                                block: 'p-new-mcc',
                                                elem: 'input'
                                            },
                                            {
                                                block: 'p-new-mcc',
                                                elem: 'login'
                                            }
                                        ],
                                        name: 'mcc_client_login',
                                        value: form.mcc_client_login,
                                        content: {
                                            elem: 'control'
                                        }
                                    },
                                    {
                                        elem: 'description',
                                        content: iget2(
                                            'p-new-mcc',
                                            'description-2',
                                            'Укажите логин, зарегистрированный на Яндексе и использующийся в Яндекс.Директе'
                                        )
                                    },
                                    {
                                        elem: 'submit-panel',
                                        content: {
                                            block: 'button',
                                            type: 'submit',
                                            mods: { theme: 'action' },
                                            mix: [{
                                                block: 'p-new-mcc',
                                                elem: 'submit'
                                            }],
                                            content: iget2('p-new-mcc', 'submit', 'Добавить клиентского менеджера')
                                        }
                                    }
                                ]
                            },
                            right: true,
                            rgap: true
                        }
                    ]
                }
            ]
        };
    })

);
