BEM.DOM.decl('p-new-mcc', {

    onSetMod: {

        js: function() {
            BEM.blocks['i-utils'].graspSelf.call(this, {
                login: 'input on login',
            });

            this.bindTo('form', 'submit', function(e) { this.validate() || e.preventDefault() });
        }

    },

    /**
     * Валидация формы
     * @returns {boolean}
     */
    validate: function() {
        var hasEmptyField = ![
            { name: 'login', error: iget2('p-new-mcc', 'empty-login', 'Введите логин') },
        ].every(function(field) {
            var isEmpty = !this[field.name].val();

            isEmpty && this.showError(field.error);

            return !isEmpty;
        }, this);

        return !hasEmptyField;
    },

    /**
     * Отображает ошибку валидации формы
     * @param {String} error
     */
    showError: function(error) {
        BEM.blocks['b-confirm'].alert(error);
    }

});
