match(function() {
    return this.data.cmd === 'addClRep';
})(

    block('app-main').mode('page-block')('p-new-representative'),

    block('b-page').mode('title')(function() {
        return iget2('p-new-representative', 'naznachenie-predstaviteley', 'Назначение представителей');
    })
);

block('p-new-representative')(

    addJs()(true),

    content()(function() {
        var data = this.data,
            clientFeatures = data.features_enabled_for_client || {},
            rightsEnabled = clientFeatures.readonly_reps,
            form = data.FORM,
            selectedRight = form.rep_type || 'main';

        return {
            elem: 'form',
            action: data.SCRIPT,
            content: [
                {
                    elem: 'hidden',
                    name: 'cmd',
                    value: 'addClRep'
                },
                {
                    elem: 'hidden',
                    name: 'ulogin',
                    value: data.user_login
                },
                {
                    elem: 'hidden',
                    name: 'save',
                    value: 'save'
                },
                {
                    block: 'l-page',
                    mods: {
                        layout: '16-60-16'
                    },
                    content: [
                        {
                            elem: 'row',
                            left: true,
                            center: {
                                block: 'b-page-title',
                                mix: [{
                                    block: 'p-new-representative',
                                    elem: 'title'
                                }],
                                title: iget2('p-new-representative', 'naznachenie-predstaviteley', 'Назначение представителей')
                            },
                            right: true,
                            rgap: true
                        },
                        {
                            elem: 'row',
                            left: {
                                block: 'p-new-representative',
                                elem: 'section-num',
                                content: '1.&nbsp'
                            },
                            center: {
                                block: 'p-new-representative',
                                elem: 'section',
                                content: [
                                    {
                                        elem: 'section-head',
                                        content: iget2('p-new-representative', 'login-predstavitelya', 'Логин представителя')
                                    },
                                    {
                                        block: 'input',
                                        mix: [
                                            {
                                                block: 'p-new-representative',
                                                elem: 'input'
                                            },
                                            {
                                                block: 'p-new-representative',
                                                elem: 'login'
                                            }
                                        ],
                                        name: 'cl_login',
                                        value: form.login || form.cl_login,
                                        content: {
                                            elem: 'control'
                                        }
                                    },
                                    {
                                        block: 'p-new-representative',
                                        elem: 'new-login'
                                    },
                                    {
                                        elem: 'description',
                                        content: iget2(
                                            'p-new-representative',
                                            'ukazhite-login-zaregistrirovannyy-na',
                                            'Укажите логин, зарегистрированный на Яндексе, но никогда не использовавшийся в Яндекс.Директе. Пользователь, вошедший под этим логином, будет иметь полномочия представителя.'
                                        )
                                    },
                                    {
                                        elem: 'description',
                                        content: iget2(
                                            'p-new-representative',
                                            'dobavlyaya-predstavitelya-vy-razreshaete',
                                            'Добавляя представителя, вы разрешаете этому пользователю управлять всеми рекламными кампаниями, которые размещаются во всех коммерческих сервисах Яндекса под вашим логином.'
                                        )
                                    },
                                    [iget2(
                                        'p-new-representative',
                                        'vnimanie-v-celyah-bezopasnosti',
                                        'Внимание! В целях безопасности используйте для назначения представителей только логины, зарегистрированные вами лично.'
                                    )]
                                        .concat(data.error && data.error.split('\n'))
                                        .map(function(msg) {
                                            return msg && {
                                                elem: 'warning',
                                                content: msg
                                            };
                                        })
                                ]
                            },
                            right: true,
                            rgap: true
                        },
                        {
                            elem: 'row',
                            left: {
                                block: 'p-new-representative',
                                elem: 'section-num',
                                content: '2.&nbsp'
                            },
                            center: {
                                block: 'p-new-representative',
                                elem: 'section',
                                content: [
                                    {
                                        elem: 'section-head',
                                        content: iget2('p-new-representative', 'personalnye-dannye', 'Персональные данные')
                                    },
                                    {
                                        block: 'b-layout-table',
                                        content: [
                                            {
                                                name: 'name',
                                                title: iget2('p-new-representative', 'imya', 'Имя')
                                            },
                                            {
                                                name: 'email',
                                                title: iget2('p-new-representative', 'e-mail', 'E-mail')
                                            },
                                            {
                                                name: 'phone',
                                                title: iget2('p-new-representative', 'telefon', 'Телефон')
                                            }
                                        ].map(function(field) {
                                            var name = 'cl_' + field.name;

                                            return {
                                                elem: 'row',
                                                content: [
                                                    {
                                                        elem: 'cell',
                                                        mix: [{
                                                            block: 'p-new-representative',
                                                            elem: 'label'
                                                        }],
                                                        content: field.title + ':'
                                                    },
                                                    {
                                                        elem: 'cell',
                                                        mix: [{
                                                            block: 'p-new-representative',
                                                            elem: 'control'
                                                        }],
                                                        content: {
                                                            block: 'input',
                                                            mix: [
                                                                {
                                                                    block: 'p-new-representative',
                                                                    elem: 'input'
                                                                },
                                                                {
                                                                    block: 'p-new-representative',
                                                                    elem: field.name
                                                                }
                                                            ],
                                                            name: name,
                                                            value: form[name],
                                                            content: {
                                                                elem: 'control'
                                                            }
                                                        }
                                                    }
                                                ]
                                            };
                                        })
                                    }
                                ]
                            },
                            right: true,
                            rgap: true
                        },
                        rightsEnabled && {
                            elem: 'row',
                            left: {
                                block: 'p-new-representative',
                                elem: 'section-num',
                                content: '3.&nbsp'
                            },
                            center: {
                                block: 'p-new-representative',
                                elem: 'section',
                                content: [
                                    {
                                        elem: 'section-head',
                                        content: iget2('p-new-representative', 'access', 'Права доступа')
                                    },
                                    {
                                        elem: 'description',
                                        content: iget2(
                                            'p-new-representative',
                                            'access-description',
                                            '«Полный доступ» позволяет редактировать все кампании и видеть баланс, «Только чтение» позволяет просматривать параметры кампаний, но не позволяет видеть баланс.'
                                        )
                                    },
                                    {
                                        block: 'select',
                                        mix: {
                                            block: 'p-new-representative',
                                            elem: 'select'
                                        },
                                        mods: { layout: 'content' },
                                        name: 'rep_type',
                                        content: [
                                            {
                                                block: 'button'
                                            },
                                            {
                                                elem: 'control',
                                                content: [
                                                    {
                                                        title: iget2('p-new-representative', 'access-main', 'Полный доступ'),
                                                        value: 'main'
                                                    },
                                                    {
                                                        title: iget2('p-new-representative', 'access-readonly', 'Только чтение'),
                                                        value: 'readonly'
                                                    }
                                                ].map(function(item) {
                                                    return {
                                                        elem: 'option',
                                                        attrs: u._.extend({ value: item.value },
                                                            item.value == selectedRight ? { selected: 'selected' } : {}),
                                                        content: item.title
                                                    };
                                                }, this)
                                            }
                                        ]
                                    }
                                ]
                            },
                            right: true,
                            rgap: true
                        },
                        {
                            elem: 'row',
                            left: true,
                            center: {
                                block: 'p-new-representative',
                                elem: 'section',
                                content: [
                                    {
                                        elem: 'row',
                                        content: [
                                            {
                                                elem: 'cell',
                                                mix: [{
                                                    block: 'p-new-representative',
                                                    elem: 'submit-panel'
                                                }],
                                                content: {
                                                    block: 'button',
                                                    type: 'submit',
                                                    mods: { theme: 'action' },
                                                    mix: [{
                                                        block: 'p-new-representative',
                                                        elem: 'submit'
                                                    }],
                                                    content: iget2('p-new-representative', 'zaregistrirovat', 'Зарегистрировать')
                                                }
                                            }
                                        ]
                                    }
                                ]
                            },
                            right: true,
                            rgap: true
                        }
                    ]
                }
            ]
        };
    }),

    elem('new-login')(

        content()(function() {
            return {
                block: 'link',
                mods: {
                    pseudo: 'yes'
                },
                mix: [{
                    block: 'p-new-representative',
                    elem: 'passport-link'
                }],
                content: iget2('p-new-representative', 'zaregistrirovat-login-dlya-novogo', 'зарегистрировать логин для нового представителя')
            };
        }),

        match(function() {
            return this.data.login_rights.is_teamleader || this.data.login_rights.is_superteamleader ||
                this.data.login_rights.super_control;
        }).content()(function() {
            return {
                block: 'b-modal-popup-opener',
                mix: [{
                    block: 'p-new-representative',
                    elem: 'create-login-popup'
                }],
                url: u.getUrl('createLogin', {
                    from: 'callback',
                    bem: 1
                }),
                text: iget2('p-new-representative', 'zaregistrirovat-login-dlya-novogo', 'зарегистрировать логин для нового представителя'),
                width: 650,
                height: 420,
                windowParams: {
                    width: 700,
                    height: 470
                }
            };
        })
    )

);
