BEM.DOM.decl('p-new-representative', {

    onSetMod: {

        js: function() {
            BEM.blocks['i-utils'].graspSelf.call(this, {
                login: 'input on login',
                name: 'input on name',
                email: 'input on email',
                phone: 'input on phone'
            });

            this.bindTo('form', 'submit', function(e) { this.validate() || e.preventDefault() });

            (this.passportLink = this.findBlockOn('passport-link', 'link')) &&
                this.passportLink.on('click', function() {
                    this.__self.doc.get(0).location = u.getUrl('showRegisterLoginPage', {
                        login: this.login.val(),
                        retpath: u.getCurrentUrl()
                    });
                }, this);

            this.modalPopup = this.findBlockInside('create-login-popup', 'b-modal-popup-opener');
            this.modalPopup && this.modalPopup.getEventBus()
                .on('create-login', function(e, data) {
                    data && data.login && this.login.val(data.login);
                }, this);
        }

    },

    /**
     * Валидация формы
     * @returns {boolean}
     */
    validate: function() {
        var hasEmptyField = ![
                { name: 'login', error: iget2('p-new-representative', 'vvedite-login', 'Введите логин') },
                { name: 'name', error: iget2('p-new-representative', 'vvedite-imya-predstavitelya', 'Введите имя представителя') },
                { name: 'phone', error: iget2('p-new-representative', 'vvedite-telefon', 'Введите телефон') }
            ].every(function(field) {
                var isEmpty = !this[field.name].val();

                isEmpty && this.showError(field.error);

                return !isEmpty;
            }, this),
            emailValid = u.emailRegExp().test(this.email.val()),
            phoneValid = (this.phone.val().match(/(\d)/g) || []).length > 3;

        !hasEmptyField && !emailValid && this.showError(iget2('p-new-representative', 'vvedite-korrektnyy-e-mail', 'Введите корректный e-mail'));

        !hasEmptyField && !phoneValid && this.showError(iget2('p-new-representative', 'vvedite-korrektnyy-nomer-telefona', 'Введите корректный номер телефона'));

        return !hasEmptyField && emailValid && phoneValid;
    },

    /**
     * Отображает ошибку валидации формы
     * @param {String} error
     */
    showError: function(error) {
        BEM.blocks['b-confirm'].alert(error);
    }

});
