match(function() {
    return this.data.cmd === 'showAgencyOfflineReports'
})(

    block('app-main')(
        mode('page-block')('p-offline-agency-reports'),

        mode('is-footer-enabled')(false)
    ),

    block('b-page')(
        mode('title')(function() {
            return iget2('p-offline-agency-reports',
                'offline-reports',
                'Отчёт по клиентам'
            );
        }),
        elem('stat').content()(function() {
            return false;
        })
    )
);

block('p-offline-agency-reports')(
    addJs()(function() {
        var data = this.data,
            devInfo = {
                isBeta: data.is_beta,
                svn: {}
            },
            svnInfo = data.svn_info || {};

        if (data.is_beta) {
            devInfo.svn = {
                branch: svnInfo.branch,
                revision: svnInfo.revision
            }
        }

        return {
            reqid: data.reqid,
            page: data.cmd,
            login: data.ulogin,
            showAdditionalColumns: data.show_additional_columns,
            devInfo: devInfo,
            csrfToken: data.csrf_token,
            enableSidebar: data.is_dna_sidebar_enabled
        };
    }),
    content()(function() {
        return [
            {
                elem: 'grid',
                content: { elem: 'grid-stub' }
            }
        ];
    }),

    elem('grid-stub').content()(function() {
        return [
            {
                block: 'spin2',
                mix: { block: 'p-offline-agency-reports', elem: 'spin' },
                mods: { size: 'l', progress: 'yes' }
            },
            {
                elem: 'grid-loading-message',
                content: iget2('p-offline-agency-reports', 'data-is-loading', 'Данные загружаются…')
            }
        ];
    })
);
