block('p-offline-reports').elem('info').replace()(function() {
    var data = this.data,
        campaign = data.campaign,
        ulogin = data.user_login,
        isInternalCampaign = u.consts('rights').enableInternalCampaigns && u.campaign.isInternal(campaign.type),
        campsList = [],
        briefRows = [];

    !data.campaign.currency_archived && data.camps_name_only.forEach(function(camp) {
        if (camp.cid != data.cid && (camp.mediaType === data.mediaType ||
                camp.mediaType === 'text' && !data.mediaType || !camp.mediaType && data.mediaType === 'text')) {

            campsList.push({
                url: u.getUrl('showCampStat', {
                    detail: 'Yes',
                    types: 'days',
                    cid: camp.cid,
                    ulogin: ulogin
                }),
                name: camp.name,
                cid: camp.cid,
                total: camp.mediaType === 'text' || !camp.mediaType ?
                    u.currencies.formatSum(camp.currency, camp.total) : u.formatShowsOrMoney(camp.total_units, 'shows') + '&nbsp;' + iget2('p-offline-reports', 'tys', 'тыс.')
            });
        }
    });

    if (+campaign.wallet_cid) {
        briefRows.push(['start-date'], ['clicks']);
    } else {
        data.campaign.currency !== 'YND_FIXED' ?
            briefRows.push(['start-date', 'rest-block'], ['clicks']) :
            briefRows.push(['start-date', 'sum-block'], ['clicks', 'rest-block']);
    }

    return [{
        block: 'b-campaign-info',
        header: {
            headword: iget2('p-offline-reports', 'statistika-kampanii', 'Статистика кампании'),
            allCampsUrl: isInternalCampaign ?
                u.formatUrl({
                    path: '/dna/grid/campaigns',
                    query: {
                        ulogin: ulogin
                    }
                }) :
                u.getUrl('showCamps', {
                    ulogin: ulogin
                }),
            campsList: campsList,
            cname: campaign.cname,
            cid: data.cid
        },
        isStatPage: true,
        state: {
            text: campaign.status.text
        },
        brief: {
            rows: briefRows,
            startDate: campaign.dd + '.' + campaign.mm + '.' + campaign.yyyy,
            clicks: campaign.clicks,
            sum: campaign.sum,
            total: campaign.total,
            walletCid: campaign.wallet_cid,
            blockedPayment: campaign.statusNoPay == 'Yes',
            blockedMoney: campaign.sum && campaign.money_type == 'blocked',
            canPay: campaign.statusNoPay == 'No' && (campaign.statusModerate == 'Yes' ||
                campaign.manager_uid || campaign.agency_uid)
        }
    }];
});
