match(function() {
    return this.data.cmd === 'listOfflineReports';
})(

    block('app-main').mode('page-block')(function() {
        return {
            block: 'p-offline-reports',
            mods: {
                type: this.data.statType
            }
        };
    }),

    block('b-page').mode('title')(function() {
        return iget2('p-offline-reports', 'statistika-v-xls', 'Статистика в xls');
    })
);

block('p-offline-reports')(

    addJs()(function() {
        return {
            campaign: this.data.campaign
        };
    }),

    content()(function() {
        return {
            block: 'l-page',
            content: [
                {
                    elem: 'row',
                    left: {
                        block: 'b-campaign-menu',
                        mix: [{
                            block: 'p-offline-reports',
                            elem: 'camp-menu'
                        }],
                        options: {
                            navMods: {
                                border: 'yes',
                                type: 'stat'
                            },
                            campOptionsViewOnly: (this.data.allow_edit_camp || this.data.campaign.allow_edit_camp) &&
                                !hasLoginRights('media_control')
                        }
                    },
                    right: {
                        block: 'b-layout-table',
                        mix: [{
                            block: 'p-campaign-stat',
                            elem: 'head-layout'
                        }],
                        content: [
                            {
                                elem: 'row',
                                content: {
                                    elem: 'cell',
                                    content: {
                                        block: 'p-offline-reports',
                                        elem: 'info'
                                    }
                                }
                            },
                            {
                                elem: 'row',
                                content: {
                                    elem: 'cell',
                                    content: [
                                        {
                                            block: 'b-stat-tabs',
                                            mods: { type: 'single-camp' }
                                        },
                                        {
                                            block: 'b-statistics-form',
                                            mods: {
                                                type: 'offline-reports'
                                            }
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                },
                {
                    elem: 'row',
                    center: true,
                    ctxCells: {
                        center: {
                            content: {
                                block: 'b-report-ready',
                                mix: [{
                                    block: 'p-offline-reports',
                                    elem: 'data'
                                }],
                                reports: this.data.reports
                            },
                            attrs: {
                                colspan: 2
                            }
                        }
                    }
                }
            ]
        };
    })
);
