match(function() {
    return this.data.cmd === 'orderCamp';
})(

    block('app-main').mode('page-block')('p-order-campaign'),

    block('b-page').mode('title')(function() {
        return this.data.title;
    })
);

block('p-order-campaign')(
    addJs()(true),

    content()(function() {
        var data = this.data,
            hiddenInputs = [
                {
                    name: 'cid',
                    value: data.cid
                },
                {
                    name: 'cmd',
                    value: 'orderCamp',
                    mix: {
                        block: 'p-order-campaign',
                        elem: 'cmd'
                    }
                },
                {
                    name: 'agree',
                    mix: {
                        block: 'p-order-campaign',
                        elem: 'accept-hidden'
                    },
                    value: ''
                }
            ],
            uidParam = {},
            uidUrl = data.uid_url;

        data.uid_par && hiddenInputs.push({
            name: data.uid_par.key,
            value: data.uid_par.value
        });
        uidUrl && (uidParam[uidUrl.key] = uidUrl.value) || (uidParam = '');

        return {
            block: 'l-page',
            mods: {
                layout: '16-60-16'
            },
            content: [
                {
                    elem: 'row',
                    left: true,
                    rgap: true,
                    right: true,
                    center: [
                        {
                            block: 'b-page-title',
                            content: {
                                elem: 'title',
                                content: iget2('p-order-campaign', 'zakaz', 'Заказ')
                            }
                        },
                        data.error ?
                            {
                                block: 'p-order-campaign',
                                elem: 'errors',
                                content: data.error
                            } :
                            '',
                        {
                            elem: 'agreement',
                            content: [
                                iget2('p-order-campaign', 'ya-zakazyvayu-reklamnuyu-kampaniyu', 'Я заказываю рекламную кампанию'),
                                ' ',
                                {
                                    block: 'link',
                                    url: u.getUrl('editCamp', u._.extend({
                                        cid: data.cid
                                    }, uidParam)),
                                    content: u.escapeHTML(data.name)
                                },
                                ' ',
                                iget2('p-order-campaign', 'i-soglasen-s-usloviyami', 'и согласен с условиями размещения рекламы.')
                            ]
                        },
                        {
                            block: 'b-layout-form',
                            action: data.script,
                            mix: {
                                block: 'p-order-campaign',
                                elem: 'form'
                            },
                            hiddenInputs: hiddenInputs,
                            rows: [
                                {
                                    block: 'b-oferta-accept',
                                    mix: {
                                        block: 'p-order-campaign',
                                        elem: 'oferta-accept'
                                    },
                                    acceptRadioName: 'accept',
                                    params: {
                                        source: 'oferta_direct',
                                        yandexDomain: data.yandex_domain,
                                        firmId: data.client_firm_id
                                    }
                                },
                                {
                                    elem: 'info',
                                    content: [
                                        {
                                            block: 'p-order-campaign',
                                            elem: 'info-header',
                                            content: iget2('p-order-campaign', 'vnimanie', 'Внимание!')
                                        },
                                        {
                                            block: 'p-order-campaign',
                                            elem: 'info-block',
                                            content: [
                                                iget2(
                                                    'p-order-campaign',
                                                    'rezultat-proverki-vam-soobshchat',
                                                    'Результат проверки вам сообщат по адресу {mail}, указанному вами при регистрации на Яндексе.',
                                                    {
                                                        mail: {
                                                            block: 'p-order-campaign',
                                                            elem: 'mail',
                                                            content: data.email
                                                        }
                                                    }
                                                ),
                                                iget2(
                                                    'p-order-campaign',
                                                    'esli-eto-oshibochnyy-adres',
                                                    'Если это ошибочный адрес - вы можете его изменить на странице "Параметры кампании".'
                                                ),
                                                iget2(
                                                    'p-order-campaign',
                                                    'takzhe-vy-mozhete-nablyudat',
                                                    'Также вы можете наблюдать за вашей кампанией в разделе &laquo;Мои кампании&raquo;.'
                                                )
                                            ]
                                        }
                                    ]
                                },
                                applyCtx({
                                    block: 'p-order-campaign',
                                    elem: 'buttons',
                                    content: [
                                        {
                                            elem: 'cancel-button',
                                            content: iget2('p-order-campaign', 'nazad-112', '< Назад'),
                                            type: 'button'
                                        },
                                        {
                                            elem: 'apply-button',
                                            elemMods: { disabled: 'yes' },
                                            content: iget2('p-order-campaign', 'zakazat', 'Заказать >'),
                                            type: 'submit'
                                        }
                                    ]
                                })
                            ]
                        }
                    ]
                }
            ]
        };
    }),

    elem('buttons').content()(function() {
        return this.ctx.content.map(function(button) {
            return {
                block: 'button',
                mods: u._.extend({
                    size: 's',
                    theme: 'normal'
                }, button.mods),
                mix: [
                    {
                        block: 'p-order-campaign',
                        elem: button.elem
                    },
                    {
                        block: 'p-order-campaign',
                        elem: 'button'
                    }
                ],
                type: button.type,
                content: button.content
            };
        });
    })
);
