match(function() {
    return this.data.cmd === 'pay';
})(

    block('app-main').mode('page-block')('p-pay'),

    block('b-page').mode('title')(function() {
        return iget2('p-pay', 'oplata-reklamnoy-kampanii', 'Оплата рекламной кампании');
    })
);

block('p-pay')(

    def()(function() {
        this.ctx.clientNDS = this.data.client && this.data.client.NDS;

        return applyNext();
    }),

    content()(function() {
        return {
            block: 'l-page',
            mods: {
                layout: '60'
            },
            content: [
                {
                    elem: 'row',
                    lgap: true,
                    rgap: true,
                    center: [
                        {
                            block: 'p-pay',
                            elem: 'title',
                            content: iget2('p-pay', 'oplata-reklamnoy-kampanii', 'Оплата рекламной кампании')
                        },
                        {
                            block: 'p-pay',
                            elem: 'subtitle',
                            content: iget2('p-pay', 'kampaniya-no-s-s', 'Кампания №{foo} ({bar})', {
                                foo: this.data.cid,
                                bar: this.data.name
                            })
                        },
                        !this.data.is_currency_archive && {
                            block: 'b-overdraft'
                        },
                        !!this.data.pay_error_text && {
                            block: 'p-pay',
                            elem: 'pay-error',
                            content: u.escapeHTML(this.data.pay_error_text)
                        },
                        this.data.pay_method == 'with_block' && this.data.yandex_domain != 'yandex.com.tr' && {
                            block: 'p-pay',
                            elem: 'pay-method',
                            content: [
                                iget2(
                                    'p-pay',
                                    'oplata-vozmozhna-tolko-yandeks',
                                    'Оплата возможна только Яндекс.Деньгами. Для юридических лиц также доступна оплата безналичным способом'
                                ),
                                {
                                    block: 'b-help-link',
                                    url: u.getHelpUrl('pay-before-moderated')
                                }
                            ]
                        }
                    ]
                },
                {
                    elem: 'row',
                    lgap: true,
                    rgap: true,
                    center: {
                        block: 'p-pay',
                        elem: 'detail-container',
                        content: [
                            {
                                block: 'b-pay',
                                mods: {
                                    inline: 'yes',
                                    nds: this.ctx.clientNDS &&
                                        !u._.contains(['YND_FIXED', 'BYN', 'KZT'], this.data.work_currency) ? 'yes' : 'no'
                                },
                                clientNDS: this.ctx.clientNDS,
                                userLogin: this.data.user_login,
                                cid: this.data.cid,
                                offerSumToPay: this.data.topay / (1 + (this.ctx.clientNDS || 0) / 100)
                            },
                            this.ctx.clientNDS ?
                                {
                                    block: 'icon-text',
                                    mix: [
                                        {
                                            block: 'p-pay',
                                            elem: 'detail-link'
                                        }
                                    ],
                                    mods: {
                                        size: 'xs',
                                        theme: 'info'
                                    },
                                    text: iget2(
                                        'p-pay',
                                        'denezhnye-sredstva-nachislyayutsya-na',
                                        'Денежные средства начисляются на счёт рекламной кампании без учёта НДС. {link}',
                                        {
                                            link: function(text) {
                                                return {
                                                    block: 'b-help-link',
                                                    url: u.getHelpUrl('vat'),
                                                    text: text
                                                };
                                            }(iget2('p-pay', 'denezhnye-sredstva-nachislyayutsya-na-param-link', 'Подробнее')),

                                            context: 'link - Подробнее'
                                        }
                                    )
                                } :
                                ''
                        ]
                    }
                }
            ]
        };
    })
);
