match(function() {
    return this.data.cmd === 'showPddError';
})(

    block('app-main').mode('page-block')('p-pdd-error'),

    block('b-page').mode('title')(function() {
        return iget2('p-pdd-error', 'avtorizovatsya-ne-udalos', 'Авторизоваться не удалось');
    })
);

block('p-pdd-error')(

    mode('logoutQuery')(function() {
        return {
            host: this['i-global']['passport-host'],
            path: 'passport',
            query: {
                mode: 'logout',
                yu: this['i-global'].yandexuid // ugly hack: передаем yandexuid в ссылку для паспорта
            }
        };
    }),

    addJs()(function() {
        return {
            logoutQuery: apply('logoutQuery'),
            retpath: encodeURI(this.data.retpath)
        };
    }),

    content()(function() {
        var _this = this,
            logoutQuery = apply('logoutQuery'), // выполняем apply в контексте текущего блока и передаем в функцию
            passportUrl = function(mode) {
                logoutQuery.query.retpath = encodeURI(u.formatUrl({
                    host: _this['i-global']['passport-host'],
                    path: 'passport',
                    query: {
                        mode: mode,
                        from: 'direct',
                        retpath: encodeURI(_this.data.retpath),
                        twoweeks: 'yes'
                    }
                }));

                return u.formatUrl(logoutQuery);
            };

        return [
            {
                elem: 'title',
                content: iget2('p-pdd-error', 'avtorizovatsya-ne-udalos', 'Авторизоваться не удалось')
            },
            {
                elem: 'message',
                content: [
                    iget2('p-pdd-error', 'loginy-vida-yourdomain-ru', 'Логины вида @yourdomain.ru не поддерживаются сервисом Яндекс.Директ.'),
                    '<br/>',
                    iget2('p-pdd-error', 'pozhaluysta-login-vvedite-svoy', 'Пожалуйста, {login} на Яндексе или {register}.', {
                        login: function(text) {
                            return {
                                block: 'link',
                                mix: {
                                    block: 'p-pdd-error',
                                    elem: 'login'
                                },
                                url: passportUrl('auth'),
                                content: text
                            };
                        }(iget2('p-pdd-error', 'pozhaluysta-login-vvedite-svoy-param-login', 'введите свой обычный логин и пароль')),

                        register: function(text) {
                            return {
                                block: 'link',
                                mix: {
                                    block: 'p-pdd-error',
                                    elem: 'register'
                                },
                                url: passportUrl('register'),
                                content: text
                            };
                        }(iget2('p-pdd-error', 'pozhaluysta-login-vvedite-svoy-param-register', 'зарегистрируйтесь')),

                        context: 'login - введите свой обычный логин и пароль; register - зарегистрируйтесь'
                    })
                ]
            }
        ];
    })
);
