match(function() {
    return this.data.cmd === 'newClientPotentialReport';
})(

    block('app-main').mode('page-block')('p-potential-report'),

    block('b-page').mode('title')(function() {
        return iget2('p-potential-report', 'raschet-potenciala-klienta', 'Расчёт потенциала клиента');
    })
);

block('p-potential-report').js()(function() {
    return !this.data.login_rights.superreader_control;
});

block('p-potential-report').content()(function() {
    return {
        block: 'l-page',
        mods: {
            layout: '16-80'
        },
        content: [
            {
                elem: 'row',
                left: true,
                right: {
                    block: 'b-page-title',
                    title: iget2('p-potential-report', 'raschet-potenciala-klienta', 'Расчёт потенциала клиента')
                }
            },
            !this.data.login_rights.superreader_control && {
                elem: 'row',
                left: true,
                right: {
                    block: 'b-new-potential-report',
                    url: this.data.script
                }
            },
            {
                elem: 'row',
                left: true,
                right: {
                    block: 'b-potential-reports-list',
                    mix: [{
                        block: 'p-potential-report',
                        elem: 'reports-list'
                    }],
                    url: this.data.script,
                    ulogin: this.data.user_login
                }
            }
        ]
    };
});
