match(function() {
    return this.data.cmd === 'dealsList';
})(

    block('app-main')(
        mode('page-block')('p-private-deals'),

        mode('is-footer-enabled')(true)
    ),

    block('app-main').mode('page-block')(function() {
        var pageBlock = {
            block: 'p-private-deals',
            mods: {}
        };

        // Закрываем доступ ограниченным представителям агенств (DIRECT-77813)
        if (!(hasLoginRights('super_control') || hasEnabledFeatures('cpm_deals')) || hasLoginRights('is_agency_limited')) {
            pageBlock.mods.type = 'access-denied';
        }

        return pageBlock;
    }),

    block('b-page')(
        def()(function() {
            return applyNext({
                'ctx.mods': u._.extend(this.mods, { height: 'window' })
            });
        }),
        mode('title')(function() {
            return iget2('p-private-deals', 'deals-list-title', 'Список сделок');
        })
    )
);

block('p-private-deals').mod('type', 'access-denied').replace()(function() {
    return {
        block: 'l-page',
        mods: {
            layout: '16-60-16'
        },
        content: {
            elem: 'row',
            left: true,
            right: true,
            center: {
                block: 'p-private-deals',
                elem: 'access-denied'
            }
        }
    };
});

block('p-private-deals')(
    addJs()(function() {
        var data = this.data;

        return {
            reqid: data.reqid,
            page: data.cmd,
            login: data.user_login,
            enableSidebar: data.is_dna_sidebar_enabled,
            csrfToken: data.csrf_token
        };
    }),

    content()(function() {
        return { elem: 'stub' };
    }),

    elem('stub').content()(function() {
        return [
            {
                block: 'spin2',
                mix: { block: 'p-private-deals', elem: 'spin' },
                mods: { size: 'l', progress: 'yes' }
            }
        ];
    })
);
