BEM.DOM.decl('p-private-deals', {
    onSetMod: {
        js: function() {
            if (!window.dna) {
                throw new Error('An error has occurred in loading DNA dependencies');
            }

            this._renderDna();
        }
    },

    /**
     * Render DNA root component
     */
    _renderDna: function() {
        var dna = window.dna,
            params = this.params,
            dnaRootComponent;

        if (dna.components.Root.initStore) {
            dna.components.Root.initStore({
                login: params.login,
                perlReqId: params.reqid,
                page: params.page,
                csrfToken: params.csrfToken
            });
        }

        dnaRootComponent = dna.reactCreateElement(dna.components.Root, {
            login: params.login,
            enableSidebar: !!params.enableSidebar
        }, null);

        dna.reactDOMRender(dnaRootComponent, this.domElem.get(0));
    }
});
