block('p-promo-commander').elem('install')(
    elem('install-link').content()(function() {
        return {
            block: 'link',
            mods: {
                inner: 'yes',
                theme: 'promo-commander'
            },
            url: this.ctx.data.url,
            content: [
                {
                    block: 'icon',
                    mods: { type: this.ctx.data.icon },
                    mix: [{
                        block: 'link',
                        elem: 'icon'
                    }]
                },
                {
                    elem: 'inner',
                    content: this.ctx.text
                }
            ]
        }
    }),

    content()(function() {
        var data = this.data,
            langPostfix = {
                ru: '',
                en: '-en',
                tr: '-tr',
                ua: '-uk'
            }[data.lang || 'ru'],
            commanderUrl = this.data.staff_commander ?
                ({
                    dmg: 'https://direct.yandex.ru/commander-staff/DirectCommanderStaff' + langPostfix + '.dmg',
                    exe: 'https://direct.yandex.ru/commander-staff/DirectCommanderStaff' + langPostfix + '.exe'
                }) :
                ({
                    dmg: 'https://direct.yandex.ru/commander/DirectCommander' + langPostfix + '.dmg',
                    exe: 'https://direct.yandex.ru/commander/DirectCommander' + langPostfix + '.exe'
                }),
            isMacOs = data.uatraits.OSFamily === 'MacOS',
            macOsVersionText = iget2('p-promo-commander', 'mac-os-version', 'Mac OS 10.6 и выше'),
            windowsVersionText = iget2('p-promo-commander', 'windows-version', 'Windows'),
            linkMainData = isMacOs ?
                ({
                    url: commanderUrl.dmg,
                    version: data.commander_version_dmg,
                    os: macOsVersionText,
                    icon: 'mac'
                }) :
                ({
                    url: commanderUrl.exe,
                    version: data.commander_version_exe,
                    os: windowsVersionText,
                    icon: 'windows'
                }),
            linkSecondaryData = isMacOs ?
                ({
                    url: commanderUrl.exe,
                    version: data.commander_version_exe,
                    os: windowsVersionText,
                    icon: 'windows'
                }) :
                ({
                    url: commanderUrl.dmg,
                    icon: 'mac',
                    os: macOsVersionText,
                    version: data.commander_version_dmg
                }),

            linkMain = iget2(
                'p-promo-commander',
                'main-download-link-text',
                '{link} для {os}',
                {
                    os: linkMainData.os,
                    link: {
                        elem: 'install-link',
                        data: linkMainData,
                        text: iget2('p-promo-commander', 'download-version', 'Установить версию')
                    },
                    version: linkMainData.version
                }
            ),
            linkSecondary = iget2(
                'p-promo-commander',
                'secondary-download-link-text',
                '{link} для {os}',
                {
                    os: linkSecondaryData.os,
                    link: function(linkText) {
                        return {
                            elem: 'install-link',
                            data: linkSecondaryData,
                            text: linkText
                        };
                    }(iget2(
                        'p-promo-commander',
                        'version num',
                        'Версия {version}',
                        { version: linkSecondaryData.version })
                    )
                }
            );

        return [
            {
                elem: 'install-link-block',
                content: linkMain
            },
            {
                elem: 'install-link-block',
                content: linkSecondary
            },
            this.pageParams.hasLegal ?
                {
                    elem: 'install-legal',
                    content: iget2(
                        'p-promo-commander',
                        'ustanavlivaya-programmu-vy-prinimaete-uslovia',
                        'Устанавливая программу, вы принимаете условия<br/>{link}',
                        {
                            link: {
                                block: 'link',
                                mods: { theme: 'promo-commander' },
                                url: u.formatUrl({
                                    protocol: 'https',
                                    host: data.yandex_domain,
                                    path: '/legal/desktop_software_agreement/'
                                }),
                                target: 'blank',
                                content: iget2(
                                    'p-promo-commander',
                                    'ustanavlivaya-programmu-vy-soglashaetes-license-link',
                                    'лицензионного соглашения'
                                )
                            }
                        }
                    )
                } :
                ''
        ];
    })
);
