match(function() {
    return this.data && this.data.is_promo_commander == 1;
})(

    block('app-main').mode('page-block')('p-promo-commander'),

    block('b-page').mode('title')(function() {
        return iget2('p-promo-commander', 'yandeks-direkt-kommander', 'Яндекс.Директ Коммандер') + (this.data.staff_commander ? '&nbsp;Staff' : '');
    }),

    block('b-page')(
        elem('body').content()(function() {
            return [
                //плашка есть только для русскоязычной страницы
                u.consts('lang') === 'ru' ?
                    {
                        block: 'p-promo-commander',
                        mix: {
                            block: 'p-promo-commander',
                            js: { id: 'p-promo-commander' }
                        },
                        elem: 'dc3-install-bar'
                    } :
                    false,
                applyNext()
            ];
        })
    )
);

block('p-promo-commander')(

    addJs()(function() {
        var isMacOs = this.data.uatraits.OSFamily === 'MacOS';

        return { id: 'p-promo-commander', isMacOs: isMacOs };
    }),

    def()(function() {
        this.pageParams = this.data.staff_commander ?
            {
                pageTitle: iget2('p-promo-commander', 'direkt-kommander-nbsp-staff', 'Директ Коммандер&nbsp;Staff&nbsp;&mdash; ваш контекстный помощник'),
                text: iget2('p-promo-commander', 'ustanovit-kommander', 'Установить Коммандер') + '&nbsp;Staff',
                hasLegal: false
            } :
            {
                pageTitle: iget2(
                    'p-promo-commander',
                    'direkt-kommander-nbsp-mdash',
                    'Директ Коммандер&nbsp;&mdash; помогает справиться, когда рекламы много'
                ),
                text: iget2('p-promo-commander', 'ustanovit-kommander', 'Установить Коммандер'),
                hasLegal: true
            };

        return applyNext();
    }),

    content()(function() {
        var data = this.data,
            staticHost = '',
            pathImage = staticHost + '/data3/desktop.blocks/p-promo-commander/__image/p-promo-commander__image-',
            langImage = '_lang_' + u.consts('lang') + '.png',
            pathImageStaff = staticHost +
                '/data3/desktop.blocks/p-promo-commander/__image-staff/p-promo-commander__image-staff-',
            slides = [
                {
                    current: true,
                    src: pathImage + 1 + langImage,
                    title: iget2('p-promo-commander', 'vse-dannye-kak-na', 'Все данные как на ладони'),
                    text: iget2(
                        'p-promo-commander',
                        'pered-vami-vse-vashi',
                        'Перед вами все ваши кампании и&nbsp;объявления. Можно переключаться между панелями и&nbsp;списками и&nbsp;за&nbsp;несколько кликов находить данные, которые нужны вам для&nbsp;работы.'
                    )
                },
                {
                    src: pathImage + 2 + langImage,
                    title: iget2('p-promo-commander', 'bystryy-poisk', 'Быстрый поиск'),
                    text: iget2(
                        'p-promo-commander',
                        'dazhe-esli-u-nbsp',
                        'Даже если у&nbsp;вас очень много кампаний и&nbsp;объявлений, Коммандер поможет быстро найти что угодно: кампании, объявления, ключевые фразы, минус-слова и&nbsp;ставки.'
                    )
                },
                {
                    src: pathImage + 3 + langImage,
                    title: iget2('p-promo-commander', 'prostoe-redaktirovanie', 'Простое редактирование'),
                    text: iget2(
                        'p-promo-commander',
                        'naydite-i-nbsp-otsortiruyte',
                        'Найдите и&nbsp;отсортируйте то, что&nbsp;хотите изменить, а&nbsp;потом используйте массовое редактирование, чтобы изменить все выбранные ставки, тексты или ключевые фразы в&nbsp;одной или&nbsp;нескольких кампаниях.'
                    )
                },
                {
                    src: pathImage + 4 + langImage,
                    title: iget2('p-promo-commander', 'klienty-v-poryadke', 'Клиенты в порядке'),
                    text: iget2(
                        'p-promo-commander',
                        'rabotat-s-nbsp-klientskimi',
                        'Работать с&nbsp;клиентскими аккаунтами и&nbsp;кампаниями легко: удобная &laquo;ветка&raquo; в&nbsp;панели &laquo;Клиенты&raquo; не&nbsp;даст вам запутаться.'
                    )
                },
                {
                    src: pathImage + 5 + langImage,
                    title: iget2('p-promo-commander', 'zagruzka-iz-nestandartnyh-formatov', 'Загрузка из нестандартных форматов'),
                    text: iget2(
                        'p-promo-commander',
                        'ispolzuyte-dannye-v-nbsp',
                        'Используйте данные в&nbsp;форматах CSV, XLS или&nbsp;просто из&nbsp;буфера обмена, чтобы быстро загрузить основу для&nbsp;вашей будущей кампании.'
                    )
                }
            ];

        if (data.staff_commander) {
            slides[3] = slides[2];

            slides[1] = {
                src: pathImageStaff + '2.png',
                title: iget2('p-promo-commander', 'bystryy-poisk-klientov', 'Быстрый поиск клиентов'),
                text: iget2(
                    'p-promo-commander',
                    'kommander-staff-pomozhet-bystro',
                    'Коммандер Staff поможет быстро найти любого клиента, кампанию или объявление. И в один клик получить все данные в удобном для работы виде.'
                )
            };

            slides[2] = {
                src: pathImageStaff + '3.png',
                title: iget2('p-promo-commander', 'rabota-s-mediaplanami', 'Работа с медиапланами'),
                text: iget2(
                    'p-promo-commander',
                    'kommander-staff-polnostyu-podderzhivaet',
                    'Коммандер Staff полностью поддерживает работу с медиапланами&nbsp;&mdash; начиная с копирования объявлений в медиаплан по определённым параметрам и заканчивая его завершением.'
                )
            };
        }

        return {
            block: 'l-page',
            mods: {
                layout: '16-80'
            },
            content: {
                elem: 'row',
                left: {
                    block: 'p-promo-commander',
                    elem: 'layout-gap'
                },
                right: {
                    elem: 'inner',
                    mix: [{
                        block: 'p-promo-commander',
                        elem: 'layout'
                    }],
                    content: [
                        {
                            block: 'p-promo-commander',
                            elem: 'info',
                            content: [
                                {
                                    elem: 'about'
                                },
                                {
                                    elem: 'install'
                                }
                            ]
                        },
                        {
                            block: 'b-promo-slider',
                            mix: [{
                                block: 'p-promo-commander',
                                elem: 'slider'
                            }],
                            slides: slides
                        }
                    ]
                }
            }
        };
    })
);
