match(function() {
    return (this.data.cmd === 'showRecommendations' || this.data.cmd === 'showRecommendationItems');
})(

    block('app-main')(
        mode('page-block')('p-recommendations'),

        mode('is-footer-enabled')(false)
    ),

    block('b-page')(
        mode('title')(function() {
            return iget2('p-recommendations', 'title', 'Рекомендации');
        }),

        elem('stat').content()(function() {
            return false;
        })
    )
);

block('p-recommendations')(
    addJs()(function() {
        var data = this.data,
            devInfo = {
                isBeta: data.is_beta,
                svn: {}
            },
            svnInfo = data.svn_info || {};

        if (data.is_beta) {
            devInfo.svn = {
                branch: svnInfo.branch,
                revision: svnInfo.revision
            }
        }

        return {
            reqid: data.reqid,
            page: data.cmd,
            login: escapeJs(data.login),
            devInfo: devInfo,
            csrfToken: this.data.csrf_token,
            enableSidebar: data.is_dna_sidebar_enabled
        };
    }),

    content()(function() {
        return [
            {
                elem: 'content',
                content: { elem: 'content-stub' }
            }
        ];
    }),

    elem('content-stub').content()(function() {
        return [
            {
                block: 'spin2',
                mix: { block: 'p-recommendations', elem: 'spin' },
                mods: { size: 'l', progress: 'yes' }
            },
            {
                elem: 'content-loading-message',
                content: iget2('p-recommendations', 'data-is-loading', 'Данные загружаются…')
            }
        ];
    })
);
