/**
 * Popup замены НЕ доступных целей во всех условиях
 */
BEM.DOM.decl({ block: 'p-retargeting-conditions', elem: 'replace' }, {

    /**
     * Обновляет список целей
     * @param {Array} currentNotAvailableGoals
     * @private
     */
    _updateListGoals: function(currentNotAvailableGoals) {
        var parent = this.getParent();

        BEM.DOM.update(
            this.elem('replace-list-goals'),
            BEMHTML.apply(currentNotAvailableGoals.map(function(id) {
                var goal = u['b-retargetings-data'].getGoalById(id, parent.goals);

                return {
                    block: 'p-retargeting-conditions',
                    elem: 'replace-row',
                    content: [
                        {
                            elem: 'old-goal',
                            content: ':: ' + u.escapeHTML(goal.name)
                        },
                        {
                            elem: 'new-goal',
                            content: {
                                block: 'select',
                                js: { elemPopupMods: { for: 'replace-goals' } },
                                name: id ,
                                mix: [{ block: 'p-retargeting-conditions', elem: 'replace-goals' }],
                                content: [
                                    {
                                        block: 'button',
                                        content: ''
                                    },
                                    {
                                        elem: 'control',
                                        content: u['b-retargetings-data'].getAvailableGoalsList(parent.goals)
                                            .map(function(goal) {
                                                return {
                                                    elem: 'option',
                                                    attrs: { value: goal.id },
                                                    content: u['b-retargetings-data'].getGoalName(goal.id, parent.goals)
                                                };
                                            })
                                    }
                                ]
                            }
                        }
                    ]
                };
            }))
        );
    },

    /**
     * Замена целей условий ретаргетинга
     * @param {Array} replacementGoals
     * @param {Function} [onSuccess]
     * @param {Function} [onFail]
     * @private
     */
    _replaceGoals: function(replacementGoals, onSuccess, onFail) {
        u['retargeting-dataprovider'].replaceGoals(replacementGoals)
            .then(function(response) {
                if (response.success) {
                    $.isFunction(onSuccess) && onSuccess(replacementGoals);
                } else {
                    $.isFunction(onFail) && onFail(u._.get(response, 'validation_result.errors'));
                }
            })
            .catch(function() {
                $.isFunction(onFail) && onFail();
            });
    },

    /**
     * Функция на успешную замену целей
     * фильтрует цели, обновляет модели, перерисовывает контент
     * @private
     */
    _onReplaceGoalsSuccess: function(replacementGoals) {
        var goals = this.getParent().goals,

            // Запоминаем соответствие старой цели к новой
            // Удаляем из this._goals недоступную цель
            // mapping — {Object} { old_goal_id: new_goal_id }
            mapping = replacementGoals.reduce(function(res, change) {
                res[change.old_goal_id] = change.new_goal_id;

                delete goals[change.old_goal_id];

                return res;
            }, {}),

            // Находим и запоминаем условия в которых заменились цели
            // changedConditions — {Array}
            changedConditions = BEM.MODEL.get('m-retargeting-condition').reduce(function(res, c) {
                var condition = c.toJSON(),
                    isAccessible = true,
                    hasChangedGoals;

                condition.groups.forEach(function(group) {
                    group.goals.forEach(function(goal) {
                        if (Object.keys(mapping).indexOf(goal.id) != -1) {
                            goal.id = mapping[goal.id];
                            hasChangedGoals = true;
                        }

                        // Проверяем доступность целей
                        u['b-retargetings-data'].isGoalAvailable(goal.id, goals) || (isAccessible = false);
                    })
                });

                // Если в условии есть измененные цели, заменяем в условие is_accessible,
                // в зависимости от доступности его целей
                if (hasChangedGoals) {
                    condition.is_accessible = isAccessible;
                    res.push(condition);
                }

                return res;
            }, []);

        // Обновляем модели измененных условий
        changedConditions.forEach(function(condition) {
            BEM.MODEL.getOne({ name: 'm-retargeting-condition', id: condition.ret_cond_id }).update(condition);
        });

        // Перерисовываем контент страницы
        this.getParent().renderConditions();
    },

    /**
     * Обработчик неудочной попытки замены целей/сегментов
     * @param {Object[]} [errors]
     * @private
     */
    _onReplaceGoalsFail: function(errors) {
        var message = errors && errors.length ?
            errors
                .map(function(error) { return error.description || error.text })
                .join('\n') :
            iget2(
                'p-retargeting-conditions',
                'pri-zamene-celey-segmentov',
                'При замене целей/сегментов произошла ошибка. Попробуйте еще раз.'
            );

        BEM.blocks['b-confirm'].alert(message);
    },

    /**
     * Обработчик события click по кнопке «Сохранить»
     * Собирает данные для замены целей
     * @private
     */
    _onApplyClick: function() {
        var replacementGoals = [];

        this.getParent().findElem(this._popupReplace.domElem, 'replace-goals')
            .each(function(i, el) {
                var select = this.findBlockOn($(el), 'select');

                select && replacementGoals.push({
                    old_goal_id: select.name(),
                    new_goal_id: select.val()
                });
            }.bind(this));

        this._replaceGoals(
            replacementGoals,
            this._onReplaceGoalsSuccess.bind(this),
            this._onReplaceGoalsFail.bind(this)
        );

        this._popupReplace.hide();
    },

    /**
     * Обработчик события click по кнопке «Отмена»
     * @private
     */
    _onCancelClick: function() {
        this._popupReplace.hide();
    },

    /**
     * Обработчик события click по кнопкам
     * @param {Event} e
     * @private
     */
    _onActionButtonClick: function(e) {

        if (!e.block.hasMod('action')) return;

        var button = e.block;

        switch (button.getMod('action')) {
            case 'apply':
                this._onApplyClick();
                break;
            case 'cancel':
                this._onCancelClick();
                break;
        }
    },

    /**
     * Popup замены целей
     * {BEM.DOM}
     * @private
     */
    _popupReplace: null,

    /**
     * Отрисовка Popup
     * @param {Array} currentGoals — массив id НЕ доступных целей
     * @private
     */
    _renderPopupReplace: function(currentGoals) {
        if (!this._popupReplace) {
            BEM.DOM.append(this.domElem, BEMHTML.apply({
                block: 'p-retargeting-conditions',
                elem: 'replace-popup'
            }));

            this._popupReplace = this.findBlockInside('replace-popup', 'popup');

            BEM.blocks['button'].on(this.elem('popup-actions'), 'click', this._onActionButtonClick, this);
        }

        this._updateListGoals(currentGoals);
        this._popupReplace.show();
    }

}, {

    live: function() {

        this.liveInitOnParentEvent('replace', function(e, data) {
            this._renderPopupReplace(data.currentGoals);
        });

    }

});
