block('p-retargeting-conditions')(
    elem('warning').replace()(function() {
        return applyCtx({
            block: 'link',
            mods: {
                inner: 'yes',
                pseudo: 'yes',
                theme: 'direct'
            },
            mix: [{
                block: 'p-retargeting-conditions',
                elem: 'warning',
                js: { conditionId: this.ctx.conditionId }
            }],
            content: [
                {
                    block: 'icon',
                    mods: { 'size-12': 'alert' },
                    mix: [{
                        block: 'link',
                        elem: 'icon'
                    }]
                },
                {
                    elem: 'inner',
                    content: iget2('p-retargeting-conditions', 'uslovie-mozhet-rabotat-nepravilno', 'Условие может работать неправильно')
                }
            ]
        });
    }),

    elem('warning-popup').replace()(function() {
        return applyCtx({
            block: 'popup',
            js: { directions: 'right' },
            mods: { 'has-close': 'yes' },
            mix: [{
                block: 'p-retargeting-conditions',
                elem: 'warning-popup'
            }],
            content: [
                { elem: 'tail' },
                {
                    elem: 'content',
                    content: [
                        {
                            block: 'p-retargeting-conditions',
                            elem: 'popup-title',
                            content: iget2('p-retargeting-conditions', 'uslovie-s-br-mozhet', 'Условие {foo}<br/>может работать неправильно', {
                                foo: u.escapeHTML(this.ctx.conditionName)
                            })
                        },
                        {
                            block: 'p-retargeting-conditions',
                            elem: 'warning-text',
                            content: [
                                iget2('p-retargeting-conditions', 'celi-i-ili-segmenty', 'Цели и/или сегменты'),
                                {
                                    elem: 'warning-goals',
                                    tag: 'span',
                                    content: ['"', this.ctx.currentNames, '"'].join('')
                                },
                                '&mdash;&nbsp;',
                                iget2(
                                    'p-retargeting-conditions',
                                    'vhodyashchie-v-uslovie-byli',
                                    'входящие в условие, были удалены, или стали недоступны по другой причине.'
                                )
                            ]
                        },
                        {
                            block: 'p-retargeting-conditions',
                            elem: 'popup-actions',
                            content: [
                                {
                                    block: 'button',
                                    mods: { action: 'cancel' },
                                    content: iget2('p-retargeting-conditions', 'otmena', 'Отмена')
                                },
                                { elem: 'selected-action' },
                                {
                                    block: 'button',
                                    mods: { action: 'apply' },
                                    content: iget2('p-retargeting-conditions', 'vypolnit', 'Выполнить')
                                }
                            ]
                        }
                    ]
                }
            ]
        });
    }),

    elem('selected-action').replace()(function() {
        return {
            block: 'select',
            mix: [{
                block: 'p-retargeting-conditions',
                elem: 'selected-action'
            }],
            content: [
                {
                    block: 'button',
                    content: iget2('p-retargeting-conditions', 'redaktirovat-uslovie', 'Редактировать условие')
                },
                {
                    elem: 'control',
                    // Выставляем в js
                    content: []
                }
            ]
        };
    })
);
