/**
 * Предупреждение и Popup предупреждения
 * о НЕ доступности целей с выбором действий
 */
BEM.DOM.decl({ block: 'p-retargeting-conditions', elem: 'warning' }, {

    /**
     * Модель условия
     * {BEM.MODEL}
     * @private
     */
    _modelCondition: null,

    /**
     * Возвращает модель условия по id
     * @returns {BEM.MODEL}
     * @private
     */
    _getConditionModel: function() {
        return this._modelCondition ||
            (this._modelCondition = this.getParent().getConditionModel(this.params.conditionId));
    },

    /**
     * Выбранные НЕ доступные цели
     * {Array}
     * @private
     */
    _currentGoals: null,

    /**
     * Названия выбранных НЕ доступных целей
     * {String}
     * @private
     */
    _currentNames: null,

    /**
     * Возвращает выбранные, НЕ доступные цели условия
     * @private
     */
    _getCurrentNotAvailable: function() {
        var parent = this.getParent(),
            currentNames = [],
            currentGoals = [];

        this._getConditionModel().get('groups').forEach(function(condition) {
            condition.goals.forEach(function(goal) {
                var id = goal.id;

                if (!u['b-retargetings-data'].isGoalAvailable(id, parent.goals)) {
                    currentGoals.push(id);
                    currentNames.push(u['b-retargetings-data'].getGoalName(id, parent.goals));
                }
            });
        });

        this._currentGoals = currentGoals;
        this._currentNames = currentNames.join(', ');
    },

    /**
     * Popup
     * @private
     */
    _popupWarning: null,

    /**
     * Создаёт и возвращает popup с контентом
     * @returns {BEM}
     * @private
     */
    _renderPopupWarning: function() {
        this._getCurrentNotAvailable();

        if (!this._popupWarning) {
            BEM.DOM.append(this.domElem, BEMHTML.apply({
                block: 'p-retargeting-conditions',
                elem: 'warning-popup',
                conditionName: this._getConditionModel().get('condition_name'),
                currentNames: this._currentNames
            }));

            this._popupWarning = this.findBlockInside('warning-popup', 'popup');

            this._setOptionsSelect();

            BEM.blocks['button'].on(this.elem('popup-actions'), 'click', this._onActionButtonClick, this);
        }
    },

    /**
     * Обработчик события click по кнопке «Выполнить»
     * триггерит события ['edit', 'replace', 'stop']
     * @private
     */
    _onApplyClick: function() {
        var parent = this.getParent();

        switch (this._getSelectedAction().val()) {
            case 'edit':
                parent.editCondition(this.params.conditionId);
                break;
            case 'replace':
                parent.trigger('replace', { currentGoals: this._currentGoals });
                break;
            case 'stop':
                this._stopCondition(
                    [this.params.conditionId],
                    this._onStopConditionSuccess.bind(this),
                    this._onStopConditionFail.bind(this)
                );
                break;
            default:
                break;
        }

        this._popupWarning.hide();
    },

    /**
     * Обработчик удачной остановки услови ретаргетинга
     * @private
     */
    _onStopConditionSuccess: function() {
        this._setOptionsSelect(true);
    },

    /**
     * Обработчик неудачной остановки услови ретаргетинга
     * @param {Object[]} [errors]
     * @private
     */
    _onStopConditionFail: function(errors) {
        var message = errors && errors.length ?
            errors
                .map(function(error) { return error.description || error.text })
                .join('\n') :
            iget2(
                'p-retargeting-conditions',
                'pri-ostanovke-usloviya-proizoshla',
                'При остановке условия произошла ошибка. Попробуйте еще раз.'
            );

        BEM.blocks['b-confirm'].alert(message);
    },

    /**
     * Обработчик события click по кнопке «Отмена»
     * @private
     */
    _onCancelClick: function() {
        this._popupWarning.hide();
    },

    /**
     * Устанавливает пункты селекта
     * @param {Boolean} [stop] НЕ доступная цель была остановлена
     * @private
     */
    _setOptionsSelect: function(stop) {
        this._getSelectedAction().setOptions([
            {
                item: 'option',
                value: 'edit',
                disabled: !this.getParent().hasAvailableGoals,
                content: iget2('p-retargeting-conditions', 'redaktirovat-uslovie', 'Редактировать условие')
            },
            {
                item: 'option',
                value: 'stop',
                disabled: stop,
                content: iget2('p-retargeting-conditions', 'ostanovit-uslovie', 'Остановить условие')
            },
            {
                item: 'option',
                value: 'replace',
                disabled: !this.getParent().hasAvailableGoals,
                content: iget2('p-retargeting-conditions', 'zamenit-cel-segment', 'Заменить цель/сегмент')
            }
        ]);
    },

    /**
     * Остановка условий ретаргетинга
     * @param {Array} conditionIds условий
     * @param {Function} [onSuccess] обработчик успеха
     * @param {Function} [onFail] обработчик неудачи
     */
    _stopCondition: function(conditionIds, onSuccess, onFail) {
        return u['retargeting-dataprovider'].suspendConditions(conditionIds)
            .then(function(response) {
                if (response.success) {
                    $.isFunction(onSuccess) && onSuccess();
                } else {
                    $.isFunction(onFail) && onFail(u._.get(response, 'validation_result.errors'));
                }
            })
            .catch(function() {
                $.isFunction(onFail) && onFail();
            });
    },

    /**
     * Выбранное действия
     * @private
     */
    _selectedAction: null,

    /**
     * Возвращает действие
     * @private
     */
    _getSelectedAction: function() {
        return this._selectedAction || (this._selectedAction = this.findBlockOn('selected-action', 'select'));
    },

    /**
     *
     * @param {Event} e
     * @private
     */
    _onActionButtonClick: function(e) {

        if (!e.block.hasMod('action')) return;

        var button = e.block;

        switch (button.getMod('action')) {
            case 'apply':
                this._onApplyClick();
                break;
            case 'cancel':
                this._onCancelClick();
                break;
        }
    },

    /**
     * Обработчик события click на элементе
     * открывает popup
     * @private
     */
    _onSwitcherClick: function() {
        this.getParent().popupCondition && this.getParent().popupCondition.hide();

        this._renderPopupWarning();
        this._popupWarning.show(this.domElem);
    }

}, {

    live: function() {

        this.liveInitOnBlockEvent('click', 'link', function() {
            this._onSwitcherClick();
        });

    }

});
