match(function() {
    return this.data.cmd === 'showRetargetingCond';
})(

    block('app-main').mode('page-block')('p-retargeting-conditions'),

    block('b-page').mode('title')(function() {
        return iget2('p-retargeting-conditions', 'spisok-usloviy-podbora-auditorii', 'Список условий подбора аудитории');
    })
);

block('p-retargeting-conditions')(

    addJs()(function() {
        return {
            ulogin: this.data.user_login
        };
    }),

    content()(function() {
        var data = this.data,
            ulogin = data.user_login,
            conditions = u.retargeting.filterConditionsByType(data.all_retargeting_conditions || {}, 'metrika_goals'),
            hasRetargetingsUsedInCampaigns = Object.keys(conditions)
                .some(function(consditionId) {
                    var campaigns = conditions[consditionId].campaigns;
                    return campaigns && campaigns.length;
                }),
            isDnaHeaderAndSidebarEnabled = u.consts('rights').isDnaHeaderAndSidebarEnabled,
            metrikaLink = {
                block: 'p-retargeting-conditions',
                elem: 'link',
                content: {
                    block: 'link',
                    url: u.getUrl('requestAccessToMetrikaCounters', {
                        ulogin: ulogin
                    }),
                    content: iget2('p-retargeting-conditions', 'poluchit-dostup-k-celyam', 'Получить доступ к целям Метрики')
                }
            },
            firstRowCenter = [
                {
                    block: 'b-page-title',
                    mix: [{
                        block: 'p-retargeting-conditions',
                        elem: 'title'
                    }],
                    title: iget2('p-retargeting-conditions', 'spisok-usloviy-podbora-auditorii', 'Список условий подбора аудитории')
                },
                isDnaHeaderAndSidebarEnabled && metrikaLink,
                {
                    block: 'p-retargeting-conditions',
                    elem: 'info',
                    content: [
                        iget2(
                            'p-retargeting-conditions',
                            'eti-usloviya-ispolzuyutsya-dlya',
                            'Эти условия используются для показа объявлений и корректировки ставок. Каждое условие представляет собой комбинацию {targets}/{msegments} Яндекс.Метрики или {asegments} Яндекс.Аудиторий.',
                            {
                                targets: function(text) {
                                    return {
                                        block: 'link',
                                        mods: {
                                            theme: 'without-border'
                                        },
                                        target: '_blank',
                                        url: u.getCommonHelpUrl('metrika/reports/add-goals.xml'),
                                        content: text
                                    };
                                }(iget2('p-retargeting-conditions', 'eti-usloviya-ispolzuyutsya-dlya-param-targets', 'целей')),

                                msegments: function(text) {
                                    return {
                                        block: 'link',
                                        mods: {
                                            theme: 'without-border'
                                        },
                                        target: '_blank',
                                        url: u.getCommonHelpUrl('metrika/general/segmentation.xml'),
                                        content: text
                                    };
                                }(iget2('p-retargeting-conditions', 'eti-usloviya-ispolzuyutsya-dlya-param-msegments', 'сегментов')),

                                asegments: function(text) {
                                    return {
                                        block: 'link',
                                        mods: {
                                            theme: 'without-border'
                                        },
                                        target: '_blank',
                                        url: u.getCommonHelpUrl('audience/segments.xml'),
                                        content: text
                                    };
                                }(iget2('p-retargeting-conditions', 'eti-usloviya-ispolzuyutsya-dlya-param-asegments', 'сегментов')),

                                context: 'targets - целей; msegments - сегментов; asegments - сегментов'
                            }
                        ),
                        ' ',
                        {
                            block: 'link',
                            mods: {
                                theme: 'without-border'
                            },
                            target: '_blank',
                            url: u.getCommonHelpUrl('direct/features/retargeting.xml'),
                            content: iget2('p-retargeting-conditions', 'podrobnee-o-nastroyke-usloviy', 'Подробнее о настройке условий')
                        }
                    ]
                }
            ],
            secondRowCenter = [
                {
                    block: 'p-retargeting-conditions',
                    elem: 'table-wrap'
                },
                {
                    block: 'link',
                    mods: {
                        pseudo: 'yes',
                        style: 'without-border'
                    },
                    mix: [{
                        block: 'p-retargeting-conditions',
                        elem: 'new-condition'
                    }],
                    content: [
                        {
                            block: 'icon',
                            mix: [{
                                block: 'p-retargeting-conditions',
                                elem: 'add-icon'
                            }],
                            mods: {
                                'size-12': 'plus'
                            }
                        },
                        iget2('p-retargeting-conditions', 'novoe-uslovie', 'Новое условие')
                    ]
                },
                {
                    block: 'button',
                    mix: [{
                        block: 'p-retargeting-conditions',
                        elem: 'multi-delete'
                    }],
                    mods: {
                        disabled: 'yes'
                    },
                    content: iget2('p-retargeting-conditions', 'udalit-vybrannye', 'Удалить выбранные')
                },
                hasRetargetingsUsedInCampaigns && {
                    block: 'icon-text',
                    mods: {
                        theme: 'alert',
                        size: 'ms'
                    },
                    mix: [{
                        block: 'p-retargeting-conditions',
                        elem: 'remove-warning'
                    }],
                    text: iget2(
                        'p-retargeting-conditions',
                        'udalit-mozhno-tolko-te',
                        'Удалить можно только те условия, которые не используются в кампаниях'
                    )
                }
            ];

        if (isDnaHeaderAndSidebarEnabled) {
            return {
                elem: 'new-retargeting-content',
                content: [
                    {
                        block: 'b-retargetings-data'
                    },
                    firstRowCenter,
                    secondRowCenter,
                    {
                        elem: 'replace',
                        js: true
                    }
                ]
            };
        }

        return [
            {
                block: 'b-retargetings-data'
            },
            {
                block: 'l-page',
                mix: [{
                    block: 'p-retargeting-conditions',
                    elem: 'layout'
                }],
                mods: {
                    layout: '16-60-16'
                },
                content: [
                    {
                        elem: 'row',
                        left: [
                            metrikaLink,
                            {
                                block: 'p-retargeting-conditions',
                                elem: 'link',
                                content: {
                                    block: 'link',
                                    url: u.getUrl('showCamps', {
                                        ulogin: ulogin
                                    }),
                                    content: iget2('p-retargeting-conditions', 'nazad-k-spisku-kampaniy', 'Назад к списку кампаний')
                                }
                            }
                        ],
                        center: firstRowCenter,
                        rgap: true,
                        right: true
                    },
                    {
                        elem: 'row',
                        left: true,
                        center: secondRowCenter,
                        rgap: true,
                        right: true
                    }
                ]
            },
            {
                elem: 'replace',
                js: true
            }
        ];
    })
);
