BEM.DOM.decl('p-retargeting-conditions', {

    /**
     * @type Boolean флаг игнорировать реакцию "выделить/снять галки на всех чекбоксах"
     * Флаг нужен для того, чтобы игнорировать смену выбранность "главного чекбокса", вызванную непользовательскими действиями
     */
    _ignoreNextCheckedAll: false,

    onSetMod: {

        js: function() {
            BEM.blocks['b-group-retargeting-condition']
                .on(this.elem('table-wrap'), 'edit', function(e, data) {
                    this.editCondition(data.conditionId);
                }, this)
                .on(this.elem('table-wrap'), 'remove', function(e, data) {
                    this._removeConditions([data.conditionId]);
                }, this);

            BEM.blocks['checkbox'].on('change', this.elem('table-wrap'), function(e, data) {
                var checkbox = e.block,
                    isSelectAll = this.findElem(checkbox.domElem, 'select-all').length;

                if (isSelectAll) {
                    this._ignoreNextCheckedAll || this._setAllCheckboxesState(checkbox.isChecked());
                    if (this._ignoreNextCheckedAll) {
                        this._ignoreNextCheckedAll = false;
                    }
                } else {
                    this._onCheckboxClick();
                }
            }, this);

            this._multiDelete = this.findBlockInside('multi-delete', 'button')
                .on('click', function() {
                    var checkboxes = this.findBlocksOn(this.findElem('condition-checkbox'), 'checkbox')
                            .filter(function(checkbox) {
                                return checkbox.isChecked();
                            }),
                        ids = checkboxes.map(function(checkbox) { return this.getMod(checkbox.domElem, 'id'); }, this);

                    this._removeConditions(ids, function() {
                        this._multiDelete.setMod('disabled', 'yes');
                    }.bind(this));
                }, this);
        }

    },

    /**
     * Экземпляр блока i-request_type_ajax
     * @returns {BEM}
     * @private
     */
    _request: null,

    /**
     * Возвращает экземпляр блока i-request_type_ajax
     * @returns {BEM}
     * @private
     */
    getRequest: function() {
        return this._request || (this._request = BEM.create('i-request_type_ajax', {
            url: '/registered/main.pl',
            dataType: 'json',
            type: 'POST',
            callbackCtx: this
        }));
    },

    /**
     * Возвращает модель условия по id
     * @returns {BEM.MODEL}
     * @private
     */
    getConditionModel: function(conditionId) {
        return BEM.MODEL.getOne({ name: 'm-retargeting-condition', id: conditionId });
    },

    /**
     * Popup пустой
     * {BEM.DOM}
     * @private
     */
    _popupEmpty: null,

    /**
     * Popup
     * {BEM.DOM}
     */
    popupCondition: null,

    /**
     * Все цели для логина
     * {Object}
     */
    goals: null,

    /**
     * Есть доступные цели
     * {Boolean}
     */
    hasAvailableGoals: null,

    /**
     * Получает цели для логина
     * @private
     */
    _getGoals: function() {
        if (!this.goals) {
            u['retargeting-dataprovider'].getGoalList()
                .then(function(goals) {
                    var formattedGoals = u['b-retargetings-data'].formatGoalList(goals);

                    this.goals = formattedGoals;
                    this.hasAvailableGoals = u['b-retargetings-data'].hasAvailableGoals(formattedGoals);

                    this.renderConditions();
                }.bind(this))
                .catch(function() {
                    this.renderConditions();
                }.bind(this));
        }
    },

    _getRetargetingConditionModel: function(conditionId) {
        var conditionModel;

        BEM.MODEL.get('m-retargeting-condition').some(function(model) {
            if (model.get('ret_cond_id') === conditionId) {
                conditionModel = model;
                return true;
            }

            return false;
        });

        return conditionModel;
    },

    /**
     * Редактирование условия
     * @param {Number} conditionId условия
     */
    editCondition: function(conditionId) {
        var dna = window.dna,
            target = $('<div/>'),
            isNew = conditionId === 0,
            conditionModel = isNew ? undefined : this._getRetargetingConditionModel(conditionId),
            editComponent;

        target.appendTo(document.body);

        editComponent = dna.reactCreateElement(
            dna.components.ClientRetargetingConditionEditorModal,
            {
                login: u.consts('ulogin'),
                isNew: isNew,
                isLalSegmentsEnabled: u.consts('isLalSegmentsEnabled'),
                isRetargetingOnlyLalEnabled: u.consts('isRetargetingOnlyLalEnabled'),
                isRetargetingAndAudienceImprovementsEnabled: u.hasClientFeature('retargeting_and_audience_improvements'),
                inAppMobileTargeting: u.hasClientFeature('in_app_mobile_targeting'),
                conditionData: conditionModel &&
                    dna.utils.mapRetargetingConditionDataFromOldInterface(conditionModel.toJSON()),
                isConditionUsedInCampaigns: conditionModel && conditionModel.get('campaigns').length > 0,
                onSaveSuccess: function(data, savedAsNew) {
                    var newData = dna.utils.mapRetargetingConditionDataToOldInterface(data);

                    if (savedAsNew) {
                        conditionModel = BEM.MODEL.create({
                            name: 'm-retargeting-condition',
                            id: newData.ret_cond_id
                        }, {
                            is_accessible: true
                        });
                    }

                    conditionModel.update(newData);
                    this.renderConditions();

                    dna.reactDOMUnmount(target.get(0));
                    target.remove();
                }.bind(this),
                clientFeatures: u.consts('clientFeaturesAll'),
                operatorFeatures: u.consts('operatorFeaturesAll')
            },
            null
        );

        dna.reactDOMRender(editComponent, target.get(0));
    },

    /**
     * Удаление условий ретаргетинга
     * @param {Array} ids номера условий
     * @param {Function} onDelete успешное удаление указанных условий
     * @private
     */
    _removeConditions: function(ids, onDelete) {
        BEM.blocks['b-confirm'].open({
            message: iget2('p-retargeting-conditions', 'vy-uvereny-chto-hotite-100', 'Вы уверены, что хотите удалить выбранные условия?'),
            onYes: function() {
                u['retargeting-dataprovider'].deleteCondition(ids)
                    .then(function(response) {
                        if (response.success) {
                            ids.forEach(function(id) {
                                var model = this.getConditionModel(id);

                                model && model.destruct();
                            }, this);

                            $.isFunction(onDelete) && onDelete(ids);

                            this.renderConditions();
                        } else {
                            this._onRemoveConditionsFailure(u._.get(response, 'validation_result.errors'));
                        }
                    }.bind(this))
                    .catch(function() {
                        this._onRemoveConditionsFailure();
                    });
            }
        }, this);
    },

    /**
     * Отображает ошибки неудачи удаления условия ретаргетинга
     * @param {{}[]} [errors]
     * @private
     */
    _onRemoveConditionsFailure: function(errors) {
        BEM.blocks['b-confirm'].alert(
            errors && errors.length ?
                errors
                    .map(function(error) {
                        return error.description || error.text;
                    })
                    .join('\n') :
                iget2(
                    'p-retargeting-conditions',
                    'pri-udalenii-usloviya-proizoshla',
                    'При удалении условия произошла ошибка, повторите попытку позже.'
                )
        );
    },

    /**
     * Возвращает массив условий для таблицы
     * @returns {Array}
     * @private
     */
    _getConditionsTableData: function() {
        return BEM.MODEL.get('m-retargeting-condition').map(function(c) {
            var condition = c.toJSON();

            condition.domains = u['b-retargetings-data'].getConditionDomainsList(condition, this.goals).join(', ');

            return condition;
        }, this);
    },

    /**
     * Отображает таблицу условий ретаргетинга
     */
    renderConditions: function() {
        // Разбиваем все условия на чанки по 50, и рендерим их по чанкам
        // Это нужно т.к. иногда i-bem не справляется с инитом всей таблицы сразу и падает
        // с ошибкой Maximum call stack size exceeded
        var CHUNK_SIZE = 50,
            conditions = this._getConditionsTableData(),
            conditionsChunks = u._.chunk(conditions, CHUNK_SIZE),
            tableWrap = this.elem('table-wrap');

        // Перед рендерингом удаляем старую таблицу. Внутри BEM.DOM.update происходит destruct,
        // который точно так же падает с ошибкой при попытке выполниться на полностью отрендеренной таблице
        tableWrap.html('');

        // Обвязка таблицы (блок p-retargeting-conditions) рисуется только для первого чанка
        BEM.DOM.update(tableWrap, BEMHTML.apply({
            block: 'p-retargeting-conditions',
            elem: 'table',
            conditions: conditionsChunks[0],
            ulogin: u.consts('ulogin')
        }));

        // Все дальнейшие чанки будут вставляться непосредственно в тело таблицы
        var tableBody = this
            .findBlockInside('b-data-table')
            .findElem('body');

        for (var chunkIndex = 1; chunkIndex < conditionsChunks.length; chunkIndex++) {
            var chunk = conditionsChunks[chunkIndex];

            // Заполняем поле _rowIndex для правильной нумерации строк в таблице
            // Для начального чанка это делает блок b-data-table
            for (var rowIndex = 0; rowIndex < chunk.length; rowIndex++) {
                chunk[rowIndex]._rowIndex = chunkIndex * CHUNK_SIZE + rowIndex;
            }

            // Сначала рендерим все строки, и только потом вставляем все сразу в DOM,
            // чтобы уменьшить количество дорогих операций
            var chunkHtml = chunk
                .map(this._renderTableRow)
                .join('')

            BEM.DOM.append(tableBody, chunkHtml);
        }

        return this;
    },

    /**
     * Возвращает HTML для одной строки таблицы условий ретаргетинга
     * @param {Object} row Данные для рендерига строки
     * @returns {String}
     */
    _renderTableRow: function(row) {
        var columns = u.retargeting.getRetargetingConditionsColumns(),
            mixes = u.retargeting.getRetargetingConditionsMixes();

        return BEMHTML.apply({
            block: 'b-data-table',
            elem: 'row',
            mix: mixes && mixes.row,
            cellMixes: mixes && mixes.cell,
            row: row,
            columns: columns
        });
    },

    /**
     * Установка стейтов всех чекбоксов в таблице условий
     * @param {Boolean} state
     * @private
     */
    _setAllCheckboxesState: function(state) {
        var wasChanged = false;

        this.findBlocksOn(this.findElem('condition-checkbox'), 'checkbox').forEach(function(checkbox) {
            if (!checkbox.hasMod('disabled')) {
                checkbox.setMod('checked', state ? 'yes' : '');
                wasChanged = true;
            }
        });
        this._multiDelete.setMod('disabled', state && wasChanged ? '' : 'yes');
    },

    /**
     * Обработчик события клика на чекбоксе
     * @private
     */
    _onCheckboxClick: function() {
        var checkedNum = 0,
            allNonDisabledNum = 0,
            blockCheckboxAll = this.findBlockOn(this.findElem('select-all'), 'checkbox');

        this.findBlocksOn(this.findElem('condition-checkbox'), 'checkbox').forEach(function(checkbox) {
            !checkbox.hasMod('disabled') && allNonDisabledNum++;
            checkbox.isChecked() && checkedNum++;

        });

        this._multiDelete.setMod('disabled', checkedNum ? '' : 'yes');

        if (blockCheckboxAll.isChecked() !== (checkedNum === allNonDisabledNum)) {
            this._ignoreNextCheckedAll = true;
            blockCheckboxAll.setMod('checked', checkedNum === allNonDisabledNum ? 'yes' : '');
        }
    }

}, {

    live: function() {
        this
            .liveInitOnBlockInsideEvent('init','b-retargetings-data', function() {
                this._getGoals();
            })
            .liveBindTo('new-condition', 'click', function(e) {
                this.editCondition(0);
            });
    }

});
