block('p-search').elem('campaigns-form')(

    replace()(function() {
        return {
            block: 'b-search-form',
            mix: [{
                block: 'p-search',
                elem: 'campaigns-form'
            }],
            title: iget2('p-search', 'poisk-kampaniy', 'Поиск кампаний'),

            hiddenInputs: [
                {
                    name: 'cmd',
                    value: 'search'
                },
                {
                    name: 'who',
                    value: 'camps'
                }
            ],

            inputs: [
                {
                    label: {
                        content: iget2('p-search', 'nomer-direkt', 'Номер (Директ)'),
                        id: 'camp-num'
                    },
                    input: {
                        block: 'input',
                        content: {
                            elem: 'control',
                            attrs: {
                                id: 'camp-num',
                                name: 'searchcid',
                                value: this.data.searchcid
                            }
                        }
                    }
                },
                hasLoginRights('placer_control', 'support_control', 'super_control', 'superreader_control') && {
                    label: {
                        content: iget2('p-search', 'nomer-bk', 'Номер (БК)'),
                        id: 'camp-order-id'
                    },
                    input: {
                        block: 'input',
                        content: {
                            elem: 'control',
                            attrs: {
                                id: 'camp-order-id',
                                name: 'searchorderid',
                                value: this.data.searchorderid
                            }
                        }
                    }
                },
                {
                    label: {
                        content: iget2('p-search', 'yandeks-login', 'Яндекс.Логин'),
                        id: 'camp-login'
                    },
                    input: {
                        block: 'input',
                        content: {
                            elem: 'control',
                            attrs: {
                                id: 'camp-login',
                                name: 'searchlogin',
                                value: this.data.searchlogin
                            }
                        }
                    }
                },
                {
                    label: {
                        content: iget2('p-search', 'nazvanie', 'Название'),
                        id: 'camp-name'
                    },
                    input: {
                        block: 'input',
                        content: {
                            elem: 'control',
                            attrs: {
                                id: 'camp-name',
                                name: 'searchcampname',
                                value: this.data.searchcampname
                            }
                        }
                    }
                },
                {
                    label: {
                        content: iget2('p-search', 'menedzher', 'Менеджер'),
                        id: 'camp-manager'
                    },
                    input: {
                        block: 'p-search',
                        elem: 'manager-select',
                        name: 'manageruid',
                        value: this.data.FORM.manageruid,
                        id: 'camp-manager',
                        rows: 12
                    }
                },
                {
                    input: {
                        block: 'checkbox',
                        mods: {
                            checked: this.data.FORM.strict_campaign ? 'yes' : ''
                        },
                        checkboxAttrs: {
                            name: 'strict_campaign'
                        },
                        text: iget2('p-search', 'iskat-po-tochnomu-sootvetstviyu', 'искать по точному соответствию')
                    }
                }
            ]
        };
    }),

    match(function() {
        return this.pageParams && this.pageParams.isAgencySearch;
    }).replace()(function() {
        return {
            block: 'b-search-form',
            mix: [{
                block: 'p-search',
                elem: 'campaigns-form'
            }],
            title: iget2('p-search', 'poisk-kampaniy', 'Поиск кампаний'),

            hiddenInputs: [
                {
                    name: 'cmd',
                    value: 'agSearch'
                },
                {
                    name: 'who',
                    value: 'camps'
                }
            ],

            inputs: [
                {
                    label: {
                        content: iget2('p-search', 'nomer', 'Номер'),
                        id: 'camp-num'
                    },
                    input: {
                        block: 'input',
                        content: {
                            elem: 'control',
                            attrs: {
                                id: 'camp-num',
                                name: 'cid',
                                value: this.data.FORM.cid || ''
                            }
                        }
                    }
                },
                {
                    label: {
                        content: iget2('p-search', 'yandeks-login', 'Яндекс.Логин'),
                        id: 'camp-login'
                    },
                    input: {
                        block: 'input',
                        content: {
                            elem: 'control',
                            attrs: {
                                id: 'camp-login',
                                name: 'camp_login',
                                value: this.data.camp_login || ''
                            }
                        }
                    }
                },
                {
                    label: {
                        content: iget2('p-search', 'nazvanie', 'Название'),
                        id: 'camp-name'
                    },
                    input: {
                        block: 'input',
                        content: {
                            elem: 'control',
                            attrs: {
                                id: 'camp-name',
                                name: 'camp_name',
                                value: this.data.camp_name || ''
                            }
                        }
                    }
                },
                {
                    input: {
                        block: 'checkbox',
                        mods: {
                            checked: this.data.FORM.strict_campaign ? 'yes' : ''
                        },
                        checkboxAttrs: {
                            name: 'strict_campaign'
                        },
                        text: iget2('p-search', 'iskat-po-tochnomu-sootvetstviyu', 'искать по точному соответствию')
                    }
                }
            ]
        };
    })
);
