block('p-search').elem('clients-form')(

    replace()(function() {
        return {
            block: 'b-search-form',
            mix: [{
                block: 'p-search',
                elem: 'clients-form'
            }],
            action: this.data.SCRIPT_CLEAR,
            title: iget2('p-search', 'poisk-klientov-agentstv', 'Поиск клиентов/агентств'),

            hiddenInputs: [
                {
                    name: 'cmd',
                    value: 'search'
                },
                {
                    name: 'who',
                    value: 'clients'
                }
            ],

            inputs: [
                {
                    label: {
                        content: iget2('p-search', 'yandeks-login', 'Яндекс.Логин'),
                        id: 'client-login'
                    },
                    input: {
                        block: 'input',
                        content: {
                            elem: 'control',
                            attrs: {
                                id: 'client-login',
                                name: 'listbylogin',
                                value: this.data.listbylogin
                            }
                        }
                    }
                },
                {
                    label: {
                        content: iget2('p-search', 'clientid', 'ClientID'),
                        id: 'client-id'
                    },
                    input: {
                        block: 'input',
                        content: {
                            elem: 'control',
                            attrs: {
                                id: 'client-id',
                                name: 'listbyclientid',
                                value: this.data.listbyclientid
                            }
                        }
                    }
                },
                {
                    label: {
                        content: iget2('p-search', 'nazvanie-klienta', 'Название клиента'),
                        id: 'client-name'
                    },
                    input: {
                        block: 'input',
                        content: {
                            elem: 'control',
                            attrs: {
                                id: 'client-name',
                                name: 'listbyname',
                                value: this.data.listbyname
                            }
                        }
                    }
                },
                {
                    label: {
                        content: iget2('p-search', 'menedzher', 'Менеджер'),
                        id: 'client-manager'
                    },
                    input: {
                        block: 'p-search',
                        elem: 'manager-select',
                        name: 'manageruidforclient',
                        value: this.data.FORM.manageruidforclient,
                        id: 'client-manager',
                        rows: 11
                    }
                },
                {
                    input: {
                        block: 'checkbox',
                        mods: {
                            checked: this.data.FORM.strict_client ? 'yes' : ''
                        },
                        checkboxAttrs: {
                            name: 'strict_client'
                        },
                        text: iget2('p-search', 'iskat-po-tochnomu-sootvetstviyu', 'искать по точному соответствию')
                    }
                }
            ]
        };
    }),

    match(function() {
        return this.pageParams && this.pageParams.isAgencySearch;
    }).replace()(function() {
        return {
            block: 'b-search-form',
            mix: [{
                block: 'p-search',
                elem: 'clients-form'
            }],
            title: iget2('p-search', 'poisk-klientov', 'Поиск клиентов'),

            hiddenInputs: [
                {
                    name: 'cmd',
                    value: 'agSearch'
                },
                {
                    name: 'who',
                    value: 'clients'
                }
            ],

            inputs: [
                {
                    label: {
                        content: iget2('p-search', 'yandeks-login', 'Яндекс.Логин'),
                        id: 'client-login'
                    },
                    input: {
                        block: 'input',
                        content: {
                            elem: 'control',
                            attrs: {
                                id: 'client-login',
                                name: 'cl_login',
                                value: this.data.FORM.cl_login || ''
                            }
                        }
                    }
                },
                {
                    label: {
                        content: iget2('p-search', 'fio-nbsp-klienta', 'ФИО&nbsp;клиента'),
                        id: 'client-name'
                    },
                    input: {
                        block: 'input',
                        content: {
                            elem: 'control',
                            attrs: {
                                id: 'client-name',
                                name: 'cl_name',
                                value: this.data.FORM.cl_name || ''
                            }
                        }
                    }
                },
                {
                    label: {
                        content: iget2('p-search', 'primechanie', 'Примечание'),
                        id: 'client-desc'
                    },
                    input: {
                        block: 'input',
                        content: {
                            elem: 'control',
                            attrs: {
                                id: 'client-desc',
                                name: 'cl_desc',
                                value: this.data.FORM.cl_desc || ''
                            }
                        }
                    }
                },
                {
                    input: {
                        block: 'checkbox',
                        mods: {
                            checked: this.data.FORM.strict_client ? 'yes' : ''
                        },
                        checkboxAttrs: {
                            name: 'strict_client'
                        },
                        text: iget2('p-search', 'iskat-po-tochnomu-sootvetstviyu', 'искать по точному соответствию')
                    }
                }
            ]
        };
    })
);
