block('p-search').elem('manager-select')(

    def()(function() {
        var anyText = iget2('p-search', 'vse-klienty-v-t', 'все клиенты (в т.ч. и несервисируемые)...'),
            allText = iget2('p-search', 'po-vsem-menedzheram', 'по всем менеджерам...'),
            val = this.ctx.value,
            current = val == 'all' ? allText : anyText,
            options = [
                {
                    elem: 'option',
                    attrs: {
                        value: 'any'
                    },
                    content: anyText
                },
                {
                    elem: 'option',
                    attrs: {
                        value: 'all'
                    },
                    content: allText
                }
            ],
            managers = this.data.managers.sort(function(m1, m2) {
                if (m1.fio > m2.fio) return 1;
                if (m1.fio < m2.fio) return -1;
                return 0;
            });

        (val == 'any') && (options[0].attrs.selected = 'selected');
        (val == 'all') && (options[1].attrs.selected = 'selected');

        options = options.concat(managers.map(function(m, n) {
            var text = (n + 1) + '. ' + m.fio + ' (' + m.login + ')',
                opt = {
                    elem: 'option',
                    attrs: {
                        value: m.uid
                    },
                    content: text
                };

            if (val == m.uid) {
                opt.attrs.selected = 'selected';
                current = text;
            }

            return opt;
        }, this));

        return applyNext({
            options: options,
            current: current
        });
    }),

    content()(function() {
        return {
            block: 'select',
            mix: [{
                block: 'p-search',
                elem: 'select'
            }],
            name: this.ctx.name,
            mods: {
                layout: 'content'
            },
            js: {
                rows: this.ctx.rows
            },
            content: [
                {
                    block: 'button',
                    type: 'button',
                    mods: {
                        valign: 'middle'
                    },
                    content: this.current
                },
                {
                    elem: 'control',
                    content: this.options,
                    attrs: this.ctx.id && {
                        id: this.ctx.id
                    }
                }
            ]
        };
    })
);
