match(function() {
    return this.data.cmd === 'showSearchPage' || this.data.cmd === 'search' || this.data.cmd === 'agSearch';
})(

    block('app-main')(

        mode('preprocess')(function() {
            var data = this.data,
                agency,
                campsGroupsNames = [],
                rights = data.login_rights,
                campaigns = data.campaigns_filtered_by_tab || [],
                campaignsLength = campaigns.length,
                controlManagerSuperPlacer = rights.manager_control || rights.super_control || rights.placer_control,
                notSplitWallet = true;

            data.can = {};
            data.can.see_original_sum = controlManagerSuperPlacer || rights.media_control || rights.support_control;

            campaignsLength && campaigns.forEach(function(camp) {
                var group = '3_self', // Самостоятельное обслуживание
                    action = camp.action || {},
                    actionPay = action.pay;

                if (camp.AgencyID != '0') {
                    agency = data.agencies_info[camp.AgencyID];
                    group = agency && agency.freedom ?
                        '2_agency_' + camp.AgencyID : // На обслуживании агентства
                        '4_agencyold_' + camp.AgencyID; // На обслуживании агентства (обслуживание завершено)
                } else if (camp.ManagerUID) {
                    group = '1_carefree'; // На обслуживании менеджером
                }

                this.data.can.showPayColumn || (this.data.can.showPayColumn = actionPay && !camp.noaction);

                campsGroupsNames.indexOf(group) == -1 && campsGroupsNames.push(group);
            }, this);

            notSplitWallet = campsGroupsNames.indexOf('1_carefree') != -1 && campsGroupsNames.indexOf('3_self') != -1 &&
                campsGroupsNames.length == 2 || campsGroupsNames.length == 1;

            data.notSplitWallet = notSplitWallet;

            return data;
        }),

        mode('page-block')(
            match(function() {
                return true;
            })('p-search'),

            match(function() {
                return this.data.cmd === 'agSearch';
            })({
                block: 'p-search',
                mods: {
                    type: 'agency'
                }
            })
        )
    ),

    block('b-page').mode('title')(
        match(function() {
            return true;
        })(function() {
            return iget2('p-search', 'poisk', 'Поиск');
        }),

        match(function() {
            return this.data.cmd === 'agSearch';
        })(function() {
            return iget2('p-search', 'poisk-klientov-i-kampaniy', 'Поиск клиентов и кампаний');
        })
    )
);

block('p-search')(

    def()(function() {
        return applyNext({
            pageParams: {
                // используется в для отображения столбца ClientID
                // ограничивает список действий в b-showclients-list_type_clients
                isAgencySearch: this.data.cmd === 'agSearch',
                readonly: true
            }
        });
    }),

    addJs()(true),

    content()(function() {
        return {
            block: 'l-page',
            mix: [{
                block: 'p-search',
                elem: 'content-layout'
            }],
            mods: {
                layout: '40-40'
            },
            content: [
                {
                    elem: 'row',
                    left: {
                        block: 'p-search',
                        elem: 'clients-form'
                    },
                    rgap: true,
                    right: {
                        block: 'p-search',
                        elem: 'campaigns-form'
                    }
                },
                {
                    elem: 'row',
                    center: [
                        this.data.error && {
                            block: 'p-search',
                            elem: 'error',
                            content: u.escapeHTML(this.data.error)
                        },
                        this.data.strict_search_failed && {
                            block: 'p-search',
                            elem: 'error',
                            content: iget2(
                                'p-search',
                                'rezultaty-po-tochnomu-sootvetstviyu',
                                'Результаты по точному соответствию не найдены. Показаны результаты поиска без учета точного соответствия'
                            )
                        },
                        !this.data.error && (this.data.cmd === 'search') && (this.data.FORM.who == 'camps') && {
                            block: 'p-search',
                            elem: 'campaigns-search-result',
                            content: (function() {
                                var correctCamps = this.data.campaigns;

                                return [
                                    (correctCamps && correctCamps.length ?
                                        {
                                            block: 'b-campaigns-list',
                                            page: 'search',
                                            noTotal: true,
                                            campaigns: correctCamps
                                        } :
                                        {
                                            block: 'p-search',
                                            elem: 'not-found',
                                            content: iget2('p-search', 'kampanii-ne-naydeny', 'Кампании не найдены.')
                                        })
                                ];
                            }.call(this))
                        },
                        !this.data.error && (this.data.cmd === 'search') && (this.data.FORM.who == 'clients') && {
                            block: 'p-search',
                            elem: 'clients-search-result',
                            content: [
                                {
                                    block: 'p-search',
                                    elem: 'all-clients-for-manager'
                                },
                                this.data.users_list && {
                                    block: 'b-clients-list',
                                    clients: this.data.users_list
                                },
                                this.data.ag_list && {
                                    block: 'b-agencies-list',
                                    agencies: this.data.ag_list
                                },
                                this.data.freelancers_list && {
                                    block: 'b-freelancers-list',
                                    freelancers: this.data.freelancers_list
                                },
                                (this.data.login_rights.super_control ||
                                 this.data.login_rights.support_control ||
                                 this.data.login_rights.superreader_control ||
                                 this.data.login_rights.limited_support_control) &&
                                    this.data.FORM.listbylogin && !this.data.FORM.listbyname &&
                                        !this.data.FORM.listbyclientid && !this.data.found_exact && {
                                            block: 'p-search',
                                            elem: 'create-client',
                                            content: [
                                                iget2('p-search', 'sozdat-klienta', 'Создать клиента'),
                                                ' ',
                                                {
                                                    block: 'link',
                                                    content: u.escapeHTML(this.data.FORM.listbylogin),
                                                    url: u.getUrl('stepZeroProcess', {
                                                        newlogin: u.escapeHTML(this.data.FORM.listbylogin),
                                                        from: 'createUser'
                                                    })
                                                }
                                            ]
                                        }
                            ]
                        }
                    ],
                    ctxCells: {
                        center: {
                            attrs: {
                                colspan: 3
                            }
                        }
                    }
                },
                {
                    elem: 'row',
                    center: {
                        block: 'p-search',
                        elem: 'vertical-gap'
                    },
                    rgap: true,
                    right: true
                },
                {
                    elem: 'row',
                    mix: [{
                        block: 'b-search-useful-links'
                    }, {
                        block: 'l-page',
                        elem: 'separator'
                    }],
                    left: {
                        block: 'b-search-useful-links',
                        elem: 'left'
                    },
                    rgap: true,
                    right: {
                        block: 'b-search-useful-links',
                        elem: 'right'
                    }
                }
            ]
        };
    }),

    elem('all-clients-for-manager')(

        def()(function() {
            var uid = this.data.FORM.manageruidforclient,
                managers = this.data.managers;

            return uid == 'any' || uid == 'all' ?
                '' :
                applyNext({
                    selectedManager: (function() {
                        for (var i = 0, l = managers.length; i < l; i++) {
                            if (managers[i].uid == uid) {
                                return managers[i];
                            }
                        }
                    })()
                });
        }),

        match(function() {
            return this.selectedManager;
        }).content()(function() {
            return [
                iget2('p-search', 'vse-klienty-menedzhera', 'Все клиенты менеджера'),
                ': ',
                {
                    block: 'link',
                    target: '_blank',
                    url: this.data.script + '?cmd=showManagerMyClients&ulogin=' + this.selectedManager.login,
                    content: this.selectedManager.fio + ' (' + this.selectedManager.login + ')'
                }
            ];
        })
    )
);
