match(function() {
    return this.data.cmd === 'showExperiments';
})(

    block('app-main').mode('page-block')('p-show-experiments'),

    block('b-page').mode('title')(function() {
        return iget2('p-show-experiments', 'ab-testirovanie', 'AB-тестирование');
    })
);

block('p-show-experiments')(

    addJs()(true),

    content()(function() {
        return {
            block: 'l-page',
            mods: {
                layout: '16-60-16'
            },
            content: [
                {
                    elem: 'row',
                    left: {
                        block: 'p-show-experiments',
                        elem: 'all-camps-link-container',
                        content: {
                            block: 'link',
                            mix: {
                                block: 'p-show-experiments',
                                elem: 'all-camps-link'
                            },
                            url: u.getUrl('showCamps', {
                                ulogin: this.data.user_login
                            }),
                            content: iget2('p-show-experiments', 'vse-kampanii-klienta', 'Все кампании клиента')
                        }
                    },
                    center: {
                        block: 'b-page-title',
                        mix: {
                            block: 'p-show-experiments',
                            elem: 'title'
                        },
                        title: applyCtx({
                            block: 'p-show-experiments',
                            elem: 'title-content'
                        })
                    },
                    right: true
                },
                !hasLoginRights('superreader_control') && {
                    elem: 'row',
                    left: true,
                    center: {
                        block: 'b-experiment-params',
                        campaigns: this.data.campaigns
                    },
                    right: true
                },
                {
                    elem: 'row',
                    left: true,
                    center: {
                        block: 'b-experiment-list',
                        campaigns: this.data.campaigns,
                        experiments: this.data.experiments
                    },
                    right: true
                }
            ]
        };
    }),

    elem('title-content')(

        content()(function() {
            return iget2('p-show-experiments', 'ab-testirovanie', 'AB-тестирование');
        }),

        match(function() {
            return this.data.uid && this.data.UID != this.data.uid;
        }).content()(function() {
            var data = this.data,
                clientTitle = u.escapeHTML(data.user_fio + ' (' + data.user_login + ')');

            return [
                iget2('p-show-experiments', 'ab-testirovanie-dlya-klienta', 'AB-тестирование для клиента') + ':',
                '&nbsp;',
                !data.login_rights.superreader_control ?
                    {
                        block: 'link',
                        url: u.getUrl('modifyUser', {
                            rcmd: 'showCamps',
                            ulogin: data.user_login
                        }),
                        content: clientTitle
                    } :
                    clientTitle
            ];
        })
    )
);
